/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.entity;

import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.common.Nullable;

public class SuggestItem {
    private String text;
    private ZonedDateTime timestamp;
    private long queryFreq;
    private long docFreq;
    private float userBoost;
    private String[][] readings;
    private String[] fields;
    private String[] tags;
    private String[] roles;
    private String[] languages;
    private Kind[] kinds;
    private Map<String, Object> emptySource;
    private String id;

    private SuggestItem() {
    }

    public SuggestItem(String[] text, String[][] readings, String[] fields, long docFreq, long queryFreq, float userBoost, @Nullable String[] tags, @Nullable String[] roles, @Nullable String[] languages, Kind kind) {
        this.text = String.join((CharSequence)" ", text);
        this.readings = readings;
        this.fields = fields != null ? fields : new String[]{};
        String[] stringArray = this.tags = tags != null ? tags : new String[]{};
        if (roles == null || roles.length == 0) {
            this.roles = new String[]{"_guest_"};
        } else {
            this.roles = new String[roles.length];
            System.arraycopy(roles, 0, this.roles, 0, roles.length);
        }
        this.languages = languages != null ? languages : new String[]{};
        this.kinds = new Kind[]{kind};
        this.userBoost = userBoost > 1.0f ? userBoost : 1.0f;
        this.docFreq = docFreq;
        this.queryFreq = queryFreq;
        this.timestamp = ZonedDateTime.now();
        this.emptySource = this.createEmptyMap();
        this.id = SuggestUtil.createSuggestTextId(this.text);
    }

    public String getText() {
        return this.text;
    }

    public String[][] getReadings() {
        return this.readings;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String[] getLanguages() {
        return this.languages;
    }

    public String[] getFields() {
        return this.fields;
    }

    public Kind[] getKinds() {
        return this.kinds;
    }

    public long getQueryFreq() {
        return this.queryFreq;
    }

    public long getDocFreq() {
        return this.docFreq;
    }

    public float getUserBoost() {
        return this.userBoost;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setQueryFreq(long queryFreq) {
        this.queryFreq = queryFreq;
    }

    public void setDocFreq(long docFreq) {
        this.docFreq = docFreq;
    }

    public void setUserBoost(float userBoost) {
        this.userBoost = userBoost;
    }

    public void setReadings(String[][] readings) {
        this.readings = readings;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public void setLanguages(String[] languages) {
        this.languages = languages;
    }

    public void setKinds(Kind[] kinds) {
        this.kinds = kinds;
    }

    public void setEmptySource(Map<String, Object> emptySource) {
        this.emptySource = emptySource;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Object> toEmptyMap() {
        return this.emptySource;
    }

    protected Map<String, Object> createEmptyMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", "");
        for (int i = 0; i < this.readings.length; ++i) {
            map.put("reading_" + i, new String[0]);
        }
        map.put("fields", new String[0]);
        map.put("tags", new String[0]);
        map.put("roles", new String[0]);
        map.put("languages", new String[0]);
        map.put("kinds", new String[0]);
        map.put("score", Float.valueOf(1.0f));
        map.put("queryFreq", 0L);
        map.put("docFreq", 0L);
        map.put("userBoost", Float.valueOf(1.0f));
        map.put("@timestamp", DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now()));
        return map;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getSource() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", this.text);
        for (int i = 0; i < this.readings.length; ++i) {
            String[] values = this.readings[i] == null ? null : (String[])Arrays.stream(this.readings[i]).distinct().toArray(String[]::new);
            map.put("reading_" + i, values);
        }
        map.put("fields", this.fields);
        map.put("tags", this.tags);
        map.put("roles", this.roles);
        map.put("languages", this.languages);
        map.put("kinds", Stream.of(this.kinds).map(Kind::toString).toArray());
        map.put("queryFreq", this.queryFreq);
        map.put("docFreq", this.docFreq);
        map.put("userBoost", Float.valueOf(this.userBoost));
        map.put("score", Float.valueOf((float)(this.queryFreq + this.docFreq) * this.userBoost));
        map.put("@timestamp", this.timestamp.toInstant().toEpochMilli());
        return map;
    }

    public static SuggestItem parseSource(Map<String, Object> source) {
        Object readingObj;
        String text = source.get("text").toString();
        ArrayList<String[]> readings = new ArrayList<String[]>();
        int i = 0;
        while ((readingObj = source.get("reading_" + i)) instanceof List) {
            List list = (List)readingObj;
            readings.add(list.toArray(new String[list.size()]));
            ++i;
        }
        List<String> fields = SuggestUtil.getAsList(source.get("fields"));
        long docFreq = Long.parseLong(source.get("docFreq").toString());
        long queryFreq = Long.parseLong(source.get("queryFreq").toString());
        float userBoost = Float.parseFloat(source.get("userBoost").toString());
        List<String> tags = SuggestUtil.getAsList(source.get("tags"));
        List<String> roles = SuggestUtil.getAsList(source.get("roles"));
        List<String> languages = SuggestUtil.getAsList(source.get("languages"));
        List<String> kinds = SuggestUtil.getAsList(source.get("kinds"));
        long timestamp = Long.parseLong(source.get("@timestamp").toString());
        SuggestItem item = new SuggestItem();
        item.text = text;
        item.readings = (String[][])readings.toArray((T[])new String[readings.size()][]);
        item.fields = fields.toArray(new String[fields.size()]);
        item.docFreq = docFreq;
        item.queryFreq = queryFreq;
        item.userBoost = userBoost;
        item.tags = tags.toArray(new String[tags.size()]);
        item.roles = roles.toArray(new String[roles.size()]);
        item.languages = languages.toArray(new String[languages.size()]);
        item.kinds = new Kind[kinds.size()];
        for (int i2 = 0; i2 < kinds.size(); ++i2) {
            String kind = kinds.get(i2);
            if (kind.equals(Kind.DOCUMENT.toString())) {
                item.kinds[i2] = Kind.DOCUMENT;
                continue;
            }
            if (kind.equals(Kind.QUERY.toString())) {
                item.kinds[i2] = Kind.QUERY;
                continue;
            }
            if (!kind.equals(Kind.USER.toString())) continue;
            item.kinds[i2] = Kind.USER;
        }
        item.id = SuggestUtil.createSuggestTextId(item.text);
        item.timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), Clock.systemDefaultZone().getZone());
        return item;
    }

    public Map<String, Object> getUpdatedSource(Map<String, Object> existingSource) {
        long updatedDocFreq;
        long updatedQueryFreq;
        List existingValues;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", this.text);
        for (int i = 0; i < this.readings.length; ++i) {
            Object readingObj = existingSource.get("reading_" + i);
            if (readingObj instanceof List) {
                existingValues = (List)readingObj;
                SuggestItem.concatValues(existingValues, this.readings[i]);
                map.put("reading_" + i, existingValues.stream().distinct().toList());
                continue;
            }
            String[] values = this.readings[i] == null ? null : (String[])Arrays.stream(this.readings[i]).distinct().toArray(String[]::new);
            map.put("reading_" + i, values);
        }
        Object fieldsObj = existingSource.get("fields");
        if (fieldsObj instanceof List) {
            List existingValues2 = (List)fieldsObj;
            SuggestItem.concatValues(existingValues2, this.fields);
            map.put("fields", existingValues2);
        } else {
            map.put("fields", this.fields);
        }
        Object tagsObj = existingSource.get("tags");
        if (tagsObj instanceof List) {
            existingValues = (List)tagsObj;
            SuggestItem.concatValues(existingValues, this.tags);
            map.put("tags", existingValues);
        } else {
            map.put("tags", this.tags);
        }
        Object rolesObj = existingSource.get("roles");
        if (rolesObj instanceof List) {
            List existingValues3 = (List)rolesObj;
            SuggestItem.concatValues(existingValues3, this.roles);
            map.put("roles", existingValues3);
        } else {
            map.put("roles", this.roles);
        }
        Object langsObj = existingSource.get("languages");
        if (langsObj instanceof List) {
            List existingValues4 = (List)langsObj;
            SuggestItem.concatValues(existingValues4, this.languages);
            map.put("languages", existingValues4);
        } else {
            map.put("languages", this.languages);
        }
        Object kindsObj = existingSource.get("kinds");
        if (kindsObj instanceof List) {
            List existingFields = (List)kindsObj;
            SuggestItem.concatValues(existingFields, (String[])Stream.of(this.kinds).map(Kind::toString).toArray(String[]::new));
            map.put("kinds", existingFields);
        } else {
            map.put("kinds", Stream.of(this.kinds).map(Kind::toString).toArray());
        }
        Object queryFreqObj = existingSource.get("queryFreq");
        if (queryFreqObj == null) {
            updatedQueryFreq = this.queryFreq;
        } else {
            Long existingValue = Long.parseLong(queryFreqObj.toString());
            updatedQueryFreq = this.queryFreq + existingValue;
        }
        map.put("queryFreq", updatedQueryFreq);
        Object docFreqObj = existingSource.get("docFreq");
        if (docFreqObj == null) {
            updatedDocFreq = this.docFreq;
        } else {
            Long existingValue = Long.parseLong(docFreqObj.toString());
            updatedDocFreq = this.docFreq + existingValue;
        }
        map.put("docFreq", updatedDocFreq);
        map.put("userBoost", Float.valueOf(this.userBoost));
        map.put("score", Float.valueOf((float)(updatedQueryFreq + updatedDocFreq) * this.userBoost));
        map.put("@timestamp", this.timestamp.toInstant().toEpochMilli());
        return map;
    }

    protected static <T> void concatValues(List<T> dest, T ... newValues) {
        for (T value : newValues) {
            if (dest.contains(value)) continue;
            dest.add(value);
        }
    }

    protected static Kind[] concatKinds(Kind[] kinds, Kind ... newKinds) {
        if (kinds == null) {
            return newKinds;
        }
        if (newKinds == null) {
            return kinds;
        }
        ArrayList<Kind> list = new ArrayList<Kind>(kinds.length + newKinds.length);
        list.addAll(Arrays.asList(kinds));
        for (Kind kind : newKinds) {
            if (list.contains((Object)kind)) continue;
            list.add(kind);
        }
        return list.toArray(new Kind[list.size()]);
    }

    public static SuggestItem merge(SuggestItem item1, SuggestItem item2) {
        if (!item1.getId().equals(item2.getId())) {
            throw new IllegalArgumentException("Item id is mismatch.");
        }
        SuggestItem mergedItem = new SuggestItem();
        mergedItem.id = item1.getId();
        mergedItem.text = item1.getText();
        mergedItem.readings = new String[mergedItem.text.split(" ").length][];
        for (int i = 0; i < mergedItem.readings.length; ++i) {
            String[] list = new ArrayList();
            if (item1.getReadings().length > i) {
                Collections.addAll(list, item1.getReadings()[i]);
            }
            if (item2.getReadings().length > i) {
                String[] stringArray = item2.getReadings()[i];
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String reading = stringArray[j];
                    if (list.contains(reading)) continue;
                    list.add(reading);
                }
            }
            mergedItem.readings[i] = list.toArray(new String[list.size()]);
        }
        ArrayList<String> fieldList = new ArrayList<String>(item1.getFields().length + item2.getFields().length);
        Collections.addAll(fieldList, item1.getFields());
        for (String field : item2.getFields()) {
            if (fieldList.contains(field)) continue;
            fieldList.add(field);
        }
        mergedItem.fields = fieldList.toArray(new String[fieldList.size()]);
        ArrayList<String> tagList = new ArrayList<String>(item1.getTags().length + item2.getTags().length);
        Collections.addAll(tagList, item1.getTags());
        for (String tag : item2.getTags()) {
            if (tagList.contains(tag)) continue;
            tagList.add(tag);
        }
        mergedItem.tags = tagList.toArray(new String[tagList.size()]);
        ArrayList<String> langList = new ArrayList<String>(item1.getLanguages().length + item2.getLanguages().length);
        Collections.addAll(langList, item1.getLanguages());
        for (String lang : item2.getLanguages()) {
            if (langList.contains(lang)) continue;
            langList.add(lang);
        }
        mergedItem.languages = langList.toArray(new String[langList.size()]);
        ArrayList<String> roleList = new ArrayList<String>(item1.getRoles().length + item2.getRoles().length);
        Collections.addAll(roleList, item1.getRoles());
        for (String role : item2.getRoles()) {
            if (roleList.contains(role)) continue;
            roleList.add(role);
        }
        mergedItem.roles = roleList.toArray(new String[roleList.size()]);
        mergedItem.kinds = SuggestItem.concatKinds(item1.kinds, item2.kinds);
        mergedItem.timestamp = item2.timestamp;
        mergedItem.queryFreq = item1.queryFreq + item2.queryFreq;
        mergedItem.docFreq = item1.docFreq + item2.docFreq;
        mergedItem.userBoost = item2.userBoost;
        mergedItem.emptySource = item2.emptySource;
        return mergedItem;
    }

    public boolean isBadWord(String[] badWords) {
        for (String badWord : badWords) {
            if (!this.text.contains(badWord)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SuggestItem [text=" + this.text + ", timestamp=" + this.timestamp + ", queryFreq=" + this.queryFreq + ", docFreq=" + this.docFreq + ", userBoost=" + this.userBoost + ", readings=" + Arrays.toString((Object[])this.readings) + ", fields=" + Arrays.toString(this.fields) + ", tags=" + Arrays.toString(this.tags) + ", roles=" + Arrays.toString(this.roles) + ", languages=" + Arrays.toString(this.languages) + ", kinds=" + Arrays.toString((Object[])this.kinds) + ", emptySource=" + this.emptySource + ", id=" + this.id + "]";
    }

    private String convertJsonString(String value) {
        return "\"" + value.replace("\"", "\\\"") + "\"";
    }

    private String convertJsonStrings(String[] values) {
        if (values == null) {
            return "[]";
        }
        return "[" + Arrays.stream(values).map(this::convertJsonString).collect(Collectors.joining(",")) + "]";
    }

    public String toJsonString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{').append('\"').append("text").append("\":").append(this.convertJsonString(this.text));
        for (int i = 0; i < this.readings.length; ++i) {
            String[] values = this.readings[i] == null ? null : (String[])Arrays.stream(this.readings[i]).distinct().toArray(String[]::new);
            buf.append(',').append('\"').append("reading_" + i).append("\":").append(this.convertJsonStrings(values));
        }
        buf.append(',').append('\"').append("fields").append("\":").append(this.convertJsonStrings(this.fields));
        buf.append(',').append('\"').append("tags").append("\":").append(this.convertJsonStrings(this.tags));
        buf.append(',').append('\"').append("roles").append("\":").append(this.convertJsonStrings(this.roles));
        buf.append(',').append('\"').append("languages").append("\":").append(this.convertJsonStrings(this.languages));
        buf.append(',').append('\"').append("kinds").append("\":").append(this.convertJsonStrings((String[])Stream.of(this.kinds).map(Kind::toString).toArray(String[]::new)));
        buf.append(',').append('\"').append("queryFreq").append("\":").append(this.queryFreq);
        buf.append(',').append('\"').append("docFreq").append("\":").append(this.docFreq);
        buf.append(',').append('\"').append("userBoost").append("\":").append(this.userBoost);
        buf.append(',').append('\"').append("score").append("\":").append((float)(this.queryFreq + this.docFreq) * this.userBoost);
        buf.append(',').append('\"').append("@timestamp").append("\":").append(this.timestamp.toInstant().toEpochMilli());
        return buf.append('}').toString();
    }

    public static enum Kind {
        DOCUMENT("document"),
        QUERY("query"),
        USER("user");

        private final String kind;

        private Kind(String kind) {
            this.kind = kind;
        }

        public String toString() {
            return this.kind;
        }
    }
}

