/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.index.contents;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.suggest.analysis.SuggestAnalyzer;
import org.codelibs.fess.suggest.converter.ReadingConverter;
import org.codelibs.fess.suggest.entity.SuggestItem;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.index.contents.ContentsParser;
import org.codelibs.fess.suggest.index.contents.querylog.QueryLog;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;

public class DefaultContentsParser
implements ContentsParser {
    private static final Logger logger = LogManager.getLogger(DefaultContentsParser.class);
    private final int maxAnalyzedContentLength = Integer.getInteger("fess.suggest.max.analyzed.content.length", 1000);

    @Override
    public SuggestItem parseSearchWords(String[] words, String[][] readings, String[] fields, String[] tags, String[] roles, long score, ReadingConverter readingConverter, Normalizer normalizer, SuggestAnalyzer analyzer, String[] langs) {
        try {
            ArrayList<String> wordsList = new ArrayList<String>(words.length);
            ArrayList<String[]> readingList = new ArrayList<String[]>(words.length);
            for (int i = 0; i < words.length; ++i) {
                if (this.isExcludeSearchword(words[i], fields != null && fields.length > 0 ? fields[0] : "", langs, analyzer)) continue;
                String word = normalizer.normalize(words[i], fields != null && fields.length > 0 ? fields[0] : "", langs);
                List<String> l = readingConverter.convert(word, fields != null && fields.length > 0 ? fields[0] : "", langs);
                if (readings != null && readings.length > i && readings[i].length > 0) {
                    for (String reading : readings[i]) {
                        if (l.contains(reading)) continue;
                        l.add(reading);
                    }
                }
                wordsList.add(word);
                readingList.add(l.toArray(new String[l.size()]));
            }
            if (wordsList.isEmpty()) {
                return null;
            }
            return new SuggestItem(wordsList.toArray(new String[wordsList.size()]), (String[][])readingList.toArray((T[])new String[readingList.size()][]), fields, 0L, score, -1.0f, tags, roles, langs, SuggestItem.Kind.QUERY);
        }
        catch (IOException e) {
            throw new SuggesterException("Failed to SuggestItem from search words.", e);
        }
    }

    @Override
    public List<SuggestItem> parseQueryLog(QueryLog queryLog, String[] fields, String[] tagFieldNames, String roleFieldName, ReadingConverter readingConverter, Normalizer normalizer) {
        String queryString = queryLog.getQueryString();
        String filterQueryString = queryLog.getFilterQueryString();
        ArrayList<String> tagList = new ArrayList<String>();
        for (String tagFieldName : tagFieldNames) {
            tagList.addAll(Arrays.asList(SuggestUtil.parseQuery(queryString, tagFieldName)));
            if (filterQueryString == null) continue;
            tagList.addAll(Arrays.asList(SuggestUtil.parseQuery(filterQueryString, tagFieldName)));
        }
        String[] tags = tagList.toArray(new String[tagList.size()]);
        String[] roles1 = SuggestUtil.parseQuery(queryString, roleFieldName);
        String[] roles2 = filterQueryString == null ? new String[]{} : SuggestUtil.parseQuery(filterQueryString, roleFieldName);
        String[] roles = new String[roles1.length + roles2.length];
        if (roles1.length > 0) {
            System.arraycopy(roles1, 0, roles, 0, roles1.length);
        }
        if (roles2.length > 0) {
            System.arraycopy(roles2, 0, roles, roles1.length, roles2.length);
        }
        ArrayList<SuggestItem> items = new ArrayList<SuggestItem>(fields.length);
        try {
            for (String field : fields) {
                String[] words = SuggestUtil.parseQuery(queryString, field);
                if (words.length == 0) continue;
                String[][] readings = new String[words.length][];
                for (int j = 0; j < words.length; ++j) {
                    words[j] = normalizer.normalize(words[j], field, "");
                    List<String> l = readingConverter.convert(words[j], field, new String[0]);
                    readings[j] = l.toArray(new String[l.size()]);
                }
                items.add(new SuggestItem(words, readings, new String[]{field}, 0L, 1L, -1.0f, tags, roles, null, SuggestItem.Kind.QUERY));
            }
        }
        catch (IOException e) {
            throw new SuggesterException("Failed to create SuggestItem from queryLog.", e);
        }
        return items;
    }

    @Override
    public List<SuggestItem> parseDocument(Map<String, Object> document, String[] fields, String[] tagFieldNames, String roleFieldName, String langFieldName, ReadingConverter readingConverter, ReadingConverter contentsReadingConverter, Normalizer normalizer, SuggestAnalyzer analyzer) {
        ArrayList<SuggestItem> items = null;
        ArrayList<String> tagList = new ArrayList<String>();
        for (String tagFieldName : tagFieldNames) {
            tagList.addAll(Arrays.asList(this.getFieldValues(document, tagFieldName)));
        }
        String[] tags = tagList.toArray(new String[tagList.size()]);
        String[] roles = this.getFieldValues(document, roleFieldName);
        for (String field : fields) {
            String lang;
            Object textObj = document.get(field);
            if (textObj == null) continue;
            String text = textObj.toString();
            List<AnalyzeAction.AnalyzeToken> tokens = this.analyzeText(analyzer, field, text, lang = document.get(langFieldName) == null ? null : document.get(langFieldName).toString());
            if (tokens == null) continue;
            List<AnalyzeAction.AnalyzeToken> readingTokens = this.analyzeTextByReading(analyzer, field, text, lang);
            if (readingTokens.size() != tokens.size()) {
                readingTokens = null;
            }
            try {
                for (int i = 0; i < tokens.size(); ++i) {
                    String[] stringArray;
                    List<String> l;
                    AnalyzeAction.AnalyzeToken token = tokens.get(i);
                    String word = token.getTerm();
                    if (StringUtil.isBlank((String)word)) continue;
                    String[] words = new String[]{word};
                    String[][] readings = new String[words.length][];
                    if (readingTokens == null) {
                        l = readingConverter.convert(word, field, lang);
                    } else {
                        String reading = readingTokens.get(i).getTerm();
                        l = contentsReadingConverter.convert(reading, field, lang);
                    }
                    l.add(word);
                    readings[0] = l.toArray(new String[l.size()]);
                    if (items == null) {
                        items = new ArrayList(text.length() * fields.length / field.length());
                    }
                    if (lang == null) {
                        stringArray = new String[]{};
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = lang;
                    }
                    String[] langs = stringArray;
                    items.add(new SuggestItem(words, readings, new String[]{field}, 1L, 0L, -1.0f, tags, roles, langs, SuggestItem.Kind.DOCUMENT));
                }
            }
            catch (IOException e) {
                throw new SuggesterException("Failed to create SuggestItem from document.", e);
            }
        }
        return items == null ? new ArrayList<SuggestItem>() : items;
    }

    protected List<AnalyzeAction.AnalyzeToken> analyzeText(SuggestAnalyzer analyzer, String field, String text, String lang) {
        ArrayList<AnalyzeAction.AnalyzeToken> tokens = new ArrayList<AnalyzeAction.AnalyzeToken>();
        StringBuilder buf = new StringBuilder(this.maxAnalyzedContentLength);
        for (String t : text.split("\\s")) {
            buf.append(t).append(' ');
            if (buf.length() <= this.maxAnalyzedContentLength) continue;
            try {
                tokens.addAll(analyzer.analyze(buf.toString().trim(), field, lang));
            }
            catch (IllegalStateException | OpenSearchStatusException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("[{}][{}] Failed to analyze a text(size:{}).", (Object)field, (Object)lang, (Object)buf.length(), (Object)e);
                }
                logger.warn("[{}][{}] Failed to analyze a text(size:{}). {}", (Object)field, (Object)lang, (Object)buf.length(), (Object)e.getMessage());
            }
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            try {
                tokens.addAll(analyzer.analyze(buf.toString().trim(), field, lang));
            }
            catch (IllegalStateException | OpenSearchStatusException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("[{}][{}] Failed to analyze a last text(size:{}).", (Object)field, (Object)lang, (Object)buf.length(), (Object)e);
                }
                logger.warn("[{}][{}] Failed to analyze a last text(size:{}). {}", (Object)field, (Object)lang, (Object)buf.length(), (Object)e.getMessage());
            }
        }
        return tokens;
    }

    protected List<AnalyzeAction.AnalyzeToken> analyzeTextByReading(SuggestAnalyzer analyzer, String field, String text, String lang) {
        ArrayList<AnalyzeAction.AnalyzeToken> tokens = new ArrayList<AnalyzeAction.AnalyzeToken>();
        StringBuilder buf = new StringBuilder(this.maxAnalyzedContentLength);
        for (String t : text.split("\\s")) {
            buf.append(t).append(' ');
            if (buf.length() <= this.maxAnalyzedContentLength) continue;
            try {
                List<AnalyzeAction.AnalyzeToken> readings = analyzer.analyzeAndReading(buf.toString().trim(), field, lang);
                if (readings != null) {
                    tokens.addAll(readings);
                }
            }
            catch (IllegalStateException | OpenSearchStatusException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("[{}][{}] Failed to analyze a reading text(size:{}).", (Object)field, (Object)lang, (Object)buf.length(), (Object)e);
                }
                logger.warn("[{}][{}] Failed to analyze a reading text(size:{}). {}", (Object)field, (Object)lang, (Object)buf.length(), (Object)e.getMessage());
            }
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            try {
                List<AnalyzeAction.AnalyzeToken> readings = analyzer.analyzeAndReading(buf.toString().trim(), field, lang);
                if (readings != null) {
                    tokens.addAll(readings);
                }
            }
            catch (IllegalStateException | OpenSearchStatusException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("[{}][{}] Failed to analyze a last reading text(size:{}).", (Object)field, (Object)lang, (Object)buf.length(), (Object)e);
                }
                logger.warn("[{}][{}] Failed to analyze a last reading text(size:{}). {}", (Object)field, (Object)lang, (Object)buf.length(), (Object)e.getMessage());
            }
        }
        return tokens;
    }

    protected String[] getFieldValues(Map<String, Object> document, String fieldName) {
        Object value = document.get(fieldName);
        if (value instanceof String) {
            return new String[]{value.toString()};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof List) {
            return (String[])((List)value).stream().map(Object::toString).toArray(String[]::new);
        }
        if (value != null) {
            return new String[]{value.toString()};
        }
        return new String[0];
    }

    protected boolean isExcludeSearchword(String searchWord, String field, String[] langs, SuggestAnalyzer analyzer) {
        if (langs == null || langs.length == 0) {
            List<AnalyzeAction.AnalyzeToken> tokens = analyzer.analyze(searchWord, "", null);
            return tokens == null || tokens.size() == 0;
        }
        for (String lang : langs) {
            List<AnalyzeAction.AnalyzeToken> tokens = analyzer.analyze(searchWord, field, lang);
            if (tokens == null || tokens.size() <= 0) continue;
            return false;
        }
        return true;
    }
}

