/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.index.writer;

import org.codelibs.fess.suggest.entity.SuggestItem;
import org.codelibs.fess.suggest.exception.SuggestIndexException;
import org.codelibs.fess.suggest.index.writer.SuggestWriter;
import org.codelibs.fess.suggest.index.writer.SuggestWriterResult;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexAction;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilder;

public class SuggestIndexWriter
implements SuggestWriter {
    @Override
    public SuggestWriterResult write(Client client, SuggestSettings settings, String index, SuggestItem[] items, boolean update) {
        BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
        SuggestItem[] mergedItems = this.mergeItems(items);
        if (mergedItems.length == 0) {
            return new SuggestWriterResult();
        }
        for (SuggestItem item : mergedItems) {
            IndexRequestBuilder indexRequestBuilder;
            GetResponse getResponse = (GetResponse)((GetRequestBuilder)client.prepareGet().setIndex(index)).setId(item.getId()).get(TimeValue.timeValueSeconds((long)30L));
            if (update && getResponse.isExists()) {
                indexRequestBuilder = new IndexRequestBuilder((OpenSearchClient)client, IndexAction.INSTANCE, index);
                indexRequestBuilder.setId(item.getId()).setOpType(DocWriteRequest.OpType.INDEX).setSource(item.getUpdatedSource(getResponse.getSourceAsMap()));
                bulkRequestBuilder.add(indexRequestBuilder);
                continue;
            }
            indexRequestBuilder = new IndexRequestBuilder((OpenSearchClient)client, IndexAction.INSTANCE, index);
            indexRequestBuilder.setId(item.getId()).setOpType(DocWriteRequest.OpType.INDEX).setSource(item.getSource());
            bulkRequestBuilder.add(indexRequestBuilder);
        }
        BulkResponse response = (BulkResponse)bulkRequestBuilder.execute().actionGet(settings.getBulkTimeout());
        SuggestWriterResult result = new SuggestWriterResult();
        if (response.hasFailures()) {
            for (BulkItemResponse bulkItemResponses : response.getItems()) {
                if (!bulkItemResponses.isFailed()) continue;
                result.addFailure(new SuggestIndexException("Bulk failure. " + bulkItemResponses.getFailureMessage()));
            }
        }
        return result;
    }

    @Override
    public SuggestWriterResult delete(Client client, SuggestSettings settings, String index, String id) {
        SuggestWriterResult result = new SuggestWriterResult();
        try {
            ((DeleteRequestBuilder)client.prepareDelete().setIndex(index)).setId(id).execute().actionGet(settings.getIndexTimeout());
        }
        catch (Exception e) {
            result.addFailure(e);
        }
        return result;
    }

    @Override
    public SuggestWriterResult deleteByQuery(Client client, SuggestSettings settings, String index, QueryBuilder queryBuilder) {
        SuggestWriterResult result = new SuggestWriterResult();
        try {
            SuggestUtil.deleteByQuery(client, settings, index, queryBuilder);
        }
        catch (Exception e) {
            result.addFailure(e);
        }
        return result;
    }
}

