/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.normalizer;

import java.util.List;
import org.codelibs.fess.suggest.normalizer.Normalizer;
import org.codelibs.fess.suggest.normalizer.NormalizerChain;
import org.codelibs.fess.suggest.settings.AnalyzerSettings;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.client.Client;

public class AnalyzerNormalizer
implements Normalizer {
    protected final Client client;
    protected final AnalyzerSettings analyzerSettings;
    private final SuggestSettings settings;

    public AnalyzerNormalizer(Client client, SuggestSettings settings) {
        this.client = client;
        this.settings = settings;
        this.analyzerSettings = settings.analyzer();
    }

    @Override
    public String normalize(String text, String field, String ... langs) {
        Normalizer normalizer;
        if (langs == null || langs.length == 0) {
            normalizer = new LangAnalyzerNormalizer(null);
        } else {
            NormalizerChain chain = new NormalizerChain();
            for (String lang : langs) {
                chain.add(new LangAnalyzerNormalizer(lang));
            }
            normalizer = chain;
        }
        return normalizer.normalize(text, field, new String[0]);
    }

    protected class LangAnalyzerNormalizer
    implements Normalizer {
        protected final String lang;

        protected LangAnalyzerNormalizer(String lang) {
            this.lang = lang;
        }

        @Override
        public String normalize(String text, String field, String ... dummy) {
            AnalyzeAction.Response termResponse = (AnalyzeAction.Response)AnalyzerNormalizer.this.client.admin().indices().prepareAnalyze(AnalyzerNormalizer.this.analyzerSettings.getAnalyzerSettingsIndexName(), text).setAnalyzer(AnalyzerNormalizer.this.analyzerSettings.getNormalizeAnalyzerName(field, this.lang)).execute().actionGet(AnalyzerNormalizer.this.settings.getIndicesTimeout());
            List termTokenList = termResponse.getTokens();
            if (termTokenList.isEmpty()) {
                return text;
            }
            return ((AnalyzeAction.AnalyzeToken)termTokenList.get(0)).getTerm();
        }
    }
}

