/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.normalizer;

import org.codelibs.fess.suggest.normalizer.Normalizer;

public class HankakuKanaToZenkakuKana
implements Normalizer {
    private static final char[] HANKAKU_KATAKANA = new char[]{'\uff61', '\uff62', '\uff63', '\uff64', '\uff65', '\uff66', '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b', '\uff6c', '\uff6d', '\uff6e', '\uff6f', '\uff70', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff76', '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff85', '\uff86', '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e', '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff95', '\uff96', '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9d', '\uff9e', '\uff9f'};
    private static final char[] ZENKAKU_KATAKANA = new char[]{'\u3002', '\u300c', '\u300d', '\u3001', '\u30fb', '\u30f2', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30fc', '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa', '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3', '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd', '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e4', '\u30e6', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ef', '\u30f3', '\u309b', '\u309c'};
    private static final char HANKAKU_KATAKANA_FIRST_CHAR = HANKAKU_KATAKANA[0];
    private static final char HANKAKU_KATAKANA_LAST_CHAR = HANKAKU_KATAKANA[HANKAKU_KATAKANA.length - 1];

    @Override
    public String normalize(String s, String field, String ... langs) {
        char convertedChar;
        char originalChar1;
        int i;
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return "" + HankakuKanaToZenkakuKana.hankakuKatakanaToZenkakuKatakana(s.charAt(0));
        }
        StringBuilder sb = new StringBuilder(s);
        for (i = 0; i < sb.length() - 1; ++i) {
            char originalChar2;
            originalChar1 = sb.charAt(i);
            char margedChar = HankakuKanaToZenkakuKana.mergeChar(originalChar1, originalChar2 = sb.charAt(i + 1));
            if (margedChar != originalChar1) {
                sb.setCharAt(i, margedChar);
                sb.deleteCharAt(i + 1);
                continue;
            }
            char convertedChar2 = HankakuKanaToZenkakuKana.hankakuKatakanaToZenkakuKatakana(originalChar1);
            if (convertedChar2 == originalChar1) continue;
            sb.setCharAt(i, convertedChar2);
        }
        if (i < sb.length() && (convertedChar = HankakuKanaToZenkakuKana.hankakuKatakanaToZenkakuKatakana(originalChar1 = sb.charAt(i))) != originalChar1) {
            sb.setCharAt(i, convertedChar);
        }
        return sb.toString();
    }

    private static char hankakuKatakanaToZenkakuKatakana(char c) {
        if (c >= HANKAKU_KATAKANA_FIRST_CHAR && c <= HANKAKU_KATAKANA_LAST_CHAR) {
            return ZENKAKU_KATAKANA[c - HANKAKU_KATAKANA_FIRST_CHAR];
        }
        return c;
    }

    public static char mergeChar(char c1, char c2) {
        if (c2 == '\uff9e') {
            if ("\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e".indexOf(c1) >= 0) {
                switch (c1) {
                    case '\uff76': {
                        return '\u30ac';
                    }
                    case '\uff77': {
                        return '\u30ae';
                    }
                    case '\uff78': {
                        return '\u30b0';
                    }
                    case '\uff79': {
                        return '\u30b2';
                    }
                    case '\uff7a': {
                        return '\u30b4';
                    }
                    case '\uff7b': {
                        return '\u30b6';
                    }
                    case '\uff7c': {
                        return '\u30b8';
                    }
                    case '\uff7d': {
                        return '\u30ba';
                    }
                    case '\uff7e': {
                        return '\u30bc';
                    }
                    case '\uff7f': {
                        return '\u30be';
                    }
                    case '\uff80': {
                        return '\u30c0';
                    }
                    case '\uff81': {
                        return '\u30c2';
                    }
                    case '\uff82': {
                        return '\u30c5';
                    }
                    case '\uff83': {
                        return '\u30c7';
                    }
                    case '\uff84': {
                        return '\u30c9';
                    }
                    case '\uff8a': {
                        return '\u30d0';
                    }
                    case '\uff8b': {
                        return '\u30d3';
                    }
                    case '\uff8c': {
                        return '\u30d6';
                    }
                    case '\uff8d': {
                        return '\u30d9';
                    }
                    case '\uff8e': {
                        return '\u30dc';
                    }
                }
            }
        } else if (c2 == '\uff9f' && "\uff8a\uff8b\uff8c\uff8d\uff8e".indexOf(c1) >= 0) {
            switch (c1) {
                case '\uff8a': {
                    return '\u30d1';
                }
                case '\uff8b': {
                    return '\u30d4';
                }
                case '\uff8c': {
                    return '\u30d7';
                }
                case '\uff8d': {
                    return '\u30da';
                }
                case '\uff8e': {
                    return '\u30dd';
                }
            }
        }
        return c1;
    }
}

