/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.request.popularwords;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codelibs.fess.suggest.concurrent.Deferred;
import org.codelibs.fess.suggest.entity.SuggestItem;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.request.Request;
import org.codelibs.fess.suggest.request.popularwords.PopularWordsResponse;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.lucene.search.function.CombineFunction;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.rescore.QueryRescorerBuilder;
import org.opensearch.search.rescore.RescorerBuilder;

public class PopularWordsRequest
extends Request<PopularWordsResponse> {
    private String index = null;
    private int size = 10;
    private final List<String> tags = new ArrayList<String>();
    private final List<String> roles = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> languages = new ArrayList<String>();
    private String seed = String.valueOf(System.currentTimeMillis());
    private int windowSize = 20;
    private boolean detail = true;
    private int queryFreqThreshold = 10;
    private final List<String> excludeWords = new ArrayList<String>();

    public void setIndex(String index) {
        this.index = index;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public void addLanguage(String lang) {
        this.languages.add(lang);
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public void addExcludeWord(String excludeWord) {
        this.excludeWords.add(excludeWord);
    }

    public void setQueryFreqThreshold(int queryFreqThreshold) {
        this.queryFreqThreshold = queryFreqThreshold;
    }

    @Override
    protected void processRequest(Client client, final Deferred<PopularWordsResponse> deferred) {
        SearchRequestBuilder builder = client.prepareSearch(new String[]{this.index});
        builder.setSize(this.size);
        builder.setQuery(this.buildQuery());
        builder.setRescorer((RescorerBuilder)this.buildRescore(), this.windowSize);
        builder.execute((ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                if (searchResponse.getFailedShards() > 0) {
                    deferred.reject(new SuggesterException("Search failure. Failed shards num:" + searchResponse.getFailedShards()));
                } else {
                    deferred.resolve(PopularWordsRequest.this.createResponse(searchResponse));
                }
            }

            public void onFailure(Exception e) {
                deferred.reject(e);
            }
        });
    }

    @Override
    protected String getValidationError() {
        return null;
    }

    protected QueryBuilder buildQuery() {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"kinds", (String)SuggestItem.Kind.QUERY.toString()));
        queryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"reading_1"));
        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"queryFreq").gte((Object)this.queryFreqThreshold));
        if (!this.tags.isEmpty()) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"tags", this.tags));
        }
        if (!this.roles.isEmpty()) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"roles", this.roles));
        } else {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"roles", (String)"_guest_"));
        }
        if (!this.fields.isEmpty()) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fields", this.fields));
        }
        if (!this.languages.isEmpty()) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"languages", this.languages));
        }
        if (!this.excludeWords.isEmpty()) {
            queryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"text", this.excludeWords));
        }
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryBuilder, (ScoreFunctionBuilder)ScoreFunctionBuilders.fieldValueFactorFunction((String)"queryFreq").missing(0.0));
        functionScoreQueryBuilder.boostMode(CombineFunction.REPLACE);
        return functionScoreQueryBuilder;
    }

    protected QueryRescorerBuilder buildRescore() {
        return new QueryRescorerBuilder((QueryBuilder)QueryBuilders.functionScoreQuery((ScoreFunctionBuilder)ScoreFunctionBuilders.randomFunction().seed(this.seed).setField("_seq_no"))).setQueryWeight(0.0f).setRescoreQueryWeight(1.0f);
    }

    protected PopularWordsResponse createResponse(SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<String> words = new ArrayList<String>();
        ArrayList<SuggestItem> items = new ArrayList<SuggestItem>();
        String index = hits.length > 0 ? hits[0].getIndex() : "";
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            String text = source.get("text").toString();
            words.add(text);
            if (!this.detail) continue;
            items.add(SuggestItem.parseSource(source));
        }
        return new PopularWordsResponse(index, searchResponse.getTook().getMillis(), words, searchResponse.getHits().getTotalHits().value, items);
    }
}

