/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.settings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.core.CoreLibConstants;
import org.codelibs.fess.suggest.exception.SuggestSettingsException;
import org.codelibs.fess.suggest.settings.SuggestSettings;
import org.codelibs.fess.suggest.util.SuggestUtil;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;

public class ArraySettings {
    private static final Logger logger = LogManager.getLogger(ArraySettings.class);
    protected final Client client;
    protected final String arraySettingsIndexName;
    protected final String settingsId;
    protected final SuggestSettings settings;
    private static final Base64.Encoder encoder = Base64.getEncoder();

    protected ArraySettings(SuggestSettings settings, Client client, String settingsIndexName, String settingsId) {
        this.settings = settings;
        this.client = client;
        this.arraySettingsIndexName = this.createArraySettingsIndexName(settingsIndexName);
        this.settingsId = settingsId;
        this.createMappingIfEmpty(this.arraySettingsIndexName, settingsId, client);
    }

    public String[] get(String key) {
        Map<String, Object>[] sourceArray = this.getFromArrayIndex(this.arraySettingsIndexName, this.settingsId, key);
        String[] valueArray = new String[sourceArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            Object value = sourceArray[i].get("value");
            if (value == null) continue;
            valueArray[i] = value.toString();
        }
        return valueArray;
    }

    public void add(String key, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Add analyzer settings. {} key: {} value: {}", (Object)this.arraySettingsIndexName, (Object)key, value);
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("key", key);
        source.put("value", value);
        source.put("@timestamp", DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now()));
        this.addToArrayIndex(this.arraySettingsIndexName, this.settingsId, this.createId(key, value), source);
    }

    public void delete(String key) {
        this.deleteKeyFromArray(this.arraySettingsIndexName, this.settingsId, key);
    }

    public void delete(String key, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete analyzer settings. {} key: {} value: {}", (Object)this.arraySettingsIndexName, (Object)key, (Object)value);
        }
        this.deleteFromArray(this.arraySettingsIndexName, this.settingsId, this.createId(key, value));
    }

    protected String createArraySettingsIndexName(String settingsIndexName) {
        return settingsIndexName + "_array";
    }

    protected String createId(String key, Object value) {
        return encoder.encodeToString(("key:" + key + "value:" + value).getBytes(CoreLibConstants.CHARSET_UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object>[] getFromArrayIndex(String index, String type, String key) {
        String actualIndex = index + "." + type.toLowerCase(Locale.ENGLISH);
        try {
            SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[0]).setIndices(new String[]{actualIndex}).setScroll(this.settings.getScrollTimeout()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"key", (String)key)).setSize(500).execute().actionGet(this.settings.getSearchTimeout());
            String scrollId = response.getScrollId();
            Map[] array = new Map[(int)response.getHits().getTotalHits().value];
            int count = 0;
            try {
                while (scrollId != null) {
                    SearchHit[] hits = response.getHits().getHits();
                    if (hits.length == 0) {
                        break;
                    }
                    for (SearchHit hit : hits) {
                        array[count] = hit.getSourceAsMap();
                        ++count;
                    }
                    response = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(this.settings.getScrollTimeout()).execute().actionGet(this.settings.getSearchTimeout());
                    if (!scrollId.equals(response.getScrollId())) {
                        SuggestUtil.deleteScrollContext(this.client, scrollId);
                    }
                    scrollId = response.getScrollId();
                }
            }
            finally {
                SuggestUtil.deleteScrollContext(this.client, scrollId);
            }
            Arrays.sort(array, (o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                Object timeObj1 = o1.get("@timestamp");
                Object timeObj2 = o2.get("@timestamp");
                if (timeObj1 == null && timeObj2 == null) {
                    return 0;
                }
                if (timeObj1 == null) {
                    return -1;
                }
                if (timeObj2 == null) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            });
            return array;
        }
        catch (IndexNotFoundException e) {
            return new Map[0];
        }
    }

    protected void addToArrayIndex(String index, String type, String id, Map<String, Object> source) {
        String actualIndex = index + "." + type.toLowerCase(Locale.ENGLISH);
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().map(source);
            builder.flush();
            ((UpdateRequestBuilder)this.client.prepareUpdate().setIndex(actualIndex)).setId(id).setDocAsUpsert(true).setDoc(builder).execute().actionGet(this.settings.getIndexTimeout());
            ((RefreshRequestBuilder)this.client.admin().indices().prepareRefresh(new String[0]).setIndices(new String[]{actualIndex})).execute().actionGet(this.settings.getIndicesTimeout());
        }
        catch (Exception e) {
            throw new SuggestSettingsException("Failed to add to array.", e);
        }
    }

    protected void deleteKeyFromArray(String index, String type, String key) {
        String actualIndex = index + "." + type.toLowerCase(Locale.ENGLISH);
        try {
            SuggestUtil.deleteByQuery(this.client, this.settings, actualIndex, (QueryBuilder)QueryBuilders.termQuery((String)"key", (String)key));
        }
        catch (Exception e) {
            throw new SuggestSettingsException("Failed to delete all from array.", e);
        }
    }

    protected void deleteFromArray(String index, String type, String id) {
        String actualIndex = index + "." + type.toLowerCase(Locale.ENGLISH);
        try {
            ((DeleteRequestBuilder)this.client.prepareDelete().setIndex(actualIndex)).setId(id).execute().actionGet(this.settings.getIndexTimeout());
            ((RefreshRequestBuilder)this.client.admin().indices().prepareRefresh(new String[0]).setIndices(new String[]{actualIndex})).execute().actionGet(this.settings.getIndicesTimeout());
        }
        catch (Exception e) {
            throw new SuggestSettingsException("Failed to delete from array.", e);
        }
    }

    protected void createMappingIfEmpty(String index, String type, Client client) {
        String actualIndex = index + "." + type.toLowerCase(Locale.ENGLISH);
        try {
            boolean empty;
            try {
                empty = ((GetMappingsResponse)client.admin().indices().prepareGetMappings(new String[]{actualIndex}).execute().actionGet(this.settings.getIndicesTimeout())).getMappings().isEmpty();
            }
            catch (IndexNotFoundException e) {
                empty = true;
                CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().prepareCreate(actualIndex).setSettings(this.loadIndexSettings(), (MediaType)XContentType.JSON).execute().actionGet(this.settings.getIndicesTimeout());
                if (!response.isAcknowledged()) {
                    throw new SuggestSettingsException("Failed to create " + actualIndex + "/" + type + " index.", e);
                }
                client.admin().cluster().prepareHealth(new String[]{actualIndex}).setWaitForYellowStatus().execute().actionGet(this.settings.getClusterTimeout());
            }
            if (empty) {
                client.admin().indices().preparePutMapping(new String[]{actualIndex}).setSource(XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("key").field("type", "keyword").endObject().endObject().endObject()).execute().actionGet(this.settings.getIndicesTimeout());
            }
        }
        catch (IOException e) {
            throw new SuggestSettingsException("Failed to create mappings.");
        }
    }

    protected String loadIndexSettings() throws IOException {
        String dictionaryPath = System.getProperty("fess.dictionary.path", "");
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("suggest_indices/suggest_settings_array.json")));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString().replaceAll(Pattern.quote("${fess.dictionary.path}"), dictionaryPath);
    }
}

