/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.suggest.settings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.fess.suggest.exception.SuggestSettingsException;
import org.codelibs.fess.suggest.exception.SuggesterException;
import org.codelibs.fess.suggest.settings.AnalyzerSettings;
import org.codelibs.fess.suggest.settings.ArraySettings;
import org.codelibs.fess.suggest.settings.BadWordSettings;
import org.codelibs.fess.suggest.settings.ElevateWordSettings;
import org.codelibs.fess.suggest.settings.SuggestSettingsBuilder;
import org.opensearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.client.Client;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;

public class SuggestSettings {
    private static final Logger logger = LogManager.getLogger(SuggestSettings.class);
    protected final String settingsId;
    protected final Client client;
    protected final String settingsIndexName;
    protected final Map<String, Object> initialSettings;
    protected boolean initialized = false;
    protected final String badWordIndexName;
    protected final String elevateWordIndexName;
    protected TimeoutSettings timeoutSettings;

    public SuggestSettings(Client client, String settingsId, Map<String, Object> initialSettings, String settingsIndexName, TimeoutSettings timeoutSettings) {
        this.client = client;
        this.settingsId = settingsId;
        this.settingsIndexName = settingsIndexName;
        this.initialSettings = initialSettings;
        this.timeoutSettings = timeoutSettings;
        this.badWordIndexName = settingsIndexName + "-badword";
        this.elevateWordIndexName = settingsIndexName + "-elevateword";
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initialize(this.initialSettings);
        new AnalyzerSettings(this.client, this, this.settingsIndexName).init();
    }

    private void initialize(Map<String, Object> initialSettings) {
        boolean doIndexCreate = false;
        boolean doCreate = false;
        try {
            GetResponse getResponse = (GetResponse)((GetRequestBuilder)this.client.prepareGet().setIndex(this.settingsIndexName)).setId(this.settingsId).execute().actionGet(this.getSearchTimeout());
            if (!getResponse.isExists()) {
                doCreate = true;
            }
        }
        catch (IndexNotFoundException e) {
            doIndexCreate = true;
            doCreate = true;
        }
        if (doCreate) {
            if (doIndexCreate) {
                try {
                    this.client.admin().indices().prepareCreate(this.settingsIndexName).setSettings(this.loadIndexSettings(), (MediaType)XContentType.JSON).execute().actionGet(this.getIndicesTimeout());
                }
                catch (IOException e) {
                    throw new SuggesterException(e);
                }
            }
            ArrayList arraySettings = new ArrayList();
            Map<String, Object> defaultSettings = this.defaultSettings();
            initialSettings.forEach((key, value) -> {
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    collection.forEach(element -> arraySettings.add(new Tuple(key, element)));
                } else if (value instanceof Object[]) {
                    for (Object element2 : (Object[])value) {
                        arraySettings.add(new Tuple(key, element2));
                    }
                } else {
                    defaultSettings.put((String)key, value);
                }
            });
            this.set(defaultSettings);
            List<Tuple<String, Object>> defaultArraySettings = this.defaultArraySettings();
            defaultArraySettings.addAll(arraySettings);
            defaultArraySettings.forEach(t -> this.array().add((String)t.v1(), t.v2()));
        }
    }

    public Object get(String key) {
        GetResponse getResponse = (GetResponse)((GetRequestBuilder)this.client.prepareGet().setIndex(this.settingsIndexName)).setId(this.settingsId).execute().actionGet(this.getSearchTimeout());
        if (!getResponse.isExists()) {
            return null;
        }
        Map map = getResponse.getSource();
        return map.get(key);
    }

    public String getAsString(String key, String defaultValue) {
        Object obj = this.get(key);
        String value = obj == null ? defaultValue : obj.toString();
        return value;
    }

    public int getAsInt(String key, int defaultValue) {
        Object obj = this.get(key);
        int value = obj == null ? defaultValue : Integer.parseInt(obj.toString());
        return value;
    }

    public long getAsLong(String key, long defaultValue) {
        Object obj = this.get(key);
        long value = obj == null ? defaultValue : Long.parseLong(obj.toString());
        return value;
    }

    public float getAsFloat(String key, float defaultValue) {
        Object obj = this.get(key);
        float value = obj == null ? defaultValue : Float.parseFloat(obj.toString());
        return value;
    }

    public boolean getAsBoolean(String key, boolean defaultValue) {
        Object obj = this.get(key);
        boolean value = obj == null ? defaultValue : Boolean.parseBoolean(obj.toString());
        return value;
    }

    public void set(String key, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Set suggest settings. {} key: {} value: {}", (Object)this.settingsIndexName, (Object)key, value);
        }
        try {
            ((UpdateRequestBuilder)this.client.prepareUpdate().setIndex(this.settingsIndexName)).setId(this.settingsId).setDocAsUpsert(true).setDoc(new Object[]{key, value}).setRetryOnConflict(5).execute().actionGet(this.getIndexTimeout());
            ((RefreshRequestBuilder)this.client.admin().indices().prepareRefresh(new String[0]).setIndices(new String[]{this.settingsIndexName})).execute().actionGet(this.getIndicesTimeout());
        }
        catch (Exception e) {
            throw new SuggestSettingsException("Failed to update suggestSettings.", e);
        }
    }

    public void set(Map<String, Object> map) {
        if (logger.isDebugEnabled()) {
            logger.debug("Set suggest settings. {} {}", (Object)this.settingsIndexName, (Object)map.toString());
        }
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().map(map);
            builder.flush();
            ((UpdateRequestBuilder)this.client.prepareUpdate().setIndex(this.settingsIndexName)).setId(this.settingsId).setDocAsUpsert(true).setDoc(builder).setRetryOnConflict(5).execute().actionGet(this.getIndexTimeout());
            ((RefreshRequestBuilder)this.client.admin().indices().prepareRefresh(new String[0]).setIndices(new String[]{this.settingsIndexName})).execute().actionGet(this.getIndicesTimeout());
        }
        catch (Exception e) {
            throw new SuggestSettingsException("Failed to update suggestSettings.", e);
        }
    }

    public ArraySettings array() {
        return new ArraySettings(this, this.client, this.settingsIndexName, this.settingsId);
    }

    public AnalyzerSettings analyzer() {
        return new AnalyzerSettings(this.client, this, this.settingsIndexName);
    }

    public BadWordSettings badword() {
        return new BadWordSettings(this, this.client, this.settingsIndexName, this.settingsId);
    }

    public ElevateWordSettings elevateWord() {
        return new ElevateWordSettings(this, this.client, this.settingsIndexName, this.settingsId);
    }

    public String getSettingsIndexName() {
        return this.settingsIndexName;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getSettingsId() {
        return this.settingsId;
    }

    private Map<String, Object> defaultSettings() {
        HashMap<String, Object> defaultSettings = new HashMap<String, Object>();
        defaultSettings.put("index", (this.settingsId + ".suggest").toLowerCase());
        defaultSettings.put("tagFieldName", "label,virtual_host");
        defaultSettings.put("roleFieldName", "role");
        defaultSettings.put("langFieldName", "lang");
        defaultSettings.put("parallel", Boolean.FALSE);
        return defaultSettings;
    }

    private List<Tuple<String, Object>> defaultArraySettings() {
        ArrayList<Tuple<String, Object>> tuples = new ArrayList<Tuple<String, Object>>();
        tuples.add(new Tuple((Object)"supportedFields", (Object)"content"));
        return tuples;
    }

    protected String loadIndexSettings() throws IOException {
        String dictionaryPath = System.getProperty("fess.dictionary.path", "");
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("suggest_indices/suggest_settings.json")));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString().replaceAll(Pattern.quote("${fess.dictionary.path}"), dictionaryPath);
    }

    public static SuggestSettingsBuilder builder() {
        return new SuggestSettingsBuilder();
    }

    public String getScrollTimeout() {
        return this.timeoutSettings.scrollTimeout;
    }

    public String getSearchTimeout() {
        return this.timeoutSettings.searchTimeout;
    }

    public String getIndexTimeout() {
        return this.timeoutSettings.indexTimeout;
    }

    public String getIndicesTimeout() {
        return this.timeoutSettings.indicesTimeout;
    }

    public String getBulkTimeout() {
        return this.timeoutSettings.bulkTimeout;
    }

    public String getClusterTimeout() {
        return this.timeoutSettings.clusterTimeout;
    }

    public static class TimeoutSettings {
        protected String searchTimeout = "15s";
        protected String indexTimeout = "1m";
        protected String bulkTimeout = "1m";
        protected String indicesTimeout = "1m";
        protected String clusterTimeout = "1m";
        protected String scrollTimeout = "1m";
    }

    public static class DefaultKeys {
        public static final String INDEX = "index";
        public static final String SUPPORTED_FIELDS = "supportedFields";
        public static final String TAG_FIELD_NAME = "tagFieldName";
        public static final String ROLE_FIELD_NAME = "roleFieldName";
        public static final String LANG_FIELD_NAME = "langFieldName";
        public static final String PARALLEL_PROCESSING = "parallel";
        public static final String MAX_CONTENT_LENGTH = "maxContextLength";

        private DefaultKeys() {
        }
    }
}

