/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans.nt;

import java.io.IOException;
import jcifs.Decodable;
import jcifs.FileNotifyInformation;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import jcifs.util.Strings;

public class FileNotifyInformationImpl
implements FileNotifyInformation,
Decodable {
    int nextEntryOffset;
    int action;
    int fileNameLength;
    String fileName;

    public FileNotifyInformationImpl() {
    }

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public int getNextEntryOffset() {
        return this.nextEntryOffset;
    }

    public FileNotifyInformationImpl(byte[] buffer, int bufferIndex, int len) throws IOException {
        this.decode(buffer, bufferIndex, len);
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.nextEntryOffset = SMBUtil.readInt4(buffer, bufferIndex);
        bufferIndex += 4;
        if (this.nextEntryOffset % 4 != 0) {
            throw new SMBProtocolDecodingException("Non aligned nextEntryOffset");
        }
        this.action = SMBUtil.readInt4(buffer, bufferIndex);
        this.fileNameLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.fileName = Strings.fromUNIBytes(buffer, bufferIndex += 4, this.fileNameLength);
        return (bufferIndex += this.fileNameLength) - start;
    }

    public String toString() {
        String ret = "FileNotifyInformation[nextEntry=" + this.nextEntryOffset + ",action=0x" + Hexdump.toHexString(this.action, 4) + ",file=" + this.fileName + "]";
        return ret;
    }
}

