/* jcifs smb client library in Java
 * Copyright (C) 2000  "Michael B. Allen" <jcifs at samba dot org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package jcifs.smb1.smb1;

import jcifs.smb1.util.Hexdump;

class SmbComRename extends ServerMessageBlock {

    private int searchAttributes;
    private String oldFileName;
    private String newFileName;

    SmbComRename( String oldFileName, String newFileName ) {
        command = SMB_COM_RENAME;
        this.oldFileName = oldFileName;
        this.newFileName = newFileName;
        searchAttributes = ATTR_HIDDEN | ATTR_SYSTEM | ATTR_DIRECTORY;
    }

    int writeParameterWordsWireFormat( byte[] dst, int dstIndex ) {
        writeInt2( searchAttributes, dst, dstIndex );
        return 2;
    }
    int writeBytesWireFormat( byte[] dst, int dstIndex ) {
        int start = dstIndex;

        dst[dstIndex++] = (byte)0x04;
        dstIndex += writeString( oldFileName, dst, dstIndex );
        dst[dstIndex++] = (byte)0x04;
        if( useUnicode ) {
            dst[dstIndex++] = (byte)'\0';
        }
        dstIndex += writeString( newFileName, dst, dstIndex );

        return dstIndex - start;
    }
    int readParameterWordsWireFormat( byte[] buffer, int bufferIndex ) {
        return 0;
    }
    int readBytesWireFormat( byte[] buffer, int bufferIndex ) {
        return 0;
    }
    public String toString() {
        return new String( "SmbComRename[" +
            super.toString() +
            ",searchAttributes=0x" + Hexdump.toHexString( searchAttributes, 4 ) +
            ",oldFileName=" + oldFileName +
            ",newFileName=" + newFileName + "]" );
    }
}
