/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.ResourceFilter;
import jcifs.ResourceNameFilter;
import jcifs.SmbResource;
import jcifs.SmbResourceLocator;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcDfsRootEnum;
import jcifs.dcerpc.msrpc.MsrpcShareEnum;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.net.NetShareEnum;
import jcifs.internal.smb1.net.NetShareEnumResponse;
import jcifs.smb.DosFileFilter;
import jcifs.smb.FileEntry;
import jcifs.smb.RequestParam;
import jcifs.smb.ShareEnumIterator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbResourceLocatorImpl;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTreeConnection;
import jcifs.smb.SmbTreeHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SmbEnumerationUtil {
    private static final Logger log = LoggerFactory.getLogger(SmbEnumerationUtil.class);

    private SmbEnumerationUtil() {
    }

    private static DcerpcHandle getHandle(CIFSContext ctx, SmbResourceLocator loc, Address address, String ep) throws MalformedURLException, DcerpcException {
        return DcerpcHandle.getHandle(String.format("ncacn_np:%s[endpoint=%s,address=%s]", loc.getServer(), ep, address.getHostAddress()), ctx);
    }

    static FileEntry[] doDfsRootEnum(CIFSContext ctx, SmbResourceLocator loc, Address address) throws IOException {
        try (DcerpcHandle handle = SmbEnumerationUtil.getHandle(ctx, loc, address, "\\PIPE\\netdfs");){
            MsrpcDfsRootEnum rpc2 = new MsrpcDfsRootEnum(loc.getServer());
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            FileEntry[] fileEntryArray = rpc2.getEntries();
            return fileEntryArray;
        }
    }

    static FileEntry[] doMsrpcShareEnum(CIFSContext ctx, SmbResourceLocator loc, Address address) throws IOException {
        try (DcerpcHandle handle = SmbEnumerationUtil.getHandle(ctx, loc, address, "\\PIPE\\srvsvc");){
            MsrpcShareEnum rpc2 = new MsrpcShareEnum(loc.getServer());
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            FileEntry[] fileEntryArray = rpc2.getEntries();
            return fileEntryArray;
        }
    }

    static FileEntry[] doNetShareEnum(SmbTreeHandleImpl th) throws CIFSException {
        NetShareEnum req = new NetShareEnum(th.getConfig());
        NetShareEnumResponse resp = new NetShareEnumResponse(th.getConfig());
        th.send((CommonServerMessageBlockRequest)req, resp, new RequestParam[0]);
        if (resp.getStatus() != 0) {
            throw new SmbException(resp.getStatus(), true);
        }
        return resp.getResults();
    }

    static CloseableIterator<SmbResource> doShareEnum(SmbFile parent, String wildcard, int searchAttributes, ResourceNameFilter fnf, ResourceFilter ff) throws CIFSException {
        FileEntry[] entries;
        SmbResourceLocatorImpl locator = parent.fileLocator.clone();
        CIFSContext tc = parent.getContext();
        URL u = locator.getURL();
        if (u.getPath().lastIndexOf(47) != u.getPath().length() - 1) {
            throw new SmbException(u.toString() + " directory must end with '/'");
        }
        if (locator.getType() != 4) {
            throw new SmbException("The requested list operations is invalid: " + u.toString());
        }
        HashSet<FileEntry> set = new HashSet<FileEntry>();
        if (tc.getDfs().isTrustedDomain(tc, locator.getServer())) {
            try {
                entries = SmbEnumerationUtil.doDfsRootEnum(tc, locator, locator.getAddress());
                for (int ei = 0; ei < entries.length; ++ei) {
                    FileEntry e = entries[ei];
                    if (set.contains(e) || fnf != null && !fnf.accept(parent, e.getName())) continue;
                    set.add(e);
                }
            }
            catch (IOException ioe) {
                log.debug("DS enumeration failed", (Throwable)ioe);
            }
        }
        SmbTreeConnection treeConn = new SmbTreeConnection(tc);
        try (SmbTreeHandleImpl th = treeConn.connectHost(locator, locator.getServerWithDfs());
             SmbSessionImpl session = th.getSession();
             SmbTransportImpl transport = session.getTransport();){
            try {
                entries = SmbEnumerationUtil.doMsrpcShareEnum(tc, locator, transport.getRemoteAddress());
            }
            catch (IOException ioe) {
                if (th.isSMB2()) {
                    throw ioe;
                }
                log.debug("doMsrpcShareEnum failed", (Throwable)ioe);
                entries = SmbEnumerationUtil.doNetShareEnum(th);
            }
            for (int ei = 0; ei < entries.length; ++ei) {
                FileEntry e = entries[ei];
                if (set.contains(e) || fnf != null && !fnf.accept(parent, e.getName())) continue;
                set.add(e);
            }
        }
        catch (SmbException e) {
            throw e;
        }
        catch (IOException ioe) {
            log.debug("doNetShareEnum failed", (Throwable)ioe);
            throw new SmbException(u.toString(), (Throwable)ioe);
        }
        return new ShareEnumIterator(parent, set.iterator(), ff);
    }

    /*
     * Exception decompiling
     */
    static CloseableIterator<SmbResource> doEnum(SmbFile parent, String wildcard, int searchAttributes, ResourceNameFilter fnf, ResourceFilter ff) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DosFileFilter unwrapDOSFilter(ResourceFilter ff) {
        SmbFileFilter sff;
        if (ff instanceof ResourceFilterWrapper && (sff = ((ResourceFilterWrapper)ff).getFileFilter()) instanceof DosFileFilter) {
            return (DosFileFilter)sff;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] list(SmbFile root, String wildcard, int searchAttributes, final SmbFilenameFilter fnf, final SmbFileFilter ff) throws SmbException {
        try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(root, wildcard, searchAttributes, fnf == null ? null : new ResourceNameFilter(){

            @Override
            public boolean accept(SmbResource parent, String name) throws CIFSException {
                if (!(parent instanceof SmbFile)) {
                    return false;
                }
                return fnf.accept((SmbFile)parent, name);
            }
        }, ff == null ? null : new ResourceFilter(){

            @Override
            public boolean accept(SmbResource resource) throws CIFSException {
                if (!(resource instanceof SmbFile)) {
                    return false;
                }
                return ff.accept((SmbFile)resource);
            }
        });){
            ArrayList<String> list = new ArrayList<String>();
            while (it.hasNext()) {
                SmbResource n = (SmbResource)it.next();
                Throwable throwable = null;
                try {
                    list.add(n.getName());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (n == null) continue;
                    if (throwable != null) {
                        try {
                            n.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    n.close();
                }
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SmbFile[] listFiles(SmbFile root, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(root, wildcard, searchAttributes, fnf == null ? null : new ResourceNameFilterWrapper(fnf), ff == null ? null : new ResourceFilterWrapper(ff));){
            ArrayList<SmbFile> list = new ArrayList<SmbFile>();
            while (it.hasNext()) {
                SmbResource n = (SmbResource)it.next();
                Throwable throwable = null;
                try {
                    if (!(n instanceof SmbFile)) continue;
                    list.add((SmbFile)n);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (n == null) continue;
                    if (throwable != null) {
                        try {
                            n.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    n.close();
                }
            }
            SmbFile[] smbFileArray = list.toArray(new SmbFile[list.size()]);
            return smbFileArray;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    private static final class ResourceNameFilterWrapper
    implements ResourceNameFilter {
        private final SmbFilenameFilter fnf;

        ResourceNameFilterWrapper(SmbFilenameFilter fnf) {
            this.fnf = fnf;
        }

        @Override
        public boolean accept(SmbResource parent, String name) throws CIFSException {
            if (!(parent instanceof SmbFile)) {
                return false;
            }
            return this.fnf.accept((SmbFile)parent, name);
        }
    }

    private static final class ResourceFilterWrapper
    implements ResourceFilter {
        private final SmbFileFilter ff;

        ResourceFilterWrapper(SmbFileFilter ff) {
            this.ff = ff;
        }

        SmbFileFilter getFileFilter() {
            return this.ff;
        }

        @Override
        public boolean accept(SmbResource resource) throws CIFSException {
            if (!(resource instanceof SmbFile)) {
                return false;
            }
            return this.ff.accept((SmbFile)resource);
        }
    }
}

