/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.opensearch.runner.node;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.codelibs.opensearch.runner.OpenSearchRunnerException;
import org.opensearch.Version;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.env.Environment;
import org.opensearch.node.Node;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.PluginInfo;

public class OpenSearchRunnerNode
extends Node {
    private final Collection<Class<? extends Plugin>> plugins;

    public OpenSearchRunnerNode(Environment tmpEnv, Collection<Class<? extends Plugin>> classpathPlugins) {
        super(tmpEnv, (Collection)classpathPlugins.stream().map(p -> {
            try {
                return new PluginInfo(p.getName(), "classpath plugin", "NA", Version.CURRENT, Integer.toString(Runtime.version().feature()), p.getName(), Collections.emptyList(), false);
            }
            catch (Exception e) {
                throw new OpenSearchRunnerException("Failed to create PluginInfo for " + p.getName(), e);
            }
        }).collect(Collectors.toList()), true);
        this.plugins = classpathPlugins;
    }

    public Collection<Class<? extends Plugin>> getPlugins() {
        return this.plugins;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
    }
}

