/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.codegen;

import java.util.List;
import org.codelibs.sai.internal.codegen.CodeGenerator;
import org.codelibs.sai.internal.codegen.CompilerConstants;
import org.codelibs.sai.internal.codegen.MapCreator;
import org.codelibs.sai.internal.codegen.MapTuple;
import org.codelibs.sai.internal.codegen.MethodEmitter;
import org.codelibs.sai.internal.codegen.types.Type;
import org.codelibs.sai.internal.runtime.JSType;
import org.codelibs.sai.internal.runtime.PropertyMap;
import org.codelibs.sai.internal.runtime.ScriptObject;

public abstract class ObjectCreator<T>
implements CodeGenerator.SplitLiteralCreator {
    final List<MapTuple<T>> tuples;
    final CodeGenerator codegen;
    protected PropertyMap propertyMap;
    private final boolean isScope;
    private final boolean hasArguments;

    ObjectCreator(CodeGenerator codegen, List<MapTuple<T>> tuples, boolean isScope, boolean hasArguments) {
        this.codegen = codegen;
        this.tuples = tuples;
        this.isScope = isScope;
        this.hasArguments = hasArguments;
    }

    public void makeObject(MethodEmitter method) {
        this.createObject(method);
        int objectSlot = method.getUsedSlotsWithLiveTemporaries();
        Type objectType = method.peekType();
        method.storeTemp(objectType, objectSlot);
        this.populateRange(method, objectType, objectSlot, 0, this.tuples.size());
    }

    protected abstract void createObject(MethodEmitter var1);

    protected abstract PropertyMap makeMap();

    protected MapCreator<?> newMapCreator(Class<? extends ScriptObject> clazz) {
        return new MapCreator<T>(clazz, this.tuples);
    }

    protected void loadScope(MethodEmitter method) {
        method.loadCompilerConstant(CompilerConstants.SCOPE);
    }

    protected MethodEmitter loadMap(MethodEmitter method) {
        this.codegen.loadConstant(this.propertyMap);
        return method;
    }

    PropertyMap getMap() {
        return this.propertyMap;
    }

    protected boolean isScope() {
        return this.isScope;
    }

    protected boolean hasArguments() {
        return this.hasArguments;
    }

    protected abstract Class<? extends ScriptObject> getAllocatorClass();

    protected abstract void loadValue(T var1, Type var2);

    MethodEmitter loadTuple(MethodEmitter method, MapTuple<T> tuple, boolean pack) {
        this.loadValue(tuple.value, tuple.type);
        if (!this.codegen.useDualFields() || !tuple.isPrimitive()) {
            method.convert(Type.OBJECT);
        } else if (pack) {
            method.pack();
        }
        return method;
    }

    MethodEmitter loadIndex(MethodEmitter method, long index) {
        return JSType.isRepresentableAsInt(index) ? method.load((int)index) : method.load((double)index);
    }
}

