/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.codegen;

import java.lang.invoke.MethodType;
import org.codelibs.sai.internal.codegen.Compiler;
import org.codelibs.sai.internal.codegen.types.Type;
import org.codelibs.sai.internal.ir.AccessNode;
import org.codelibs.sai.internal.ir.CallNode;
import org.codelibs.sai.internal.ir.Expression;
import org.codelibs.sai.internal.ir.FunctionNode;
import org.codelibs.sai.internal.ir.IdentNode;
import org.codelibs.sai.internal.ir.IndexNode;
import org.codelibs.sai.internal.ir.Optimistic;
import org.codelibs.sai.internal.objects.ArrayBufferView;
import org.codelibs.sai.internal.objects.NativeArray;
import org.codelibs.sai.internal.runtime.FindProperty;
import org.codelibs.sai.internal.runtime.JSType;
import org.codelibs.sai.internal.runtime.Property;
import org.codelibs.sai.internal.runtime.RecompilableScriptFunctionData;
import org.codelibs.sai.internal.runtime.ScriptFunction;
import org.codelibs.sai.internal.runtime.ScriptObject;
import org.codelibs.sai.internal.runtime.ScriptRuntime;
import org.codelibs.sai.internal.runtime.Undefined;

final class TypeEvaluator {
    private static final MethodType EMPTY_INVOCATION_TYPE = MethodType.methodType(Object.class, ScriptFunction.class, Object.class);
    private final Compiler compiler;
    private final ScriptObject runtimeScope;

    TypeEvaluator(Compiler compiler, ScriptObject runtimeScope) {
        this.compiler = compiler;
        this.runtimeScope = runtimeScope;
    }

    boolean hasStringPropertyIterator(Expression expr) {
        return this.evaluateSafely(expr) instanceof ScriptObject;
    }

    Type getOptimisticType(Optimistic node) {
        assert (this.compiler.useOptimisticTypes());
        int programPoint = node.getProgramPoint();
        Type validType = this.compiler.getInvalidatedProgramPointType(programPoint);
        if (validType != null) {
            return validType;
        }
        Type mostOptimisticType = node.getMostOptimisticType();
        Type evaluatedType = this.getEvaluatedType(node);
        if (evaluatedType != null) {
            if (evaluatedType.widerThan(mostOptimisticType)) {
                Type newValidType = evaluatedType.isObject() || evaluatedType.isBoolean() ? Type.OBJECT : evaluatedType;
                this.compiler.addInvalidatedProgramPoint(node.getProgramPoint(), newValidType);
            }
            return evaluatedType;
        }
        return mostOptimisticType;
    }

    private static Type getPropertyType(ScriptObject sobj, String name) {
        Undefined value;
        FindProperty find = sobj.findProperty(name, true);
        if (find == null) {
            return null;
        }
        Property property = find.getProperty();
        Class<?> propertyClass = property.getType();
        if (propertyClass == null) {
            return null;
        }
        if (propertyClass.isPrimitive()) {
            return Type.typeFor(propertyClass);
        }
        ScriptObject owner = find.getOwner();
        if (property.hasGetterFunction(owner)) {
            return Type.OBJECT;
        }
        Undefined undefined = value = property.needsDeclaration() ? ScriptRuntime.UNDEFINED : property.getObjectValue(owner, owner);
        if (value == ScriptRuntime.UNDEFINED) {
            return null;
        }
        return Type.typeFor(JSType.unboxedFieldType(value));
    }

    void declareLocalSymbol(String symbolName) {
        assert (this.compiler.useOptimisticTypes() && this.compiler.isOnDemandCompilation() && this.runtimeScope != null) : "useOptimistic=" + this.compiler.useOptimisticTypes() + " isOnDemand=" + this.compiler.isOnDemandCompilation() + " scope=" + this.runtimeScope;
        if (this.runtimeScope.findProperty(symbolName, false) == null) {
            this.runtimeScope.addOwnProperty(symbolName, 7, ScriptRuntime.UNDEFINED);
        }
    }

    private Object evaluateSafely(Expression expr) {
        if (expr instanceof IdentNode) {
            return this.runtimeScope == null ? null : TypeEvaluator.evaluatePropertySafely(this.runtimeScope, ((IdentNode)expr).getName());
        }
        if (expr instanceof AccessNode) {
            AccessNode accessNode = (AccessNode)expr;
            Object base = this.evaluateSafely(accessNode.getBase());
            if (!(base instanceof ScriptObject)) {
                return null;
            }
            return TypeEvaluator.evaluatePropertySafely((ScriptObject)base, accessNode.getProperty());
        }
        return null;
    }

    private static Object evaluatePropertySafely(ScriptObject sobj, String name) {
        ScriptObject owner;
        FindProperty find = sobj.findProperty(name, true);
        if (find == null) {
            return null;
        }
        Property property = find.getProperty();
        if (property.hasGetterFunction(owner = find.getOwner())) {
            return null;
        }
        return property.getObjectValue(owner, owner);
    }

    private Type getEvaluatedType(Optimistic expr) {
        CallNode callExpr;
        Expression fnExpr;
        if (expr instanceof IdentNode) {
            if (this.runtimeScope == null) {
                return null;
            }
            return TypeEvaluator.getPropertyType(this.runtimeScope, ((IdentNode)expr).getName());
        }
        if (expr instanceof AccessNode) {
            AccessNode accessNode = (AccessNode)expr;
            Object base = this.evaluateSafely(accessNode.getBase());
            if (!(base instanceof ScriptObject)) {
                return null;
            }
            return TypeEvaluator.getPropertyType((ScriptObject)base, accessNode.getProperty());
        }
        if (expr instanceof IndexNode) {
            IndexNode indexNode = (IndexNode)expr;
            Object base = this.evaluateSafely(indexNode.getBase());
            if (base instanceof NativeArray || base instanceof ArrayBufferView) {
                return ((ScriptObject)base).getArray().getOptimisticType();
            }
        } else if (expr instanceof CallNode && (fnExpr = (callExpr = (CallNode)expr).getFunction()) instanceof FunctionNode && this.compiler.getContext().getEnv()._lazy_compilation) {
            RecompilableScriptFunctionData data;
            FunctionNode fn = (FunctionNode)fnExpr;
            if (callExpr.getArgs().isEmpty() && (data = this.compiler.getScriptFunctionData(fn.getId())) != null) {
                Type returnType = Type.typeFor(data.getReturnType(EMPTY_INVOCATION_TYPE, this.runtimeScope));
                if (returnType == Type.BOOLEAN) {
                    return Type.OBJECT;
                }
                assert (returnType == Type.INT || returnType == Type.NUMBER || returnType == Type.OBJECT);
                return returnType;
            }
        }
        return null;
    }
}

