/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.ir;

import org.codelibs.sai.internal.codegen.types.Type;
import org.codelibs.sai.internal.ir.Expression;
import org.codelibs.sai.internal.ir.FunctionCall;
import org.codelibs.sai.internal.ir.Optimistic;
import org.codelibs.sai.internal.ir.annotations.Immutable;
import org.codelibs.sai.internal.parser.TokenType;

@Immutable
public abstract class BaseNode
extends Expression
implements FunctionCall,
Optimistic {
    private static final long serialVersionUID = 1L;
    protected final Expression base;
    private final boolean isFunction;
    protected final Type type;
    protected final int programPoint;

    public BaseNode(long token, int finish, Expression base, boolean isFunction) {
        super(token, base.getStart(), finish);
        this.base = base;
        this.isFunction = isFunction;
        this.type = null;
        this.programPoint = -1;
    }

    protected BaseNode(BaseNode baseNode, Expression base, boolean isFunction, Type callSiteType, int programPoint) {
        super(baseNode);
        this.base = base;
        this.isFunction = isFunction;
        this.type = callSiteType;
        this.programPoint = programPoint;
    }

    public Expression getBase() {
        return this.base;
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    @Override
    public Type getType() {
        return this.type == null ? this.getMostPessimisticType() : this.type;
    }

    @Override
    public int getProgramPoint() {
        return this.programPoint;
    }

    @Override
    public Type getMostOptimisticType() {
        return Type.INT;
    }

    @Override
    public Type getMostPessimisticType() {
        return Type.OBJECT;
    }

    @Override
    public boolean canBeOptimistic() {
        return true;
    }

    public boolean isIndex() {
        return this.isTokenType(TokenType.LBRACKET);
    }

    public abstract BaseNode setIsFunction();
}

