/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.runtime.arrays;

import org.codelibs.sai.internal.objects.Global;
import org.codelibs.sai.internal.runtime.ECMAErrors;
import org.codelibs.sai.internal.runtime.PropertyDescriptor;
import org.codelibs.sai.internal.runtime.arrays.ArrayData;
import org.codelibs.sai.internal.runtime.arrays.ArrayFilter;
import org.codelibs.sai.internal.runtime.arrays.ArrayIndex;

class SealedArrayFilter
extends ArrayFilter {
    SealedArrayFilter(ArrayData underlying) {
        super(underlying);
    }

    @Override
    public ArrayData copy() {
        return new SealedArrayFilter(this.underlying.copy());
    }

    @Override
    public ArrayData slice(long from, long to) {
        return this.getUnderlying().slice(from, to);
    }

    @Override
    public boolean canDelete(int index, boolean strict) {
        return this.canDelete(ArrayIndex.toLongIndex(index), strict);
    }

    @Override
    public boolean canDelete(long longIndex, boolean strict) {
        if (strict) {
            throw ECMAErrors.typeError("cant.delete.property", Long.toString(longIndex), "sealed array");
        }
        return false;
    }

    @Override
    public PropertyDescriptor getDescriptor(Global global, int index) {
        return global.newDataDescriptor(this.getObject(index), false, true, true);
    }
}

