/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.sai.internal.codegen.types.Type;
import org.codelibs.sai.internal.dynalink.CallSiteDescriptor;
import org.codelibs.sai.internal.dynalink.beans.BeansLinker;
import org.codelibs.sai.internal.dynalink.linker.GuardedInvocation;
import org.codelibs.sai.internal.dynalink.linker.GuardedTypeConversion;
import org.codelibs.sai.internal.dynalink.linker.GuardingDynamicLinker;
import org.codelibs.sai.internal.dynalink.linker.GuardingTypeConverterFactory;
import org.codelibs.sai.internal.dynalink.linker.LinkRequest;
import org.codelibs.sai.internal.dynalink.linker.LinkerServices;
import org.codelibs.sai.internal.dynalink.support.Guards;
import org.codelibs.sai.internal.lookup.Lookup;
import org.codelibs.sai.internal.runtime.ECMAErrors;
import org.codelibs.sai.internal.runtime.JSType;
import org.codelibs.sai.internal.runtime.ScriptRuntime;
import org.codelibs.sai.internal.runtime.UnwarrantedOptimismException;
import org.codelibs.sai.internal.runtime.linker.Bootstrap;
import org.codelibs.sai.internal.runtime.linker.SaiCallSiteDescriptor;
import org.codelibs.sai.internal.runtime.linker.SaiLinker;

final class SaiBottomLinker
implements GuardingDynamicLinker,
GuardingTypeConverterFactory {
    private static final MethodHandle EMPTY_PROP_GETTER = Lookup.MH.dropArguments(Lookup.MH.constant(Object.class, ScriptRuntime.UNDEFINED), 0, Object.class);
    private static final MethodHandle EMPTY_ELEM_GETTER = Lookup.MH.dropArguments(EMPTY_PROP_GETTER, 0, Object.class);
    private static final MethodHandle EMPTY_PROP_SETTER = Lookup.MH.asType(EMPTY_ELEM_GETTER, EMPTY_ELEM_GETTER.type().changeReturnType(Void.TYPE));
    private static final MethodHandle EMPTY_ELEM_SETTER = Lookup.MH.dropArguments(EMPTY_PROP_SETTER, 0, Object.class);
    private static final Map<Class<?>, MethodHandle> CONVERTERS = new HashMap();

    SaiBottomLinker() {
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        Object self = linkRequest.getReceiver();
        if (self == null) {
            return SaiBottomLinker.linkNull(linkRequest);
        }
        assert (SaiBottomLinker.isExpectedObject(self)) : "Couldn't link " + linkRequest.getCallSiteDescriptor() + " for " + self.getClass().getName();
        return SaiBottomLinker.linkBean(linkRequest, linkerServices);
    }

    private static GuardedInvocation linkBean(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        String operator;
        SaiCallSiteDescriptor desc = (SaiCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        Object self = linkRequest.getReceiver();
        switch (operator = desc.getFirstOperator()) {
            case "new": {
                if (BeansLinker.isDynamicConstructor(self)) {
                    throw ECMAErrors.typeError("no.constructor.matches.args", ScriptRuntime.safeToString(self));
                }
                if (BeansLinker.isDynamicMethod(self)) {
                    throw ECMAErrors.typeError("method.not.constructor", ScriptRuntime.safeToString(self));
                }
                throw ECMAErrors.typeError("not.a.function", desc.getFunctionErrorMessage(self));
            }
            case "call": {
                if (BeansLinker.isDynamicConstructor(self)) {
                    throw ECMAErrors.typeError("constructor.requires.new", ScriptRuntime.safeToString(self));
                }
                if (BeansLinker.isDynamicMethod(self)) {
                    throw ECMAErrors.typeError("no.method.matches.args", ScriptRuntime.safeToString(self));
                }
                throw ECMAErrors.typeError("not.a.function", desc.getFunctionErrorMessage(self));
            }
            case "callMethod": {
                throw ECMAErrors.typeError("no.such.function", SaiBottomLinker.getArgument(linkRequest), ScriptRuntime.safeToString(self));
            }
            case "getMethod": {
                return SaiBottomLinker.getInvocation(Lookup.MH.dropArguments(JSType.GET_UNDEFINED.get(2), 0, Object.class), self, linkerServices, desc);
            }
            case "getProp": 
            case "getElem": {
                if (SaiCallSiteDescriptor.isOptimistic(desc)) {
                    throw new UnwarrantedOptimismException(ScriptRuntime.UNDEFINED, SaiCallSiteDescriptor.getProgramPoint(desc), Type.OBJECT);
                }
                if (desc.getOperand() != null) {
                    return SaiBottomLinker.getInvocation(EMPTY_PROP_GETTER, self, linkerServices, desc);
                }
                return SaiBottomLinker.getInvocation(EMPTY_ELEM_GETTER, self, linkerServices, desc);
            }
            case "setProp": 
            case "setElem": {
                boolean strict = SaiCallSiteDescriptor.isStrict(desc);
                if (strict) {
                    throw ECMAErrors.typeError("cant.set.property", SaiBottomLinker.getArgument(linkRequest), ScriptRuntime.safeToString(self));
                }
                if (desc.getOperand() != null) {
                    return SaiBottomLinker.getInvocation(EMPTY_PROP_SETTER, self, linkerServices, desc);
                }
                return SaiBottomLinker.getInvocation(EMPTY_ELEM_SETTER, self, linkerServices, desc);
            }
        }
        throw new AssertionError((Object)("unknown call type " + desc));
    }

    @Override
    public GuardedTypeConversion convertToType(Class<?> sourceType, Class<?> targetType) throws Exception {
        GuardedInvocation gi = SaiBottomLinker.convertToTypeNoCast(sourceType, targetType);
        return gi == null ? null : new GuardedTypeConversion(gi.asType(Lookup.MH.type(targetType, sourceType)), true);
    }

    private static GuardedInvocation convertToTypeNoCast(Class<?> sourceType, Class<?> targetType) throws Exception {
        MethodHandle mh = CONVERTERS.get(targetType);
        if (mh != null) {
            return new GuardedInvocation(mh);
        }
        return null;
    }

    private static GuardedInvocation getInvocation(MethodHandle handle, Object self, LinkerServices linkerServices, CallSiteDescriptor desc) {
        return Bootstrap.asTypeSafeReturn(new GuardedInvocation(handle, Guards.getClassGuard(self.getClass())), linkerServices, desc);
    }

    private static boolean isExpectedObject(Object obj) {
        return !SaiLinker.canLinkTypeStatic(obj.getClass());
    }

    private static GuardedInvocation linkNull(LinkRequest linkRequest) {
        String operator;
        SaiCallSiteDescriptor desc = (SaiCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        switch (operator = desc.getFirstOperator()) {
            case "new": 
            case "call": {
                throw ECMAErrors.typeError("not.a.function", "null");
            }
            case "callMethod": 
            case "getMethod": {
                throw ECMAErrors.typeError("no.such.function", SaiBottomLinker.getArgument(linkRequest), "null");
            }
            case "getProp": 
            case "getElem": {
                throw ECMAErrors.typeError("cant.get.property", SaiBottomLinker.getArgument(linkRequest), "null");
            }
            case "setProp": 
            case "setElem": {
                throw ECMAErrors.typeError("cant.set.property", SaiBottomLinker.getArgument(linkRequest), "null");
            }
        }
        throw new AssertionError((Object)("unknown call type " + desc));
    }

    private static String getArgument(LinkRequest linkRequest) {
        CallSiteDescriptor desc = linkRequest.getCallSiteDescriptor();
        if (desc.getNameTokenCount() > 2) {
            return desc.getNameToken(2);
        }
        return ScriptRuntime.safeToString(linkRequest.getArguments()[1]);
    }

    static {
        CONVERTERS.put(Boolean.TYPE, JSType.TO_BOOLEAN.methodHandle());
        CONVERTERS.put(Double.TYPE, JSType.TO_NUMBER.methodHandle());
        CONVERTERS.put(Integer.TYPE, JSType.TO_INTEGER.methodHandle());
        CONVERTERS.put(Long.TYPE, JSType.TO_LONG.methodHandle());
        CONVERTERS.put(String.class, JSType.TO_STRING.methodHandle());
    }
}

