/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import org.codelibs.sai.api.scripting.JSObject;
import org.codelibs.sai.internal.dynalink.CallSiteDescriptor;
import org.codelibs.sai.internal.dynalink.linker.LinkRequest;
import org.codelibs.sai.internal.lookup.Lookup;
import org.codelibs.sai.internal.objects.Global;
import org.codelibs.sai.internal.runtime.JSType;
import org.codelibs.sai.internal.runtime.Property;
import org.codelibs.sai.internal.runtime.PropertyMap;
import org.codelibs.sai.internal.runtime.ScriptFunction;
import org.codelibs.sai.internal.runtime.ScriptObject;
import org.codelibs.sai.internal.runtime.linker.SaiCallSiteDescriptor;
import org.codelibs.sai.internal.runtime.options.Options;

public final class SaiGuards {
    private static final MethodHandle IS_MAP = SaiGuards.findOwnMH("isMap", Boolean.TYPE, ScriptObject.class, PropertyMap.class);
    private static final MethodHandle IS_MAP_SCRIPTOBJECT = SaiGuards.findOwnMH("isMap", Boolean.TYPE, Object.class, PropertyMap.class);
    private static final MethodHandle IS_SCRIPTOBJECT = SaiGuards.findOwnMH("isScriptObject", Boolean.TYPE, Object.class);
    private static final MethodHandle IS_NOT_JSOBJECT = SaiGuards.findOwnMH("isNotJSObject", Boolean.TYPE, Object.class);
    private static final MethodHandle SAME_OBJECT = SaiGuards.findOwnMH("sameObject", Boolean.TYPE, Object.class, WeakReference.class);
    private static final boolean CCE_ONLY = Options.getBooleanProperty("sai.cce");

    private SaiGuards() {
    }

    public static boolean explicitInstanceOfCheck(CallSiteDescriptor desc, LinkRequest request) {
        return !CCE_ONLY;
    }

    public static MethodHandle getScriptObjectGuard() {
        return IS_SCRIPTOBJECT;
    }

    public static MethodHandle getNotJSObjectGuard() {
        return IS_NOT_JSOBJECT;
    }

    public static MethodHandle getScriptObjectGuard(boolean explicitInstanceOfCheck) {
        return explicitInstanceOfCheck ? IS_SCRIPTOBJECT : null;
    }

    public static MethodHandle getMapGuard(PropertyMap map, boolean explicitInstanceOfCheck) {
        return Lookup.MH.insertArguments(explicitInstanceOfCheck ? IS_MAP_SCRIPTOBJECT : IS_MAP, 1, map);
    }

    static boolean needsGuard(Property property, CallSiteDescriptor desc) {
        return property == null || property.isConfigurable() || property.isBound() || property.hasDualFields() || !SaiCallSiteDescriptor.isFastScope(desc) || property.canChangeType();
    }

    public static MethodHandle getGuard(ScriptObject sobj, Property property, CallSiteDescriptor desc, boolean explicitInstanceOfCheck) {
        if (!SaiGuards.needsGuard(property, desc)) {
            return null;
        }
        if (SaiCallSiteDescriptor.isScope(desc)) {
            if (property != null && property.isBound() && !property.canChangeType()) {
                return SaiGuards.getIdentityGuard(sobj);
            }
            if (!(sobj instanceof Global) && (property == null || property.isConfigurable())) {
                return SaiGuards.combineGuards(SaiGuards.getIdentityGuard(sobj), SaiGuards.getMapGuard(sobj.getMap(), explicitInstanceOfCheck));
            }
        }
        return SaiGuards.getMapGuard(sobj.getMap(), explicitInstanceOfCheck);
    }

    public static MethodHandle getIdentityGuard(ScriptObject sobj) {
        return Lookup.MH.insertArguments(SAME_OBJECT, 1, new WeakReference<ScriptObject>(sobj));
    }

    public static MethodHandle getStringGuard() {
        return JSType.IS_STRING.methodHandle();
    }

    public static MethodHandle getNumberGuard() {
        return JSType.IS_NUMBER.methodHandle();
    }

    public static MethodHandle combineGuards(MethodHandle guard1, MethodHandle guard2) {
        if (guard1 == null) {
            return guard2;
        }
        if (guard2 == null) {
            return guard1;
        }
        return Lookup.MH.guardWithTest(guard1, guard2, Lookup.MH.dropArguments(Lookup.MH.constant(Boolean.TYPE, false), 0, Object.class));
    }

    private static boolean isScriptObject(Object self) {
        return self instanceof ScriptObject;
    }

    private static boolean isScriptObject(Class<? extends ScriptObject> clazz, Object self) {
        return clazz.isInstance(self);
    }

    private static boolean isMap(ScriptObject self, PropertyMap map) {
        return self.getMap() == map;
    }

    private static boolean isNotJSObject(Object self) {
        return !(self instanceof JSObject);
    }

    private static boolean isMap(Object self, PropertyMap map) {
        return self instanceof ScriptObject && ((ScriptObject)self).getMap() == map;
    }

    private static boolean sameObject(Object self, WeakReference<ScriptObject> ref) {
        return self == ref.get();
    }

    private static boolean isScriptFunction(Object self) {
        return self instanceof ScriptFunction;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), SaiGuards.class, name, Lookup.MH.type(rtype, types));
    }
}

