/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sai.internal.runtime.linker;

import java.lang.reflect.Modifier;
import org.codelibs.sai.internal.dynalink.CallSiteDescriptor;
import org.codelibs.sai.internal.dynalink.beans.BeansLinker;
import org.codelibs.sai.internal.dynalink.beans.StaticClass;
import org.codelibs.sai.internal.dynalink.linker.GuardedInvocation;
import org.codelibs.sai.internal.dynalink.linker.GuardingDynamicLinker;
import org.codelibs.sai.internal.dynalink.linker.LinkRequest;
import org.codelibs.sai.internal.dynalink.linker.LinkerServices;
import org.codelibs.sai.internal.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.codelibs.sai.internal.dynalink.support.Guards;
import org.codelibs.sai.internal.runtime.Context;
import org.codelibs.sai.internal.runtime.ECMAErrors;
import org.codelibs.sai.internal.runtime.linker.Bootstrap;
import org.codelibs.sai.internal.runtime.linker.JavaAdapterFactory;
import org.codelibs.sai.internal.runtime.linker.SaiBeansLinker;
import org.codelibs.sai.internal.runtime.linker.SaiLinker;

final class SaiStaticClassLinker
implements TypeBasedGuardingDynamicLinker {
    private static final GuardingDynamicLinker staticClassLinker = BeansLinker.getLinkerForClass(StaticClass.class);

    SaiStaticClassLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return type == StaticClass.class;
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        LinkRequest request = linkRequest.withoutRuntimeContext();
        Object self = request.getReceiver();
        if (self.getClass() != StaticClass.class) {
            return null;
        }
        Class<?> receiverClass = ((StaticClass)self).getRepresentedClass();
        Bootstrap.checkReflectionAccess(receiverClass, true);
        CallSiteDescriptor desc = request.getCallSiteDescriptor();
        if ("new".equals(desc.getNameToken(1))) {
            if (!Modifier.isPublic(receiverClass.getModifiers())) {
                throw ECMAErrors.typeError("new.on.nonpublic.javatype", receiverClass.getName());
            }
            Context.checkPackageAccess(receiverClass);
            if (SaiLinker.isAbstractClass(receiverClass)) {
                Object[] args = request.getArguments();
                args[0] = JavaAdapterFactory.getAdapterClassFor(new Class[]{receiverClass}, null, linkRequest.getCallSiteDescriptor().getLookup());
                LinkRequest adapterRequest = request.replaceArguments(request.getCallSiteDescriptor(), args);
                GuardedInvocation gi = SaiStaticClassLinker.checkNullConstructor(SaiStaticClassLinker.delegate(linkerServices, adapterRequest), receiverClass);
                return gi.replaceMethods(gi.getInvocation(), Guards.getIdentityGuard(self));
            }
            return SaiStaticClassLinker.checkNullConstructor(SaiStaticClassLinker.delegate(linkerServices, request), receiverClass);
        }
        return SaiStaticClassLinker.delegate(linkerServices, request);
    }

    private static GuardedInvocation delegate(LinkerServices linkerServices, LinkRequest request) throws Exception {
        return SaiBeansLinker.getGuardedInvocation(staticClassLinker, request, linkerServices);
    }

    private static GuardedInvocation checkNullConstructor(GuardedInvocation ctorInvocation, Class<?> receiverClass) {
        if (ctorInvocation == null) {
            throw ECMAErrors.typeError("no.constructor.matches.args", receiverClass.getName());
        }
        return ctorInvocation;
    }
}

