/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import org.codelibs.spnego.Base64;

final class SpnegoAuthScheme {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final String scheme;
    private final String token;
    private final boolean basicScheme;
    private final boolean negotiateScheme;
    private final boolean ntlm;

    SpnegoAuthScheme(String authScheme, String authToken) {
        this.scheme = authScheme;
        this.token = authToken;
        this.ntlm = null == authToken || authToken.isEmpty() ? false : authToken.startsWith("TlRMTVNT");
        this.negotiateScheme = "Negotiate".equalsIgnoreCase(authScheme);
        this.basicScheme = "Basic".equalsIgnoreCase(authScheme);
    }

    boolean isBasicScheme() {
        return this.basicScheme;
    }

    boolean isNegotiateScheme() {
        return this.negotiateScheme;
    }

    boolean isNtlmToken() {
        return this.ntlm;
    }

    String getScheme() {
        return this.scheme;
    }

    byte[] getToken() {
        return null == this.token ? EMPTY_BYTE_ARRAY : Base64.decode(this.token);
    }

    public String toString() {
        return "SpnegoAuthScheme [scheme=" + this.scheme + ", token=" + this.token + ", basicScheme=" + this.basicScheme + ", negotiateScheme=" + this.negotiateScheme + ", ntlm=" + this.ntlm + "]";
    }
}

