/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.codelibs.spnego.Base64;
import org.codelibs.spnego.SpnegoAuthScheme;
import org.codelibs.spnego.SpnegoFilterConfig;
import org.codelibs.spnego.SpnegoHttpServletResponse;
import org.codelibs.spnego.SpnegoPrincipal;
import org.codelibs.spnego.SpnegoProvider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public final class SpnegoAuthenticator {
    private static final Logger LOGGER = Logger.getLogger("Spnego");
    private static final Lock LOCK = new ReentrantLock();
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private final boolean allowBasic;
    private final boolean allowDelegation;
    private final boolean allowLocalhost;
    private final boolean allowUnsecure;
    private final boolean promptIfNtlm;
    private final String clientModuleName;
    private final LoginContext loginContext;
    private final GSSCredential serverCredentials;
    private final KerberosPrincipal serverPrincipal;

    public SpnegoAuthenticator(SpnegoFilterConfig config) throws LoginException, GSSException, PrivilegedActionException {
        LOGGER.fine(() -> "config=" + config);
        this.allowBasic = config.isBasicAllowed();
        this.allowUnsecure = config.isUnsecureAllowed();
        this.clientModuleName = config.getClientLoginModule();
        this.allowLocalhost = config.isLocalhostAllowed();
        this.promptIfNtlm = config.downgradeNtlm();
        this.allowDelegation = config.isDelegationAllowed();
        if (config.useKeyTab()) {
            this.loginContext = new LoginContext(config.getServerLoginModule());
        } else {
            CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(config.getPreauthUsername(), config.getPreauthPassword());
            this.loginContext = new LoginContext(config.getServerLoginModule(), handler);
        }
        LOGGER.fine(() -> "logging in context: " + this.loginContext);
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(this.serverCredentials.getName().toString());
        LOGGER.fine(() -> "serverCredentials: " + this.serverCredentials + ", serverPrincipal: " + this.serverPrincipal);
    }

    public SpnegoAuthenticator(final Map<String, String> config) throws LoginException, GSSException, PrivilegedActionException, FileNotFoundException, URISyntaxException {
        this(SpnegoFilterConfig.getInstance(new FilterConfig(){
            private final Map<String, String> map;
            {
                this.map = Collections.unmodifiableMap(config);
            }

            public String getFilterName() {
                throw new UnsupportedOperationException();
            }

            public String getInitParameter(String param) {
                if (null == this.map.get(param)) {
                    throw new NullPointerException("Config missing param value for: " + param);
                }
                return this.map.get(param);
            }

            public Enumeration<String> getInitParameterNames() {
                throw new UnsupportedOperationException();
            }

            public ServletContext getServletContext() {
                throw new UnsupportedOperationException();
            }
        }));
    }

    public SpnegoAuthenticator(String loginModuleName, SpnegoFilterConfig config) throws LoginException, GSSException, PrivilegedActionException {
        boolean hasUsername;
        LOGGER.fine(() -> "loginModuleName=" + loginModuleName);
        this.allowBasic = config.isBasicAllowed();
        this.allowUnsecure = config.isUnsecureAllowed();
        this.clientModuleName = config.getClientLoginModule();
        this.allowLocalhost = config.isLocalhostAllowed();
        this.promptIfNtlm = config.downgradeNtlm();
        this.allowDelegation = config.isDelegationAllowed();
        String username = config.getPreauthUsername();
        boolean bl = hasUsername = null != username && !username.trim().isEmpty();
        if (hasUsername) {
            this.loginContext = new LoginContext(loginModuleName, SpnegoProvider.getUsernamePasswordHandler(username, config.getPreauthPassword()));
        } else if (config.useKeyTab()) {
            this.loginContext = new LoginContext(loginModuleName);
        } else {
            throw new IllegalArgumentException("Must provide a username/password or specify a keytab file");
        }
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(this.serverCredentials.getName().toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpnegoPrincipal authenticate(HttpServletRequest req, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        if (this.allowLocalhost && this.isLocalhost(req)) {
            return this.doLocalhost();
        }
        String serverRealm = this.serverPrincipal.getRealm();
        boolean basicSupported = this.allowBasic && (this.allowUnsecure || req.isSecure());
        LOGGER.fine(() -> "Negotiating: serverRealm: " + serverRealm + ", basicSupported: " + basicSupported + ", promptIfNtlm: " + this.promptIfNtlm);
        SpnegoAuthScheme scheme = SpnegoProvider.negotiate(req, resp, basicSupported, this.promptIfNtlm, serverRealm);
        if (null == scheme) {
            LOGGER.fine(() -> "scheme null.");
            return null;
        }
        if (scheme.isNegotiateScheme()) {
            return this.doSpnegoAuth(scheme, resp);
        }
        if (!scheme.isBasicScheme()) throw new UnsupportedOperationException("scheme=" + scheme);
        if (basicSupported) {
            return this.doBasicAuth(scheme, resp);
        }
        LOGGER.severe(() -> "allowBasic=" + this.allowBasic + "; allowUnsecure=" + this.allowUnsecure + "; req.isSecure()=" + req.isSecure());
        throw new UnsupportedOperationException("Basic Auth not allowed or SSL required.");
    }

    public void dispose() {
        if (null != this.serverCredentials) {
            try {
                this.serverCredentials.dispose();
            }
            catch (GSSException e) {
                LOGGER.log(Level.WARNING, e, () -> "Dispose failed.");
            }
        }
        if (null != this.loginContext) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException lex) {
                LOGGER.log(Level.WARNING, lex, () -> "Logout failed.");
            }
        }
    }

    private SpnegoPrincipal doBasicAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws IOException {
        LOGGER.fine(() -> "Starting Basic Auth...");
        byte[] data = scheme.getToken();
        if (0 == data.length) {
            LOGGER.fine(() -> "Basic Auth data was NULL.");
            return null;
        }
        String tokenData = new String(data);
        LOGGER.fine(() -> "tokenData: " + tokenData);
        String[] basicData = tokenData.split(":", 2);
        if (basicData.length != 2) {
            throw new IllegalArgumentException("Username/Password may have contained an invalid character. basicData.length=" + basicData.length);
        }
        String username = basicData[0].substring(basicData[0].indexOf(92) + 1);
        String password = basicData[1];
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        SpnegoPrincipal principal = null;
        try {
            if (null == username || username.isEmpty()) {
                throw new LoginException("Username is required.");
            }
            LoginContext cntxt = new LoginContext(this.clientModuleName, handler);
            LOGGER.fine(() -> "logging in context: " + cntxt);
            cntxt.login();
            cntxt.logout();
            principal = new SpnegoPrincipal(username + '@' + this.serverPrincipal.getRealm(), 1);
            LOGGER.fine(() -> "principal: " + username + '@' + this.serverPrincipal.getRealm());
        }
        catch (LoginException lex) {
            LOGGER.log(Level.FINE, lex, () -> "Login failed. username=" + username);
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.serverPrincipal.getRealm() + '\"');
            resp.setStatus(401, true);
        }
        return principal;
    }

    private SpnegoPrincipal doLocalhost() {
        String username = System.getProperty("user.name");
        if (null == username || username.isEmpty()) {
            LOGGER.fine(() -> "login as server.principal:" + this.serverPrincipal.getName() + " on localhost");
            return new SpnegoPrincipal(this.serverPrincipal.getName() + '@' + this.serverPrincipal.getRealm(), this.serverPrincipal.getNameType());
        }
        LOGGER.fine(() -> "login as user.name:" + username + " on localhost");
        return new SpnegoPrincipal(username + '@' + this.serverPrincipal.getRealm(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpnegoPrincipal doSpnegoAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        String principal;
        LOGGER.fine(() -> "Starting SPNEGO Auth: " + scheme);
        byte[] gss = scheme.getToken();
        if (0 == gss.length) {
            LOGGER.fine(() -> "GSS data was NULL.");
            return null;
        }
        GSSContext context = null;
        GSSCredential delegCred = null;
        LOGGER.fine(() -> "serverCredentials: " + this.serverCredentials);
        try {
            byte[] token;
            LOCK.lock();
            try {
                context = MANAGER.createContext(this.serverCredentials);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("context: " + context);
                }
                token = context.acceptSecContext(gss, 0, gss.length);
            }
            finally {
                LOCK.unlock();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Mechanism: " + context.getMech());
            }
            if (null == token) {
                LOGGER.fine(() -> "Token was NULL.");
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            resp.setHeader("WWW-Authenticate", "Negotiate " + Base64.encode(token));
            boolean established = context.isEstablished();
            boolean protReady = context.isProtReady();
            LOGGER.fine(() -> "established: " + established + ", protReady: " + protReady);
            if (!established && !protReady) {
                LOGGER.fine(() -> "context is not established. ");
                resp.setStatus(401, true);
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            principal = context.getSrcName().toString();
            LOGGER.fine(() -> "principal from GSS: " + principal);
            if (this.allowDelegation && context.getCredDelegState()) {
                GSSCredential gssCredential;
                delegCred = gssCredential = context.getDelegCred();
                LOGGER.fine(() -> "GSSCredential found: " + gssCredential);
            }
        }
        finally {
            if (null != context) {
                LOCK.lock();
                try {
                    LOGGER.fine(() -> "Disposing GSSContext...");
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
        return new SpnegoPrincipal(principal, 1, delegCred);
    }

    public String getServerRealm() {
        return this.serverPrincipal.getRealm();
    }

    private boolean isLocalhost(HttpServletRequest req) {
        boolean isLocal = req.getLocalAddr().equals(req.getRemoteAddr());
        if (!isLocal && "0.0.0.0".equals(req.getLocalAddr()) && "0:0:0:0:0:0:0:1".equals(req.getRemoteAddr())) {
            isLocal = true;
        }
        return isLocal;
    }
}

