/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codelibs.spnego.SpnegoAuthenticator;
import org.codelibs.spnego.SpnegoFilterConfig;
import org.codelibs.spnego.SpnegoHttpServletRequest;
import org.codelibs.spnego.SpnegoHttpServletResponse;
import org.codelibs.spnego.SpnegoPrincipal;
import org.codelibs.spnego.UserAccessControl;
import org.ietf.jgss.GSSException;

public class SpnegoHttpFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("Spnego");
    protected SpnegoAuthenticator authenticator;
    protected UserAccessControl accessControl;
    protected String sitewide;
    protected String page403;
    protected final List<String> excludeDirs = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            SpnegoFilterConfig config = SpnegoFilterConfig.getInstance(filterConfig);
            this.excludeDirs.addAll(config.getExcludeDirs());
            LOGGER.fine(() -> "excludeDirs=" + this.excludeDirs);
            this.authenticator = new SpnegoAuthenticator(config);
            Properties props = SpnegoHttpFilter.toProperties(filterConfig);
            if (!props.getProperty("spnego.authz.class", "").isEmpty()) {
                props.put("spnego.server.realm", this.authenticator.getServerRealm());
                this.page403 = props.getProperty("spnego.authz.403", "").trim();
                this.sitewide = props.getProperty("spnego.authz.sitewide", "").trim();
                this.sitewide = this.sitewide.isEmpty() ? null : this.sitewide;
                this.accessControl = (UserAccessControl)Class.forName(props.getProperty("spnego.authz.class")).newInstance();
                this.accessControl.init(props);
                LOGGER.fine(() -> "page403=" + this.page403);
                LOGGER.fine(() -> "sitewide=" + this.sitewide);
                LOGGER.fine(() -> "accessControl=" + this.accessControl);
            }
        }
        catch (FileNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | URISyntaxException | PrivilegedActionException | LoginException | GSSException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.page403 = null;
        this.sitewide = null;
        this.excludeDirs.clear();
        if (null != this.accessControl) {
            this.accessControl.destroy();
            this.accessControl = null;
        }
        if (null != this.authenticator) {
            this.authenticator.dispose();
            this.authenticator = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SpnegoPrincipal principal;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SpnegoHttpServletResponse spnegoResponse = new SpnegoHttpServletResponse((HttpServletResponse)response);
        if (this.exclude(httpRequest.getContextPath(), httpRequest.getServletPath())) {
            chain.doFilter(request, response);
            return;
        }
        try {
            principal = this.authenticator.authenticate(httpRequest, spnegoResponse);
        }
        catch (GSSException gsse) {
            LOGGER.severe(() -> "HTTP Authorization Header=" + httpRequest.getHeader("Authorization"));
            throw new ServletException((Throwable)gsse);
        }
        if (spnegoResponse.isStatusSet()) {
            LOGGER.fine(() -> "Sending response in authentication.");
            return;
        }
        if (null == principal) {
            LOGGER.severe(() -> "Principal was null.");
            spnegoResponse.setStatus(500, true);
            return;
        }
        LOGGER.fine(() -> "principal=" + principal);
        SpnegoHttpServletRequest spnegoRequest = new SpnegoHttpServletRequest(httpRequest, principal, this.accessControl);
        if (!this.isAuthorized((HttpServletRequest)spnegoRequest)) {
            LOGGER.info(() -> "Principal Not AuthoriZed: " + principal);
            if (this.page403.isEmpty()) {
                spnegoResponse.setStatus(403, true);
            } else {
                request.getRequestDispatcher(this.page403).forward((ServletRequest)spnegoRequest, response);
            }
            return;
        }
        this.processRequest(spnegoRequest, response, chain);
    }

    protected void processRequest(SpnegoHttpServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, response);
    }

    private boolean isAuthorized(HttpServletRequest request) {
        return null == this.sitewide || null == this.accessControl || this.accessControl.hasAccess(request.getRemoteUser(), this.sitewide);
    }

    private boolean exclude(String contextPath, String servletPath) {
        String path = contextPath + servletPath + (servletPath.endsWith("/") ? "" : "/");
        for (String dir : this.excludeDirs) {
            if (!path.startsWith(dir)) continue;
            return true;
        }
        return false;
    }

    private static Properties toProperties(FilterConfig filterConfig) {
        Properties props = new Properties();
        Enumeration it = filterConfig.getInitParameterNames();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            props.put(key, filterConfig.getInitParameter(key));
        }
        return props;
    }

    public static final class Constants {
        public static final String ALLOW_BASIC = "spnego.allow.basic";
        public static final String ALLOW_DELEGATION = "spnego.allow.delegation";
        public static final String ALLOW_LOCALHOST = "spnego.allow.localhost";
        public static final String ALLOW_UNSEC_BASIC = "spnego.allow.unsecure.basic";
        public static final String AUTHN_HEADER = "WWW-Authenticate";
        public static final String AUTHZ_HEADER = "Authorization";
        public static final String BASIC_HEADER = "Basic";
        public static final String CLIENT_MODULE = "spnego.login.client.module";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String EXCLUDE_DIRS = "spnego.exclude.dirs";
        public static final String KRB5_CONF = "spnego.krb5.conf";
        public static final String LOGGER_LEVEL = "spnego.logger.level";
        public static final String LOGGER_NAME = "Spnego";
        public static final String LOGIN_CONF = "spnego.login.conf";
        public static final String NEGOTIATE_HEADER = "Negotiate";
        public static final String NTLM_PROLOG = "TlRMTVNT";
        public static final String PREAUTH_PASSWORD = "spnego.preauth.password";
        public static final String PREAUTH_USERNAME = "spnego.preauth.username";
        public static final String PROMPT_NTLM = "spnego.prompt.ntlm";
        public static final String SERVER_MODULE = "spnego.login.server.module";
        public static final String SOAP_ACTION = "SOAPAction";

        private Constants() {
        }
    }
}

