/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.codelibs.spnego.DelegateServletRequest;
import org.codelibs.spnego.SpnegoAccessControl;
import org.codelibs.spnego.SpnegoPrincipal;
import org.codelibs.spnego.UserAccessControl;
import org.codelibs.spnego.UserInfo;
import org.ietf.jgss.GSSCredential;

public final class SpnegoHttpServletRequest
extends HttpServletRequestWrapper
implements DelegateServletRequest,
SpnegoAccessControl {
    private static final String MESSAGE_UNSUPPORTED = "User Access Control has NOT been defined or is NOT supported.";
    private final SpnegoPrincipal principal;
    private final UserAccessControl accessControl;

    SpnegoHttpServletRequest(HttpServletRequest request, SpnegoPrincipal spnegoPrincipal) {
        this(request, spnegoPrincipal, null);
    }

    SpnegoHttpServletRequest(HttpServletRequest request, SpnegoPrincipal spnegoPrincipal, UserAccessControl userAccessControl) {
        super(request);
        this.principal = spnegoPrincipal;
        this.accessControl = userAccessControl;
    }

    public String getAuthType() {
        String header = this.getHeader("Authorization");
        String authType = null == header ? super.getAuthType() : (header.startsWith("Negotiate") ? "Negotiate" : (header.startsWith("Basic") ? "Basic" : super.getAuthType()));
        return authType;
    }

    @Override
    public GSSCredential getDelegatedCredential() {
        return this.principal.getDelegatedCredential();
    }

    public String getRemoteUser() {
        if (null == this.principal) {
            return super.getRemoteUser();
        }
        String[] username = this.principal.getName().split("@", 2);
        return username[0];
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public boolean anyRole(String ... roles) {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        return this.accessControl.anyRole(this.getRemoteUser(), roles);
    }

    @Override
    public boolean hasRole(String role) {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        return this.accessControl.hasRole(this.getRemoteUser(), role);
    }

    @Override
    public boolean hasRole(String featureX, String ... featureYs) {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        return this.accessControl.hasRole(this.getRemoteUser(), featureX, featureYs);
    }

    @Override
    public boolean anyAccess(String ... resources) {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        return this.accessControl.anyAccess(this.getRemoteUser(), resources);
    }

    @Override
    public boolean hasAccess(String resource) {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        return this.accessControl.hasAccess(this.getRemoteUser(), resource);
    }

    @Override
    public boolean hasAccess(String resourceX, String ... resourceYs) {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        return this.accessControl.hasAccess(this.getRemoteUser(), resourceX, resourceYs);
    }

    @Override
    public UserInfo getUserInfo() {
        if (null == this.accessControl) {
            throw new UnsupportedOperationException(MESSAGE_UNSUPPORTED);
        }
        UserInfo userInfo = this.accessControl.getUserInfo(this.getRemoteUser());
        if (null == userInfo) {
            throw new UnsupportedOperationException("UserInfo was NULL and/or not configured");
        }
        return userInfo;
    }

    public boolean isUserInRole(String role) {
        return this.hasRole(role);
    }
}

