/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.codelibs.spnego.Base64;
import org.codelibs.spnego.SpnegoAuthScheme;
import org.codelibs.spnego.SpnegoProvider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public final class SpnegoHttpURLConnection {
    private static final Logger LOGGER = Logger.getLogger("Spnego");
    private static final Lock LOCK = new ReentrantLock();
    private static final byte[] EMPTY_BYTE = new byte[0];
    private boolean connected = false;
    private boolean instanceFollowRedirects = true;
    private String requestMethod = "GET";
    private final Map<String, List<String>> requestProperties = new LinkedHashMap<String, List<String>>();
    private final LoginContext loginContext;
    private GSSCredential credential;
    private boolean cntxtEstablished = false;
    private HttpURLConnection conn = null;
    private boolean reqCredDeleg = false;
    private boolean autoDisposeCreds = true;
    private int redirectCount = 0;
    private boolean mutualAuth = true;
    private boolean confidentiality = true;
    private boolean messageIntegrity = true;
    private boolean replayDetection = true;
    private boolean sequenceDetection = true;
    private static final int MAX_REDIRECTS = 20;

    public SpnegoHttpURLConnection(String loginModuleName) throws LoginException {
        this.loginContext = new LoginContext(loginModuleName);
        this.loginContext.login();
        this.credential = null;
    }

    public SpnegoHttpURLConnection(GSSCredential creds) {
        this(creds, true);
    }

    public SpnegoHttpURLConnection(GSSCredential creds, boolean dispose) {
        this.loginContext = null;
        this.credential = creds;
        this.autoDisposeCreds = dispose;
    }

    public SpnegoHttpURLConnection(String loginModuleName, String username, String password) throws LoginException {
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        this.loginContext = new LoginContext(loginModuleName, handler);
        this.loginContext.login();
        this.credential = null;
    }

    private void assertConnected() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
    }

    private void assertNotConnected() {
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
    }

    public HttpURLConnection connect(URL url) throws GSSException, PrivilegedActionException, IOException {
        return this.connect(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection connect(URL url, ByteArrayOutputStream dooutput) throws GSSException, PrivilegedActionException, IOException {
        byte[] data;
        GSSContext context;
        block23: {
            if (!this.messageIntegrity && this.confidentiality) {
                throw new IllegalStateException("Message Integrity was set to false but Confidentiality set to true.");
            }
            this.assertNotConnected();
            context = null;
            try {
                data = null;
                LOCK.lock();
                try {
                    try {
                        Thread.sleep(31L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    context = this.getGSSContext(url);
                    context.requestMutualAuth(this.mutualAuth);
                    context.requestConf(this.confidentiality);
                    context.requestInteg(this.messageIntegrity);
                    context.requestReplayDet(this.replayDetection);
                    context.requestSequenceDet(this.sequenceDetection);
                    context.requestCredDeleg(this.reqCredDeleg);
                    data = context.initSecContext(EMPTY_BYTE, 0, 0);
                }
                finally {
                    LOCK.unlock();
                }
                this.conn = (HttpURLConnection)url.openConnection();
                this.connected = true;
                Set<String> keys = this.requestProperties.keySet();
                for (String key : keys) {
                    for (String value : this.requestProperties.get(key)) {
                        this.conn.addRequestProperty(key, value);
                    }
                }
                this.conn.setInstanceFollowRedirects(false);
                this.conn.setRequestMethod(this.requestMethod);
                this.conn.setRequestProperty("Authorization", "Negotiate " + Base64.encode(data));
                if (null != dooutput && dooutput.size() > 0) {
                    this.conn.setDoOutput(true);
                    dooutput.writeTo(this.conn.getOutputStream());
                }
                this.conn.connect();
                if (this.conn.getResponseCode() != 302 || this.redirectCount >= 20) break block23;
                HttpURLConnection httpURLConnection = this.redirect(url, dooutput);
                this.dispose(context);
                return httpURLConnection;
            }
            catch (Throwable throwable) {
                this.dispose(context);
                throw throwable;
            }
        }
        SpnegoAuthScheme scheme = SpnegoProvider.getAuthScheme(this.conn.getHeaderField("WWW-Authenticate"));
        if (null == scheme) {
            LOGGER.fine(() -> "SpnegoProvider.getAuthScheme(...) returned null.");
        } else if (this.conn.getResponseCode() == 200 && !this.mutualAuth) {
            LOGGER.fine(() -> "SpnegoProvider.getAuthScheme(...) returned null.");
        } else {
            data = scheme.getToken();
            if ("Negotiate".equalsIgnoreCase(scheme.getScheme())) {
                LOCK.lock();
                try {
                    data = context.initSecContext(data, 0, data.length);
                }
                finally {
                    LOCK.unlock();
                }
                if (null != data) {
                    int dataLength = data.length;
                    LOGGER.warning(() -> "Server requested context loop: " + dataLength);
                }
            } else {
                throw new UnsupportedOperationException("Scheme NOT Supported: " + scheme.getScheme());
            }
            this.cntxtEstablished = context.isEstablished();
        }
        this.dispose(context);
        return this.conn;
    }

    private void dispose(GSSContext context) {
        if (null != context) {
            try {
                LOCK.lock();
                try {
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
            catch (GSSException gsse) {
                LOGGER.log(Level.WARNING, gsse, () -> "call to dispose context failed.");
            }
        }
        if (null != this.credential && this.autoDisposeCreds) {
            try {
                this.credential.dispose();
            }
            catch (GSSException gsse) {
                LOGGER.log(Level.WARNING, gsse, () -> "call to dispose credential failed.");
            }
        }
        if (null != this.loginContext) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException lex) {
                LOGGER.log(Level.WARNING, lex, () -> "call to logout context failed.");
            }
        }
    }

    public void disconnect() {
        this.dispose(null);
        this.requestProperties.clear();
        this.connected = false;
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }

    public boolean isContextEstablished() {
        return this.cntxtEstablished;
    }

    private void assertKeyValue(String key, String value) {
        if (null == key || key.isEmpty()) {
            throw new IllegalArgumentException("key parameter is null or empty");
        }
        if (null == value) {
            throw new IllegalArgumentException("value parameter is null");
        }
    }

    public void addRequestProperty(String key, String value) {
        this.assertNotConnected();
        this.assertKeyValue(key, value);
        if (this.requestProperties.containsKey(key)) {
            this.requestProperties.get(key).add(value);
        } else {
            this.setRequestProperty(key, value);
        }
    }

    public void setRequestProperty(String key, String value) {
        this.assertNotConnected();
        this.assertKeyValue(key, value);
        ArrayList<String> val = new ArrayList<String>();
        val.add(value);
        this.requestProperties.put(key, val);
    }

    private GSSContext getGSSContext(URL url) throws GSSException, PrivilegedActionException {
        if (null == this.credential) {
            if (null == this.loginContext) {
                throw new IllegalStateException("GSSCredential AND LoginContext NOT initialized");
            }
            this.credential = SpnegoProvider.getClientCredential(this.loginContext.getSubject());
        }
        return SpnegoProvider.getGSSContext(this.credential, url);
    }

    public InputStream getErrorStream() throws IOException {
        this.assertConnected();
        return this.conn.getInputStream();
    }

    public String getHeaderField(int index) {
        this.assertConnected();
        return this.conn.getHeaderField(index);
    }

    public String getHeaderField(String name) {
        this.assertConnected();
        return this.conn.getHeaderField(name);
    }

    public String getHeaderFieldKey(int index) {
        this.assertConnected();
        return this.conn.getHeaderFieldKey(index);
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.assertNotConnected();
        this.instanceFollowRedirects = followRedirects;
    }

    public InputStream getInputStream() throws IOException {
        this.assertConnected();
        return this.conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.assertConnected();
        return this.conn.getOutputStream();
    }

    public int getResponseCode() throws IOException {
        this.assertConnected();
        return this.conn.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        this.assertConnected();
        return this.conn.getResponseMessage();
    }

    private HttpURLConnection redirect(URL url, ByteArrayOutputStream dooutput) throws GSSException, PrivilegedActionException, IOException {
        ++this.redirectCount;
        String location = this.getHeaderField("location");
        assert (!location.isEmpty());
        if (!this.instanceFollowRedirects && '/' != location.charAt(0)) {
            URL erl = new URL(location);
            if (!url.getHost().equalsIgnoreCase(erl.getHost()) || url.getPort() != erl.getPort()) {
                this.redirectCount = 20;
                return this.conn;
            }
        }
        List<String> cookies = this.conn.getHeaderFields().get("Set-Cookie");
        this.conn.disconnect();
        this.connected = false;
        if (null != cookies) {
            this.requestProperties.remove("Cookie");
            for (String cookie : cookies) {
                this.addRequestProperty("Cookie", cookie);
            }
        }
        if ('/' == location.charAt(0)) {
            String[] str = url.toString().split("/");
            String newLocation = str[0] + "//" + str[2] + location;
            return this.connect(new URL(newLocation), dooutput);
        }
        return this.connect(new URL(location), dooutput);
    }

    public void requestCredDeleg(boolean requestDelegation) {
        this.assertNotConnected();
        this.reqCredDeleg = requestDelegation;
    }

    public void setConfidentiality(boolean confidential) {
        this.confidentiality = confidential;
    }

    public void setMessageIntegrity(boolean integrity) {
        this.messageIntegrity = integrity;
    }

    public void setMutualAuth(boolean mutual) {
        this.mutualAuth = mutual;
    }

    public void setReplayDetection(boolean replay) {
        this.replayDetection = replay;
    }

    public void setRequestMethod(String method) {
        this.assertNotConnected();
        this.requestMethod = method;
    }

    public void setSequenceDetection(boolean sequence) {
        this.sequenceDetection = sequence;
    }
}

