/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import java.security.Principal;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSCredential;

public final class SpnegoPrincipal
implements Principal {
    private final KerberosPrincipal kerberosPrincipal;
    private final GSSCredential delegatedCred;

    public SpnegoPrincipal(String name) {
        this.kerberosPrincipal = new KerberosPrincipal(name);
        this.delegatedCred = null;
    }

    public SpnegoPrincipal(String name, int nameType) {
        this.kerberosPrincipal = new KerberosPrincipal(name, nameType);
        this.delegatedCred = null;
    }

    public SpnegoPrincipal(String name, int nameType, GSSCredential delegCred) {
        this.kerberosPrincipal = new KerberosPrincipal(name, nameType);
        this.delegatedCred = delegCred;
    }

    public GSSCredential getDelegatedCredential() {
        return this.delegatedCred;
    }

    @Override
    public String getName() {
        return this.kerberosPrincipal.getName();
    }

    public int getNameType() {
        return this.kerberosPrincipal.getNameType();
    }

    public String getRealm() {
        return this.kerberosPrincipal.getRealm();
    }

    @Override
    public int hashCode() {
        int result = 31;
        result = 31 * result + this.kerberosPrincipal.hashCode();
        result = 31 * result + this.delegatedCred.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SpnegoPrincipal)) {
            return false;
        }
        SpnegoPrincipal obj = (SpnegoPrincipal)object;
        if (!this.kerberosPrincipal.equals(obj.kerberosPrincipal) || !this.delegatedCred.equals(obj.delegatedCred)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public String toString() {
        return this.kerberosPrincipal.toString();
    }
}

