/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codelibs.spnego.SpnegoHttpURLConnection;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpnegoSOAPConnection
extends SOAPConnection {
    private static final Logger LOGGER = Logger.getLogger(SpnegoSOAPConnection.class.getName());
    private final SpnegoHttpURLConnection conn;
    private final DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
    private final MessageFactory messageFactory;

    public SpnegoSOAPConnection(String loginModuleName) throws LoginException {
        this.conn = new SpnegoHttpURLConnection(loginModuleName);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public SpnegoSOAPConnection(GSSCredential creds) {
        this(creds, true);
    }

    public SpnegoSOAPConnection(GSSCredential creds, boolean dispose) {
        this.conn = new SpnegoHttpURLConnection(creds, dispose);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public SpnegoSOAPConnection(GSSCredential creds, boolean dispose, boolean confidential, boolean integrity) {
        this.conn = new SpnegoHttpURLConnection(creds, dispose);
        this.conn.setConfidentiality(confidential);
        this.conn.setMessageIntegrity(integrity);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public SpnegoSOAPConnection(String loginModuleName, String username, String password) throws LoginException {
        this.conn = new SpnegoHttpURLConnection(loginModuleName, username, password);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public final SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        LOGGER.fine(() -> "endpoint=" + endpoint);
        SOAPMessage message = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.conn.setRequestMethod("POST");
        try {
            MimeHeaders headers = request.getMimeHeaders();
            String[] contentType = headers.getHeader("Content-Type");
            String[] soapAction = headers.getHeader("SOAPAction");
            if (null == contentType) {
                StringBuilder header = new StringBuilder();
                if (null == soapAction) {
                    header.append("application/soap+xml; charset=UTF-8;");
                } else {
                    header.append("text/xml; charset=UTF-8;");
                }
                this.conn.addRequestProperty("Content-Type", header.toString());
            } else {
                if (contentType.length > 1) {
                    throw new IllegalArgumentException("Content-Type defined more than once.");
                }
                this.conn.addRequestProperty("Content-Type", contentType[0]);
            }
            if (null != soapAction) {
                if (soapAction.length > 1) {
                    throw new IllegalArgumentException("SOAPAction defined more than once.");
                }
                this.conn.addRequestProperty("SOAPAction", soapAction[0]);
            }
            request.writeTo((OutputStream)bos);
            this.conn.connect(new URL(endpoint.toString()), bos);
            message = this.createMessage(this.conn.getInputStream());
        }
        catch (IOException | PrivilegedActionException | GSSException e) {
            throw new SOAPException((Throwable)e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            this.close();
        }
        return message;
    }

    public final void close() {
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }

    private SOAPMessage createMessage(InputStream stream) throws SOAPException {
        Document document;
        try {
            document = this.parse(stream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SOAPException((Throwable)e);
        }
        Node soapBody = null;
        Element parent = document.getDocumentElement();
        if ("Envelope".equalsIgnoreCase(parent.getLocalName())) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!"Body".equalsIgnoreCase(node.getLocalName())) continue;
                soapBody = parent.removeChild(node);
                break;
            }
            if (null == soapBody) {
                throw new IllegalArgumentException("Response did not contain a SOAP 'Body'.");
            }
        } else {
            throw new IllegalArgumentException("Response did not contain a SOAP 'Envelope'.");
        }
        try {
            return this.transform(soapBody);
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            throw new SOAPException(e);
        }
    }

    private Document parse(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        this.documentFactory.setNamespaceAware(true);
        return this.documentFactory.newDocumentBuilder().parse(stream);
    }

    private SOAPMessage transform(Node soapBody) throws SOAPException, IOException, TransformerException, SAXException, ParserConfigurationException {
        SOAPMessage message = this.messageFactory.createMessage();
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer();
        NodeList children = soapBody.getChildNodes();
        LOGGER.fine(() -> "number of children=" + children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            int pos = i;
            LOGGER.fine(() -> "child[" + pos + "]=" + children.item(pos).getLocalName());
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                transformer.transform(new DOMSource(children.item(i)), new StreamResult(bos));
                bos.flush();
                try (ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());){
                    Document document = this.parse(bis);
                    message.getSOAPBody().addDocument(document);
                    continue;
                }
            }
        }
        return message;
    }
}

