/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.dkim;

import com.sun.mail.util.CRLFOutputStream;
import com.sun.mail.util.QPEncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Header;
import javax.mail.MessagingException;
import net.iharder.Base64;
import net.markenwerk.utils.data.fetcher.BufferedFetcher;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimAcceptanceException;
import net.markenwerk.utils.mail.dkim.DkimException;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigningException;
import net.markenwerk.utils.mail.dkim.DomainKeyUtil;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;

public class DkimSigner {
    private static final String DKIM_SIGNATUR_HEADER = "DKIM-Signature";
    private static final int MAX_HEADER_LENGTH = 67;
    private static final List<String> MIMIMUM_HEADERS_TO_SIGN = new ArrayList<String>(3);
    private static final List<String> DEFAULT_HEADERS_TO_SIGN = new ArrayList<String>(28);
    private final Set<String> headersToSign = new HashSet<String>(DEFAULT_HEADERS_TO_SIGN);
    private SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256_WITH_RSA;
    private Signature signature;
    private MessageDigest messageDigest;
    private String signingDomain;
    private String selector;
    private String identity;
    private boolean lengthParam;
    private boolean zParam;
    private Canonicalization headerCanonicalization = Canonicalization.RELAXED;
    private Canonicalization bodyCanonicalization = Canonicalization.SIMPLE;
    private boolean checkDomainKey = true;
    private RSAPrivateKey privateKey;

    public DkimSigner(String signingDomain, String selector, RSAPrivateKey privateKey) throws DkimException {
        this.initDkimSigner(signingDomain, selector, privateKey);
    }

    public DkimSigner(String signingDomain, String selector, File derFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, DkimException {
        this(signingDomain, selector, new FileInputStream(derFile));
    }

    public DkimSigner(String signingDomain, String selector, InputStream derStream) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privKeyBytes = new BufferedFetcher().fetch(derStream);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privKeyBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        this.initDkimSigner(signingDomain, selector, privKey);
    }

    private void initDkimSigner(String signingDomain, String selector, RSAPrivateKey privkey) throws DkimException {
        if (!DkimSigner.isValidDomain(signingDomain)) {
            throw new DkimException(signingDomain + " is an invalid signing domain");
        }
        this.signingDomain = signingDomain;
        this.selector = selector.trim();
        this.privateKey = privkey;
        this.setSigningAlgorithm(this.signingAlgorithm);
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) throws DkimException {
        if (null != identity && !(identity = identity.trim()).endsWith("@" + this.signingDomain) && !identity.endsWith("." + this.signingDomain)) {
            throw new DkimException("The domain part of " + identity + " has to be " + this.signingDomain + " or a subdomain thereof");
        }
        this.identity = identity;
    }

    public Canonicalization getBodyCanonicalization() {
        return this.bodyCanonicalization;
    }

    public void setBodyCanonicalization(Canonicalization canonicalization) {
        this.bodyCanonicalization = canonicalization;
    }

    public Canonicalization getHeaderCanonicalization() {
        return this.headerCanonicalization;
    }

    public void setHeaderCanonicalization(Canonicalization canonicalization) {
        this.headerCanonicalization = canonicalization;
    }

    public void addHeaderToSign(String header) {
        if (null != header && 0 != header.length()) {
            this.headersToSign.add(header);
        }
    }

    public void removeHeaderToSign(String header) {
        if (null != header && 0 != header.length() && !MIMIMUM_HEADERS_TO_SIGN.contains(header)) {
            this.headersToSign.remove(header);
        }
    }

    public boolean getLengthParam() {
        return this.lengthParam;
    }

    public void setLengthParam(boolean lengthParam) {
        this.lengthParam = lengthParam;
    }

    public boolean isZParam() {
        return this.zParam;
    }

    public void setZParam(boolean zParam) {
        this.zParam = zParam;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(SigningAlgorithm signingAlgorithm) throws DkimException {
        try {
            this.messageDigest = MessageDigest.getInstance(signingAlgorithm.getHashNotation());
        }
        catch (NoSuchAlgorithmException e) {
            throw new DkimException("The hashing algorithm " + signingAlgorithm.getHashNotation() + " is not known by the JVM", e);
        }
        try {
            this.signature = Signature.getInstance(signingAlgorithm.getJavaNotation());
        }
        catch (NoSuchAlgorithmException e) {
            throw new DkimException("The signing algorithm " + signingAlgorithm.getJavaNotation() + " is not known by the JVM", e);
        }
        try {
            this.signature.initSign(this.privateKey);
        }
        catch (InvalidKeyException e) {
            throw new DkimException("The provided private key is invalid", e);
        }
        this.signingAlgorithm = signingAlgorithm;
    }

    public boolean isCheckDomainKey() {
        return this.checkDomainKey;
    }

    public void setCheckDomainKey(boolean checkDomainKey) {
        this.checkDomainKey = checkDomainKey;
    }

    protected String sign(DkimMessage message) throws DkimAcceptanceException, DkimSigningException {
        byte[] signedSignature;
        if (this.checkDomainKey) {
            try {
                DomainKeyUtil.getDomainKey(this.signingDomain, this.selector).check(this.identity, this.privateKey);
            }
            catch (DkimException e) {
                throw new DkimSigningException("Obtaining the domain key for " + this.signingDomain + "." + this.selector + " failed", e);
            }
        }
        LinkedHashMap<String, String> dkimSignature = new LinkedHashMap<String, String>();
        dkimSignature.put("v", "1");
        dkimSignature.put("a", this.signingAlgorithm.getRfc4871Notation());
        dkimSignature.put("q", "dns/txt");
        dkimSignature.put("c", this.getHeaderCanonicalization().getType() + "/" + this.getBodyCanonicalization().getType());
        dkimSignature.put("t", new Date().getTime() / 1000L + "");
        dkimSignature.put("s", this.selector);
        dkimSignature.put("d", this.signingDomain);
        if (this.identity != null) {
            dkimSignature.put("i", DkimSigner.quotedPrintable(this.identity));
        }
        ArrayList<String> assureHeaders = new ArrayList<String>(MIMIMUM_HEADERS_TO_SIGN);
        StringBuffer headerList = new StringBuffer();
        StringBuffer headerContent = new StringBuffer();
        StringBuffer zParamString = new StringBuffer();
        try {
            Enumeration headerLines = message.getAllHeaders();
            while (headerLines.hasMoreElements()) {
                Header header = (Header)headerLines.nextElement();
                String headerName = header.getName();
                if (!this.headersToSign.contains(headerName)) continue;
                String headerValue = header.getValue();
                headerList.append(headerName).append(":");
                headerContent.append(this.headerCanonicalization.canonicalizeHeader(headerName, headerValue));
                headerContent.append("\r\n");
                assureHeaders.remove(headerName);
                if (!this.zParam) continue;
                zParamString.append(headerName);
                zParamString.append(":");
                zParamString.append(DkimSigner.quotedPrintable(headerValue.trim()).replace("|", "=7C"));
                zParamString.append("|");
            }
            if (!assureHeaders.isEmpty()) {
                throw new DkimSigningException("Could not find the header fields " + DkimSigner.concatList(assureHeaders, ", ") + " for signing");
            }
        }
        catch (MessagingException e) {
            throw new DkimSigningException("Could not find the header fields " + DkimSigner.concatList(assureHeaders, ", ") + " for signing", (Exception)((Object)e));
        }
        dkimSignature.put("h", headerList.substring(0, headerList.length() - 1));
        if (this.zParam) {
            String zParamTemp = zParamString.toString();
            dkimSignature.put("z", zParamTemp.substring(0, zParamTemp.length() - 1));
        }
        String body = message.getEncodedBody();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfos = new CRLFOutputStream((OutputStream)baos);
        try {
            crlfos.write(body.getBytes());
            crlfos.close();
        }
        catch (IOException e) {
            throw new DkimSigningException("The body conversion to MIME canonical CRLF line terminator failed", e);
        }
        body = baos.toString();
        body = this.bodyCanonicalization.canonicalizeBody(body);
        if (this.lengthParam) {
            dkimSignature.put("l", Integer.toString(body.length()));
        }
        dkimSignature.put("bh", DkimSigner.base64Encode(this.messageDigest.digest(body.getBytes())));
        String serializedSignature = this.serializeDkimSignature(dkimSignature);
        try {
            headerContent.append(this.headerCanonicalization.canonicalizeHeader(DKIM_SIGNATUR_HEADER, serializedSignature));
            this.signature.update(headerContent.toString().getBytes());
            signedSignature = this.signature.sign();
        }
        catch (SignatureException se) {
            throw new DkimSigningException("The signing operation by Java security failed", se);
        }
        return "DKIM-Signature: " + serializedSignature + this.foldSignedSignature(DkimSigner.base64Encode(signedSignature), 3);
    }

    private String serializeDkimSignature(Map<String, String> dkimSignature) {
        Set<Map.Entry<String, String>> entries = dkimSignature.entrySet();
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        for (Map.Entry<String, String> entry : entries) {
            StringBuffer fbuf = new StringBuffer();
            fbuf.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            if (pos + fbuf.length() + 1 > 67) {
                pos = fbuf.length();
                buf.append("\r\n\t").append(fbuf);
                continue;
            }
            buf.append(" ").append(fbuf);
            pos += fbuf.length() + 1;
        }
        buf.append("\r\n\tb=");
        return buf.toString().trim();
    }

    private String foldSignedSignature(String s, int offset) {
        int i = 0;
        StringBuffer buf = new StringBuffer();
        while (true) {
            if (offset > 0 && s.substring(i).length() > 67 - offset) {
                buf.append(s.substring(i, i + 67 - offset));
                i += 67 - offset;
                offset = 0;
                continue;
            }
            if (s.substring(i).length() <= 67) break;
            buf.append("\r\n\t").append(s.substring(i, i + 67));
            i += 67;
        }
        buf.append("\r\n\t").append(s.substring(i));
        return buf.toString();
    }

    private static String concatList(List<String> assureHeaders, String separator) {
        StringBuffer buffer = new StringBuffer();
        for (String string : assureHeaders) {
            buffer.append(string);
            buffer.append(separator);
        }
        return buffer.substring(0, buffer.length() - separator.length());
    }

    private static boolean isValidDomain(String domainname) {
        Pattern pattern = Pattern.compile("(.+)\\.(.+)");
        Matcher matcher = pattern.matcher(domainname);
        return matcher.matches();
    }

    private static String quotedPrintable(String s) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            QPEncoderStream encodeStream = new QPEncoderStream((OutputStream)out);
            encodeStream.write(s.getBytes());
            encodeStream.close();
            String encoded = out.toString();
            encoded = encoded.replaceAll(";", "=3B");
            encoded = encoded.replaceAll(" ", "=20");
            return encoded;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String base64Encode(byte[] bytes) {
        String encoded = Base64.encodeBytes((byte[])bytes);
        encoded = encoded.replace("\n", "");
        encoded = encoded.replace("\r", "");
        return encoded;
    }

    static {
        MIMIMUM_HEADERS_TO_SIGN.add("From");
        MIMIMUM_HEADERS_TO_SIGN.add("To");
        MIMIMUM_HEADERS_TO_SIGN.add("Subject");
        DEFAULT_HEADERS_TO_SIGN.addAll(MIMIMUM_HEADERS_TO_SIGN);
        DEFAULT_HEADERS_TO_SIGN.add("Content-Description");
        DEFAULT_HEADERS_TO_SIGN.add("Content-ID");
        DEFAULT_HEADERS_TO_SIGN.add("Content-Type");
        DEFAULT_HEADERS_TO_SIGN.add("Content-Transfer-Encoding");
        DEFAULT_HEADERS_TO_SIGN.add("Cc");
        DEFAULT_HEADERS_TO_SIGN.add("Date");
        DEFAULT_HEADERS_TO_SIGN.add("In-Reply-To");
        DEFAULT_HEADERS_TO_SIGN.add("List-Subscribe");
        DEFAULT_HEADERS_TO_SIGN.add("List-Post");
        DEFAULT_HEADERS_TO_SIGN.add("List-Owner");
        DEFAULT_HEADERS_TO_SIGN.add("List-Id");
        DEFAULT_HEADERS_TO_SIGN.add("List-Archive");
        DEFAULT_HEADERS_TO_SIGN.add("List-Help");
        DEFAULT_HEADERS_TO_SIGN.add("List-Unsubscribe");
        DEFAULT_HEADERS_TO_SIGN.add("MIME-Version");
        DEFAULT_HEADERS_TO_SIGN.add("Message-ID");
        DEFAULT_HEADERS_TO_SIGN.add("Resent-Sender");
        DEFAULT_HEADERS_TO_SIGN.add("Resent-Cc");
        DEFAULT_HEADERS_TO_SIGN.add("Resent-Date");
        DEFAULT_HEADERS_TO_SIGN.add("Resent-To");
        DEFAULT_HEADERS_TO_SIGN.add("Reply-To");
        DEFAULT_HEADERS_TO_SIGN.add("References");
        DEFAULT_HEADERS_TO_SIGN.add("Resent-Message-ID");
        DEFAULT_HEADERS_TO_SIGN.add("Resent-From");
        DEFAULT_HEADERS_TO_SIGN.add("Sender");
    }
}

