/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.rule;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codenarc.rule.AbstractRule;
import org.codenarc.rule.AstVisitor;
import org.codenarc.rule.Violation;
import org.codenarc.source.SourceCode;
import org.codenarc.util.WildcardPattern;

public abstract class AbstractAstVisitorRule
extends AbstractRule {
    protected static final String DEFAULT_CONST_NAME = "[A-Z][A-Z0-9_]*";
    protected static final String DEFAULT_FIELD_NAME = "[a-z][a-zA-Z0-9]*";
    protected static final String DEFAULT_VAR_NAME = "[a-z][a-zA-Z0-9]*";
    protected static final String DEFAULT_TEST_FILES = ".*(Spec|Test|Tests|TestCase)\\.groovy";
    protected static final String DEFAULT_TEST_CLASS_NAMES = "*Spec,*Test,*Tests,*TestCase";
    public static final String CLOSURE_TEXT = "{ -> ... }";
    private String applyToClassNames;
    private String doNotApplyToClassNames;

    protected Class getAstVisitorClass() {
        return null;
    }

    public AstVisitor getAstVisitor() {
        Class visitorClass = this.getAstVisitorClass();
        if (visitorClass == null) {
            throw new IllegalArgumentException("The astVisitorClass property must not be null");
        }
        if (!AstVisitor.class.isAssignableFrom(visitorClass)) {
            throw new IllegalArgumentException("The astVisitorClass property must specify a class that implements AstVisitor");
        }
        try {
            return (AstVisitor)visitorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyTo(SourceCode sourceCode, List<Violation> violations) {
        ModuleNode ast = sourceCode.getAst();
        if (ast != null && ast.getClasses() != null) {
            for (ClassNode classNode : ast.getClasses()) {
                if (!this.shouldApplyThisRuleTo(classNode)) continue;
                AstVisitor visitor = this.getAstVisitor();
                visitor.setRule(this);
                visitor.setSourceCode(sourceCode);
                visitor.visitClass(classNode);
                violations.addAll(visitor.getViolations());
            }
        }
        Collections.sort(violations, new Comparator<Violation>(){

            @Override
            public int compare(Violation o1, Violation o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getLineNumber() == null && o2.getLineNumber() == null) {
                    return 0;
                }
                if (o1.getLineNumber() == null) {
                    return -1;
                }
                if (o2.getLineNumber() == null) {
                    return 1;
                }
                return o1.getLineNumber().compareTo(o2.getLineNumber());
            }
        });
    }

    protected boolean shouldApplyThisRuleTo(ClassNode classNode) {
        WildcardPattern pattern;
        boolean shouldApply = true;
        String applyTo = this.getApplyToClassNames();
        String doNotApplyTo = this.getDoNotApplyToClassNames();
        if (applyTo != null && applyTo.length() > 0) {
            pattern = new WildcardPattern(applyTo, true);
            boolean bl = shouldApply = pattern.matches(classNode.getNameWithoutPackage()) || pattern.matches(classNode.getName());
        }
        if (shouldApply && doNotApplyTo != null && doNotApplyTo.length() > 0) {
            pattern = new WildcardPattern(doNotApplyTo, true);
            shouldApply = !pattern.matches(classNode.getNameWithoutPackage()) && !pattern.matches(classNode.getName());
        }
        return shouldApply;
    }

    public String getApplyToClassNames() {
        return this.applyToClassNames;
    }

    public void setApplyToClassNames(String applyToClassNames) {
        this.applyToClassNames = applyToClassNames;
    }

    public String getDoNotApplyToClassNames() {
        return this.doNotApplyToClassNames;
    }

    public void setDoNotApplyToClassNames(String doNotApplyToClassNames) {
        this.doNotApplyToClassNames = doNotApplyToClassNames;
    }
}

