/*
 * Decompiled with CFR 0.152.
 */
package org.coderclan.edelweiss;

import javax.sql.DataSource;
import org.coderclan.edelweiss.IdGenerator;
import org.coderclan.edelweiss.InstanceIdAssigner;
import org.coderclan.edelweiss.JbdcInstanceIdAssigner;
import org.coderclan.edelweiss.SnowFlakeIdGenerator;
import org.coderclan.edelweiss.SnowFlakeInstanceIdRenewer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class EdelweissConfiguration {
    @Value(value="${coderclan.edelweiss.machineIdTtl:600}")
    private int machineIdTtl;

    @Bean
    @ConditionalOnMissingBean(value={IdGenerator.class})
    public SnowFlakeIdGenerator idGenerator() {
        return SnowFlakeIdGenerator.instance();
    }

    @Bean
    @ConditionalOnMissingBean(value={InstanceIdAssigner.class})
    @ConditionalOnBean(value={DataSource.class})
    public JbdcInstanceIdAssigner instanceIdAssigner(DataSource dataSource) {
        return new JbdcInstanceIdAssigner(dataSource);
    }

    @Bean
    @ConditionalOnBean(value={SnowFlakeIdGenerator.class, InstanceIdAssigner.class})
    public SnowFlakeInstanceIdRenewer snowFlakeInstanceIdRenewer(SnowFlakeIdGenerator idGenerator, InstanceIdAssigner instanceIdAssigner) {
        return new SnowFlakeInstanceIdRenewer(idGenerator, instanceIdAssigner, this.machineIdTtl);
    }
}

