/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.codingmatters.value.objects.FormattedWriter;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.TypeKind;
import org.codingmatters.value.objects.spec.ValueSpec;

public class PackageGenerator {
    public static final String VALUE_OBJECT_STEREOTYPE = "<< (V,#0099ff) >>";
    public static final String EXT_VALUE_OBJECT_STEREOTYPE = "<< (V,#0099ff) EXT>>";
    private final List<ValueSpec> valueSpecs;
    private final String packageName;
    private final String prefix;

    public PackageGenerator(List<ValueSpec> valueSpecs, String packageName) {
        this(valueSpecs, packageName, "");
    }

    public PackageGenerator(List<ValueSpec> valueSpecs, String packageName, String prefix) {
        this.valueSpecs = valueSpecs;
        this.packageName = packageName;
        this.prefix = prefix;
    }

    public void generate(FormattedWriter out) throws IOException {
        this.interfaceDeclaration(this.valueSpecs, out);
        TreeSet<String> externalValueObjects = new TreeSet<String>();
        for (ValueSpec valueSpec : this.valueSpecs) {
            externalValueObjects.addAll(this.externalValueObjects(valueSpec));
            this.valueClass(valueSpec, out);
            List<ValueSpec> embeddedValues = this.embeddedValues(valueSpec);
            if (embeddedValues.isEmpty()) continue;
            new PackageGenerator(embeddedValues, this.packageName + "." + valueSpec.name(), this.prefix).generate(out);
        }
        this.externalValueObjectClasses(externalValueObjects, out);
    }

    public void generate(ValueSpec valueSpec, FormattedWriter out) throws IOException {
        this.interfaceDeclaration(Arrays.asList(valueSpec), out);
        TreeSet<String> externalValueObjects = new TreeSet<String>();
        externalValueObjects.addAll(this.externalValueObjects(valueSpec));
        this.valueClass(valueSpec, out);
        List<ValueSpec> embeddedValues = this.embeddedValues(valueSpec);
        if (!embeddedValues.isEmpty()) {
            new PackageGenerator(embeddedValues, this.packageName + "." + valueSpec.name(), this.prefix).generate(out);
        }
        this.externalValueObjectClasses(externalValueObjects, out);
    }

    private List<String> externalValueObjects(ValueSpec valueSpec) {
        LinkedList<String> result = new LinkedList<String>();
        for (PropertySpec propertySpec : valueSpec.propertySpecs()) {
            if (!propertySpec.typeSpec().typeKind().equals((Object)TypeKind.EXTERNAL_VALUE_OBJECT)) continue;
            result.add(propertySpec.typeSpec().typeRef());
        }
        return result;
    }

    private void externalValueObjectClasses(Set<String> externalValueObjects, FormattedWriter out) throws IOException {
        for (String externalValueObject : externalValueObjects) {
            out.appendLine(this.prefix + "  class \"%s\" %s {", externalValueObject, EXT_VALUE_OBJECT_STEREOTYPE);
            out.appendLine(this.prefix + "  }", new Object[0]);
        }
    }

    private void interfaceDeclaration(List<ValueSpec> valueSpecs, FormattedWriter out) throws IOException {
        LinkedHashSet protocols = new LinkedHashSet();
        for (ValueSpec valueSpec : valueSpecs) {
            protocols.addAll(valueSpec.protocols());
        }
        if (!protocols.isEmpty()) {
            out.appendLine(this.prefix, new Object[0]);
            for (String protocol : protocols) {
                out.appendLine(this.prefix + "interface \"%s\"", protocol);
            }
        }
    }

    private void valueClass(ValueSpec valueSpec, FormattedWriter out) throws IOException {
        String className = this.capitalizedFirst(valueSpec.name());
        out.appendLine(this.prefix + "  ", new Object[0]);
        out.appendLine(this.prefix + "  class \"%s.%s\" %s {", this.packageName, className, VALUE_OBJECT_STEREOTYPE);
        for (PropertySpec propertySpec : valueSpec.propertySpecs()) {
            switch (propertySpec.typeSpec().typeKind()) {
                case JAVA_TYPE: {
                    this.javaProperty(valueSpec, propertySpec, out);
                    break;
                }
            }
        }
        out.appendLine(this.prefix + "  }", new Object[0]);
        for (String implementedInterface : valueSpec.protocols()) {
            out.appendLine(this.prefix + "  \"%s.%s\" <|- \"%s\"", this.packageName, className, implementedInterface);
        }
        for (PropertySpec propertySpec : valueSpec.propertySpecs()) {
            if (propertySpec.typeSpec().typeKind().isValueObject() || propertySpec.typeSpec().typeKind().equals((Object)TypeKind.EMBEDDED)) {
                this.aggregateProperty(valueSpec, propertySpec, out);
                continue;
            }
            if (!propertySpec.typeSpec().typeKind().equals((Object)TypeKind.ENUM)) continue;
            this.enumClass(valueSpec, propertySpec, out);
            this.aggregateProperty(valueSpec, propertySpec, out);
        }
    }

    private void enumClass(ValueSpec valueSpec, PropertySpec propertySpec, FormattedWriter out) throws IOException {
        out.appendLine(this.prefix + "  ", new Object[0]);
        out.appendLine(this.prefix + "  enum \"%s.%s.%s\" {", this.packageName, this.capitalizedFirst(valueSpec.name()), this.capitalizedFirst(propertySpec.name()));
        for (String enumVal : propertySpec.typeSpec().enumValues()) {
            out.appendLine(this.prefix + "    %s", enumVal);
        }
        out.appendLine(this.prefix + "  }", new Object[0]);
    }

    private void aggregateProperty(ValueSpec valueSpec, PropertySpec propertySpec, FormattedWriter out) throws IOException {
        String fieldFormat = null;
        switch (propertySpec.typeSpec().cardinality()) {
            case SINGLE: {
                fieldFormat = this.prefix + "  \"%s\" *-- \"%s\" : %s";
                break;
            }
            case LIST: {
                fieldFormat = this.prefix + "  \"%s\" *-- \"*\" \"%s\" : %s";
                break;
            }
            case SET: {
                fieldFormat = this.prefix + "  \"%s\" *-- \"*\" \"%s\" : %s\\n[Set]";
            }
        }
        if (propertySpec.typeSpec().isInSpecEnum()) {
            out.appendLine(fieldFormat, this.packageName + "." + this.capitalizedFirst(valueSpec.name()), this.packageName + "." + this.capitalizedFirst(valueSpec.name()) + "." + this.capitalizedFirst(propertySpec.name()), propertySpec.name());
        } else if (propertySpec.typeSpec().typeKind().equals((Object)TypeKind.EMBEDDED)) {
            out.appendLine(fieldFormat, this.packageName + "." + this.capitalizedFirst(valueSpec.name()), this.packageName + "." + valueSpec.name() + "." + this.capitalizedFirst(propertySpec.name()), propertySpec.name());
        } else if (propertySpec.typeSpec().typeKind().equals((Object)TypeKind.IN_SPEC_VALUE_OBJECT)) {
            out.appendLine(fieldFormat, this.packageName + "." + this.capitalizedFirst(valueSpec.name()), this.packageName + "." + this.capitalizedFirst(propertySpec.typeSpec().typeRef()), propertySpec.name());
        } else {
            out.appendLine(fieldFormat, this.packageName + "." + this.capitalizedFirst(valueSpec.name()), propertySpec.typeSpec().typeRef(), propertySpec.name());
        }
    }

    private List<ValueSpec> embeddedValues(ValueSpec valueSpec) {
        LinkedList<ValueSpec> result = new LinkedList<ValueSpec>();
        for (PropertySpec propertySpec : valueSpec.propertySpecs()) {
            if (!propertySpec.typeSpec().typeKind().equals((Object)TypeKind.EMBEDDED)) continue;
            ValueSpec.Builder builder = ValueSpec.valueSpec().name(propertySpec.name());
            for (PropertySpec spec : propertySpec.typeSpec().embeddedValueSpec().propertySpecs()) {
                builder.addProperty(spec);
            }
            result.add(builder.build());
        }
        return result;
    }

    private void javaProperty(ValueSpec valueSpec, PropertySpec propertySpec, FormattedWriter out) throws IOException {
        String fieldFormat = null;
        switch (propertySpec.typeSpec().cardinality()) {
            case SINGLE: {
                fieldFormat = this.prefix + "    {field} %s : %s";
                break;
            }
            case LIST: {
                fieldFormat = this.prefix + "    {field} %s : ValueList<%s>";
                break;
            }
            case SET: {
                fieldFormat = this.prefix + "    {field} %s : ValueSet<%s>";
            }
        }
        out.appendLine(fieldFormat, propertySpec.name(), propertySpec.typeSpec().typeRef());
    }

    private String capitalizedFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

