/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.codingmatters.value.objects.generation.ValueConfiguration;
import org.codingmatters.value.objects.json.property.JsonPropertyHelper;
import org.codingmatters.value.objects.json.property.SimplePropertyReaderProducer;
import org.codingmatters.value.objects.json.property.SimplePropertyReaders;
import org.codingmatters.value.objects.json.property.statement.EnumPropertyStatement;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.TypeKind;

public class ValueReader {
    private final ValueConfiguration types;
    private final List<PropertySpec> propertySpecs;

    public ValueReader(ValueConfiguration types, List<PropertySpec> propertySpecs) {
        this.types = types;
        this.propertySpecs = propertySpecs;
    }

    public TypeSpec type() {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)(this.types.valueType().simpleName() + "Reader")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.readWithParserMethod()).addMethod(this.readArrayWithParserMethod()).addType(this.readerFunctionalInterface()).addMethod(this.readValueMethod()).addMethod(this.readListValueMethod()).addMethod(this.consumeUnexpectedProperty()).addType(this.tokensEnum());
        for (PropertySpec propertySpec : this.propertySpecs) {
            if (!JsonPropertyHelper.isTransient(propertySpec)) {
                SimplePropertyReaderProducer propertyReaderProducer = this.propertyReaderProducer(propertySpec);
                if (propertyReaderProducer == null) continue;
                this.addPropertyReaderStatements(result, propertySpec, propertyReaderProducer);
                continue;
            }
            System.out.println("skipping transient field " + propertySpec.name());
        }
        return result.build();
    }

    private TypeSpec tokensEnum() {
        TypeSpec.Builder result = TypeSpec.enumBuilder((String)"Token");
        result.addField(FieldSpec.builder(String.class, (String)"name", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addField(FieldSpec.builder(String.class, (String)"rawName", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addParameter(String.class, "name", new Modifier[0]).addParameter(String.class, "rawName", new Modifier[0]).addStatement("this.name = name", new Object[0]).addStatement("this.rawName = rawName", new Object[0]).build()).addEnumConstant("__UNKNOWN__", TypeSpec.anonymousClassBuilder((String)"$S, $S", (Object[])new Object[]{"__UNKNOWN__", "__UNKNOWN__"}).build());
        result.addMethod(this.enumNormalizeFieldName());
        for (PropertySpec propertySpec : this.propertySpecs) {
            result.addEnumConstant(this.enumConstant(propertySpec), TypeSpec.anonymousClassBuilder((String)"$S, $S", (Object[])new Object[]{propertySpec.name(), this.rawName(propertySpec)}).build());
        }
        result.addMethod(MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addParameter(String.class, "str", new Modifier[0]).returns((TypeName)ClassName.bestGuess((String)"Token")).beginControlFlow("for(Token token : Token.values())", new Object[0]).beginControlFlow("if(token.name.equals(str))", new Object[0]).addStatement("return token", new Object[0]).nextControlFlow("else if(token.rawName.equals(str))", new Object[0]).addStatement("return token", new Object[0]).nextControlFlow("else if(token.name.equals(normalizeFieldName(str)))", new Object[0]).addStatement("return token", new Object[0]).nextControlFlow("else if(token.rawName.equals(normalizeFieldName(str)))", new Object[0]).addStatement("return token", new Object[0]).endControlFlow().endControlFlow().addStatement("return __UNKNOWN__", new Object[0]).build());
        return result.build();
    }

    private String rawName(PropertySpec propertySpec) {
        Optional hint = propertySpec.matchingHint("property:raw\\(([^)]*)\\)");
        if (hint.isPresent()) {
            return ((Matcher)hint.get()).group(1);
        }
        return propertySpec.name();
    }

    private String enumConstant(PropertySpec propertySpec) {
        return propertySpec.name().toUpperCase();
    }

    private MethodSpec enumNormalizeFieldName() {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"normalizeFieldName").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PRIVATE}).addParameter(String.class, "fieldName", new Modifier[0]).returns(String.class);
        result.addStatement("if(fieldName == null) return null", new Object[0]);
        result.addStatement("if(fieldName.trim().equals(\"\")) return \"\"", new Object[0]);
        result.addStatement("fieldName = $T.stream(fieldName.split($S)).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect($T.joining())", new Object[]{Arrays.class, "(\\s|-)+", Collectors.class});
        result.addStatement("fieldName =  fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1)", new Object[0]);
        result.addStatement("return fieldName", new Object[0]);
        return result.build();
    }

    private MethodSpec consumeUnexpectedProperty() {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"consumeUnexpectedProperty").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ClassName.get(JsonParser.class), "parser", new Modifier[0]).returns(TypeName.VOID).addException((TypeName)ClassName.get(IOException.class));
        result.addStatement("parser.nextToken()", new Object[0]);
        result.beginControlFlow("if(parser.currentToken().isStructStart())", new Object[0]).addStatement("int level = 1", new Object[0]).beginControlFlow("do", new Object[0]).addStatement("parser.nextToken()", new Object[0]).beginControlFlow("if (parser.currentToken().isStructStart())", new Object[0]).addStatement("level++", new Object[0]).nextControlFlow("if (parser.currentToken().isStructEnd())", new Object[0]).addStatement("level--", new Object[0]).endControlFlow().endControlFlow("while(level > 0)", new Object[0]).endControlFlow();
        return result.build();
    }

    private SimplePropertyReaderProducer propertyReaderProducer(PropertySpec propertySpec) {
        SimplePropertyReaderProducer propertyReaderProducer = null;
        if (propertySpec.typeSpec().typeKind() == TypeKind.JAVA_TYPE) {
            propertyReaderProducer = SimplePropertyReaders.forClassName(propertySpec.typeSpec().typeRef()).producer();
        } else if (propertySpec.typeSpec().typeKind() == TypeKind.ENUM) {
            propertyReaderProducer = new SimplePropertyReaderProducer(new HashSet<JsonToken>(Arrays.asList(JsonToken.VALUE_STRING)), "getText", new EnumPropertyStatement(this.types));
        }
        return propertyReaderProducer;
    }

    private void addPropertyReaderStatements(TypeSpec.Builder result, PropertySpec propertySpec, SimplePropertyReaderProducer propertyReader) {
        if (propertyReader != null && !propertySpec.typeSpec().cardinality().isCollection()) {
            String initializerFormat = "";
            LinkedList<Object> initializerArgs = new LinkedList<Object>();
            initializerFormat = initializerFormat + "new $T($T.asList(";
            initializerArgs.add(HashSet.class);
            initializerArgs.add(Arrays.class);
            boolean first = true;
            for (JsonToken jsonToken : propertyReader.expectedTokens()) {
                if (!first) {
                    initializerFormat = initializerFormat + ", ";
                }
                first = false;
                initializerFormat = initializerFormat + "$T.$L";
                initializerArgs.add(JsonToken.class);
                initializerArgs.add(jsonToken.name());
            }
            initializerFormat = initializerFormat + "))";
            result.addField(FieldSpec.builder((TypeName)ClassName.get(Set.class), (String)this.expectedTokenField(propertySpec), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer(initializerFormat, initializerArgs.toArray()).build());
        }
    }

    private String expectedTokenField(PropertySpec propertySpec) {
        return propertySpec.name().toUpperCase() + "_EXPECTEDTOKENS";
    }

    private MethodSpec readArrayWithParserMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"readArray").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JsonParser.class, "parser", new Modifier[0]).returns((TypeName)ArrayTypeName.of((TypeName)this.types.valueType())).addException(IOException.class);
        method.addStatement("parser.nextToken()", new Object[0]).addStatement("if (parser.currentToken() == JsonToken.VALUE_NULL) return null", new Object[0]).beginControlFlow("if (parser.currentToken() == JsonToken.START_ARRAY)", new Object[0]).addStatement("LinkedList<$T> listValue = new LinkedList<>()", new Object[]{this.types.valueType()}).beginControlFlow("while (parser.nextToken() != JsonToken.END_ARRAY)", new Object[0]).beginControlFlow("if(parser.currentToken() == JsonToken.VALUE_NULL)", new Object[0]).addStatement("listValue.add(null)", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("listValue.add(this.read(parser))", new Object[0]).endControlFlow().endControlFlow().addStatement("return listValue.toArray(new $T[listValue.size()])", new Object[]{this.types.valueType()}).endControlFlow().addStatement("throw new IOException(String.format($S, parser.currentToken()))", new Object[]{"failed reading " + this.types.valueType() + " array, current token was %s"});
        return method.build();
    }

    private MethodSpec readWithParserMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JsonParser.class, "parser", new Modifier[0]).returns((TypeName)this.types.valueType()).addException(IOException.class);
        method.beginControlFlow("if(parser.getCurrentToken() == null)", new Object[0]).addStatement("parser.nextToken()", new Object[0]).endControlFlow();
        method.addStatement("if(parser.currentToken() == $T.VALUE_NULL) return null", new Object[]{JsonToken.class});
        method.beginControlFlow("if(parser.currentToken() != $T.START_OBJECT)", new Object[]{JsonToken.class}).addStatement("throw new IOException(\n        String.format(\"reading a %s object, was expecting %s, but was %s\",\n                $T.class.getName(), $T.START_OBJECT, parser.currentToken()\n        )\n)", new Object[]{this.types.valueType(), JsonToken.class}).endControlFlow();
        method.addStatement("$T builder = $T.builder()", new Object[]{this.types.valueBuilderType(), this.types.valueType()});
        method.beginControlFlow("while (parser.nextToken() != $T.END_OBJECT)", new Object[]{JsonToken.class}).addStatement("Token token = Token.from(parser.getCurrentName())", new Object[0]).beginControlFlow("if(token != null)", new Object[0]).beginControlFlow("switch (token)", new Object[0]);
        for (PropertySpec propertySpec : this.propertySpecs) {
            if (JsonPropertyHelper.isTransient(propertySpec)) continue;
            this.propertyStatements(method, propertySpec);
        }
        method.beginControlFlow("default:", new Object[0]).addStatement("this.consumeUnexpectedProperty(parser)", new Object[0]).endControlFlow();
        method.endControlFlow().nextControlFlow("else", new Object[0]).addStatement("this.consumeUnexpectedProperty(parser)", new Object[0]).endControlFlow().endControlFlow();
        method.addStatement("return builder.build()", new Object[0]);
        return method.build();
    }

    private void propertyStatements(MethodSpec.Builder method, PropertySpec propertySpec) {
        if (propertySpec.typeSpec().typeKind() == TypeKind.JAVA_TYPE || propertySpec.typeSpec().typeKind() == TypeKind.ENUM) {
            SimplePropertyReaderProducer propertyReaderProducer = this.propertyReaderProducer(propertySpec);
            if (propertyReaderProducer != null) {
                if (!propertySpec.typeSpec().cardinality().isCollection()) {
                    this.singleSimplePropertyStatement(method, propertySpec, propertyReaderProducer);
                } else {
                    this.multipleSimplePropertyStatement(method, propertySpec, propertyReaderProducer);
                }
            } else {
                System.err.println("NYIMPL type ref for simple property: " + propertySpec.typeSpec().typeRef());
            }
        } else if (propertySpec.typeSpec().typeKind().isValueObject()) {
            if (!propertySpec.typeSpec().cardinality().isCollection()) {
                this.singleComplexPropertyStatement(method, propertySpec);
            } else {
                ClassName propertyClass = this.types.valueObjectSingleType(propertySpec);
                ClassName propertyReader = ClassName.get((String)(propertyClass.packageName() + ".json"), (String)(propertyClass.simpleName() + "Reader"), (String[])new String[0]);
                method.beginControlFlow("case $L:", new Object[]{this.enumConstant(propertySpec)}).addStatement("$T reader = new $T()", new Object[]{propertyReader, propertyReader}).addStatement("builder.$L(this.readListValue(parser, jsonParser -> reader.read(jsonParser), $S))", new Object[]{propertySpec.name(), propertySpec.name()}).addStatement("break", new Object[0]).endControlFlow();
            }
        }
    }

    private void singleComplexPropertyStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
        ClassName propertyClass = this.types.valueObjectSingleType(propertySpec);
        ClassName propertyReader = ClassName.get((String)(propertyClass.packageName() + ".json"), (String)(propertyClass.simpleName() + "Reader"), (String[])new String[0]);
        if (!propertySpec.typeSpec().cardinality().isCollection()) {
            method.beginControlFlow("case $L:", new Object[]{this.enumConstant(propertySpec)}).addStatement("parser.nextToken()", new Object[0]).addStatement("builder.$L(new $T().read(parser))", new Object[]{propertySpec.name(), propertyReader}).addStatement("break", new Object[0]).endControlFlow();
        }
    }

    private void singleSimplePropertyStatement(MethodSpec.Builder method, PropertySpec propertySpec, SimplePropertyReaderProducer propertyReaderProducer) {
        method.beginControlFlow("case $L:", new Object[]{this.enumConstant(propertySpec)}).addStatement("$T<$T> expectedTokens = $L", new Object[]{Set.class, JsonToken.class, this.expectedTokenField(propertySpec)});
        propertyReaderProducer.addSingleStatement(method, propertySpec);
        method.addStatement("break", new Object[0]).endControlFlow();
    }

    private void multipleSimplePropertyStatement(MethodSpec.Builder method, PropertySpec propertySpec, SimplePropertyReaderProducer propertyReaderProducer) {
        method.beginControlFlow("case $L:", new Object[]{this.enumConstant(propertySpec)});
        propertyReaderProducer.addMultipleStatement(method, propertySpec);
        method.addStatement("break", new Object[0]).endControlFlow();
    }

    private TypeSpec readerFunctionalInterface() {
        return TypeSpec.interfaceBuilder((String)"Reader").addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(FunctionalInterface.class).addTypeVariable(TypeVariableName.get((String)"T")).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(JsonParser.class, "parser", new Modifier[0]).addException(IOException.class).returns((TypeName)TypeVariableName.get((String)"T")).build()).build();
    }

    private MethodSpec readValueMethod() {
        return MethodSpec.methodBuilder((String)"readValue").addModifiers(new Modifier[]{Modifier.PRIVATE}).addTypeVariable(TypeVariableName.get((String)"T")).addParameter(JsonParser.class, "parser", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)"Reader"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "reader", new Modifier[0]).addParameter(String.class, "propertyName", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{ClassName.get(JsonToken.class)}), "expectedTokens", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"T")).addException(IOException.class).addStatement("parser.nextToken()", new Object[0]).addStatement("if (parser.currentToken() == $T.VALUE_NULL) return null", new Object[]{JsonToken.class}).addStatement("if (expectedTokens.contains(parser.currentToken())) return reader.read(parser)", new Object[0]).addStatement("throw new $T(\n    $T.format(\"reading property %s, was expecting %s, but was %s\",\n        propertyName, expectedTokens, parser.currentToken()\n    )\n)", new Object[]{IOException.class, String.class}).build();
    }

    private MethodSpec readListValueMethod() {
        return MethodSpec.methodBuilder((String)"readListValue").addModifiers(new Modifier[]{Modifier.PRIVATE}).addTypeVariable(TypeVariableName.get((String)"T")).addParameter(JsonParser.class, "parser", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)"Reader"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "reader", new Modifier[0]).addParameter(String.class, "propertyName", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addException(IOException.class).addStatement("parser.nextToken()", new Object[0]).addStatement("if (parser.currentToken() == $T.VALUE_NULL) return null", new Object[]{JsonToken.class}).beginControlFlow("if (parser.currentToken() == $T.START_ARRAY)", new Object[]{JsonToken.class}).addStatement("$T<T> listValue = new $T<>()", new Object[]{LinkedList.class, LinkedList.class}).beginControlFlow("while (parser.nextToken() != $T.END_ARRAY)", new Object[]{JsonToken.class}).beginControlFlow("if(parser.currentToken() == $T.VALUE_NULL)", new Object[]{JsonToken.class}).addStatement("listValue.add(null)", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("listValue.add(reader.read(parser))", new Object[0]).endControlFlow().endControlFlow().addStatement("return listValue", new Object[0]).endControlFlow().addStatement("throw new $T(\n        $T.format(\"reading property %s, was expecting %s, but was %s\",\n                propertyName, $T.START_ARRAY, parser.currentToken()\n        )\n)", new Object[]{IOException.class, String.class, JsonToken.class}).build();
    }
}

