/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.lang.model.element.Modifier;
import org.codingmatters.value.objects.generation.ValueConfiguration;
import org.codingmatters.value.objects.json.property.JsonPropertyHelper;
import org.codingmatters.value.objects.json.property.SimplePropertyWriter;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.TypeKind;

public class ValueWriter {
    private final ValueConfiguration types;
    private final List<PropertySpec> propertySpecs;

    public ValueWriter(ValueConfiguration types, List<PropertySpec> propertySpecs) {
        this.types = types;
        this.propertySpecs = propertySpecs;
    }

    public TypeSpec type() {
        return TypeSpec.classBuilder((String)(this.types.valueType().simpleName() + "Writer")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.buildWriteWithGeneratorMethod()).addMethod(this.buildWriteArrayWithGeneratorMethod()).build();
    }

    private MethodSpec buildWriteWithGeneratorMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JsonGenerator.class, "generator", new Modifier[0]).addParameter((TypeName)this.types.valueType(), "value", new Modifier[0]).addException((TypeName)ClassName.get(IOException.class));
        method.addStatement("generator.writeStartObject()", new Object[0]);
        for (PropertySpec propertySpec : this.propertySpecs) {
            if (!JsonPropertyHelper.isTransient(propertySpec)) {
                this.writePropertyStatements(method, propertySpec);
                continue;
            }
            System.out.println("skipping transient field " + propertySpec.name());
        }
        method.addStatement("generator.writeEndObject()", new Object[0]);
        method.returns(TypeName.VOID);
        return method.build();
    }

    private MethodSpec buildWriteArrayWithGeneratorMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"writeArray").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JsonGenerator.class, "generator", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)this.types.valueType()), "values", new Modifier[0]).addException((TypeName)ClassName.get(IOException.class));
        method.beginControlFlow("if(values == null)", new Object[0]).addStatement("generator.writeNull()", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("generator.writeStartArray()", new Object[0]).beginControlFlow("for($T value : values)", new Object[]{this.types.valueType()}).addStatement("this.write(generator, value)", new Object[0]).endControlFlow().addStatement("generator.writeEndArray()", new Object[0]).endControlFlow();
        method.returns(TypeName.VOID);
        return method.build();
    }

    private void writePropertyStatements(MethodSpec.Builder method, PropertySpec propertySpec) {
        method.addStatement("generator.writeFieldName($S)", new Object[]{this.fieldName(propertySpec)});
        method.beginControlFlow("if(value.$L() != null)", new Object[]{propertySpec.name()});
        if (propertySpec.typeSpec().typeKind() == TypeKind.JAVA_TYPE) {
            this.writeSimpleProperty(method, propertySpec);
        } else if (propertySpec.typeSpec().typeKind() == TypeKind.ENUM) {
            this.writeEnumValue(method, propertySpec);
        } else if (propertySpec.typeSpec().typeKind().isValueObject()) {
            this.externalValueObjectWriteStatements(method, propertySpec);
        } else {
            System.out.println(propertySpec.typeSpec().typeKind() + " : " + propertySpec.typeSpec().typeRef());
            method.addStatement("generator.writeNull()", new Object[0]);
        }
        method.nextControlFlow("else", new Object[0]).addStatement("generator.writeNull()", new Object[0]).endControlFlow();
    }

    private String fieldName(PropertySpec propertySpec) {
        Optional hint = propertySpec.matchingHint("property:raw\\(([^)]*)\\)");
        if (hint.isPresent()) {
            return ((Matcher)hint.get()).group(1);
        }
        return propertySpec.name();
    }

    private void writeSimpleProperty(MethodSpec.Builder method, PropertySpec propertySpec) {
        if (!propertySpec.typeSpec().cardinality().isCollection()) {
            SimplePropertyWriter.forClass(propertySpec.typeSpec().typeRef()).singleStatement(method, propertySpec);
        } else {
            ClassName type = this.types.propertyClass(propertySpec);
            SimplePropertyWriter.forClass(propertySpec.typeSpec().typeRef()).arrayStatement(method, propertySpec, type);
        }
    }

    private void writeEnumValue(MethodSpec.Builder method, PropertySpec propertySpec) {
        if (!propertySpec.typeSpec().cardinality().isCollection()) {
            SimplePropertyWriter.ENUM.singleStatement(method, propertySpec);
        } else {
            SimplePropertyWriter.ENUM.arrayStatement(method, propertySpec, this.types.propertyClass(propertySpec));
        }
    }

    private void externalValueObjectWriteStatements(MethodSpec.Builder method, PropertySpec propertySpec) {
        ClassName propertyClass = this.types.valueObjectSingleType(propertySpec);
        ClassName propertyWriter = ClassName.get((String)(propertyClass.packageName() + ".json"), (String)(propertyClass.simpleName() + "Writer"), (String[])new String[0]);
        if (!propertySpec.typeSpec().cardinality().isCollection()) {
            method.addStatement("new $T().write(generator, value.$L())", new Object[]{propertyWriter, propertySpec.name()});
        } else {
            method.addStatement("generator.writeStartArray()", new Object[0]);
            method.beginControlFlow("for ($T element : value.$L())", new Object[]{propertyClass, propertySpec.name()}).beginControlFlow("if(element != null)", new Object[0]).addStatement("new $T().write(generator, element)", new Object[]{propertyWriter}).nextControlFlow("else", new Object[0]).addStatement("generator.writeNull()", new Object[0]).endControlFlow().endControlFlow();
            method.addStatement("generator.writeEndArray()", new Object[0]);
        }
    }
}

