/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.json.property;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codingmatters.value.objects.spec.PropertySpec;

public enum SimplePropertyWriter {
    STRING(new Class[]{String.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeString(value.$L())", new Object[]{propertySpec.name()});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeString(element)", new Object[0]);
        }
    }
    ,
    NUMBER(new Class[]{Integer.class, Long.class, Float.class, Double.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeNumber(value.$L())", new Object[]{propertySpec.name()});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeNumber(element)", new Object[0]);
        }
    }
    ,
    BOOLEAN(new Class[]{Boolean.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeBoolean(value.$L())", new Object[]{propertySpec.name()});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeBoolean(element)", new Object[0]);
        }
    }
    ,
    BINARY(new Class[]{byte[].class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeBinary(value.$L())", new Object[]{propertySpec.name()});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeBinary(element)", new Object[0]);
        }
    }
    ,
    DATE(new Class[]{LocalDate.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeString(value.$L().format($T.ISO_LOCAL_DATE))", new Object[]{propertySpec.name(), DateTimeFormatter.class});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeString(element.format($T.ISO_LOCAL_DATE))", new Object[]{DateTimeFormatter.class});
        }
    }
    ,
    TIME(new Class[]{LocalTime.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeString(value.$L().format($T.ISO_LOCAL_TIME))", new Object[]{propertySpec.name(), DateTimeFormatter.class});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeString(element.format($T.ISO_LOCAL_TIME))", new Object[]{DateTimeFormatter.class});
        }
    }
    ,
    DATE_TIME(new Class[]{LocalDateTime.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeString(value.$L().format($T.ISO_LOCAL_DATE_TIME))", new Object[]{propertySpec.name(), DateTimeFormatter.class});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeString(element.format($T.ISO_LOCAL_DATE_TIME))", new Object[]{DateTimeFormatter.class});
        }
    }
    ,
    TZ_DATE_TIME(new Class[]{ZonedDateTime.class}){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeString(value.$L().format($T.ISO_OFFSET_DATE_TIME))", new Object[]{propertySpec.name(), DateTimeFormatter.class});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeString(element.format($T.ISO_OFFSET_DATE_TIME))", new Object[]{DateTimeFormatter.class});
        }
    }
    ,
    ENUM(new Class[0]){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            method.addStatement("generator.writeString(value.$L().name())", new Object[]{propertySpec.name()});
        }

        @Override
        protected void arrayElementStatement(MethodSpec.Builder method) {
            method.addStatement("generator.writeString(element.name())", new Object[0]);
        }
    }
    ,
    NYIMPL(new Class[0]){

        @Override
        public void singleStatement(MethodSpec.Builder method, PropertySpec propertySpec) {
            System.err.println("WARN : property " + propertySpec.name() + " has no simple writer (" + propertySpec.toString() + ")");
            method.addStatement("generator.writeNull()", new Object[0]);
        }

        @Override
        public void arrayStatement(MethodSpec.Builder method, PropertySpec propertySpec, ClassName type) {
            System.err.println("WARN : property " + propertySpec.name() + " has no simple writer (" + propertySpec.toString() + ")");
            method.addStatement("generator.writeNull()", new Object[0]);
        }
    };

    private final Set<Class> classes;

    private SimplePropertyWriter(Class ... classes) {
        this.classes = classes != null ? new HashSet<Class>(Arrays.asList(classes)) : Collections.emptySet();
    }

    public abstract void singleStatement(MethodSpec.Builder var1, PropertySpec var2);

    public void arrayStatement(MethodSpec.Builder method, PropertySpec propertySpec, ClassName type) {
        method.addStatement("generator.writeStartArray()", new Object[0]);
        method.beginControlFlow("for ($T element : value.$L())", new Object[]{type, propertySpec.name()});
        method.beginControlFlow("if(element != null)", new Object[0]);
        this.arrayElementStatement(method);
        method.nextControlFlow("else", new Object[0]);
        method.addStatement("generator.writeNull()", new Object[0]);
        method.endControlFlow();
        method.endControlFlow();
        method.addStatement("generator.writeEndArray()", new Object[0]);
    }

    protected void arrayElementStatement(MethodSpec.Builder method) {
    }

    public static SimplePropertyWriter forClass(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("no simple writer as not a class : " + className);
            return NYIMPL;
        }
        for (SimplePropertyWriter writer : SimplePropertyWriter.values()) {
            if (!writer.classes.contains(clazz)) continue;
            return writer;
        }
        System.err.println("no simple writer implementation for : " + className);
        return NYIMPL;
    }
}

