/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.php.generator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codingmatters.value.objects.exception.SpecSyntaxException;
import org.codingmatters.value.objects.php.generator.TypeTokenPhp;
import org.codingmatters.value.objects.spec.AnonymousValueSpec;
import org.codingmatters.value.objects.spec.PropertyCardinality;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.PropertyTypeSpec;
import org.codingmatters.value.objects.spec.Spec;
import org.codingmatters.value.objects.spec.TypeKind;
import org.codingmatters.value.objects.spec.TypeToken;
import org.codingmatters.value.objects.spec.ValueSpec;

public class ContextSpecParserPhp {
    private static final Pattern JAVA_IDENTIFIER_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern FULLY_QUALIFIED_CLASS_NAME_PATTERN = Pattern.compile(JAVA_IDENTIFIER_PATTERN.pattern() + "(\\." + JAVA_IDENTIFIER_PATTERN.pattern() + ")+");
    private final Map<String, ?> root;
    private Stack<String> context;
    private List<String> imports;

    public ContextSpecParserPhp(Map<String, ?> root) {
        this.root = root;
    }

    public Spec parse() throws SpecSyntaxException {
        this.context = new Stack();
        this.imports = new ArrayList<String>();
        Spec.Builder spec = Spec.spec();
        for (String valueName : this.root.keySet()) {
            spec.addValue(this.createValueSpec(valueName));
        }
        return spec.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueSpec.Builder createValueSpec(String valueName) throws SpecSyntaxException {
        this.context.push(valueName);
        try {
            ValueSpec.Builder value = ValueSpec.valueSpec().name(valueName);
            Map properties = (Map)this.root.get(valueName);
            if (properties != null) {
                for (String propertyName : properties.keySet()) {
                    PropertySpec.Builder propertySpec = this.createPropertySpec(propertyName, properties.get(propertyName));
                    value.addProperty(propertySpec);
                }
            }
            ValueSpec.Builder builder = value;
            return builder;
        }
        finally {
            this.context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySpec.Builder createPropertySpec(String propertyName, Object object) throws SpecSyntaxException {
        this.context.push(propertyName);
        try {
            PropertyTypeSpec.Builder typeSpec;
            PropertyCardinality cardinality = object instanceof Map && (((Map)object).containsKey("$list") || ((Map)object).containsKey("$set")) ? PropertyCardinality.LIST : PropertyCardinality.SINGLE;
            if (object instanceof String) {
                typeSpec = this.typeForString((String)object);
            } else if (object instanceof Map && ((Map)object).containsKey("$enum")) {
                typeSpec = this.enumTypeSpec(object);
            } else if (object instanceof Map) {
                typeSpec = PropertyTypeSpec.type().typeKind(TypeKind.EMBEDDED);
                typeSpec.embeddedValueSpec(this.parseAnonymousValueSpec((Map)object));
            } else {
                if (object instanceof Map && ((Map)object).containsKey("$value-object")) {
                    throw new SpecSyntaxException("Not implemented yet", this.context);
                }
                if (object instanceof Map && ((Map)object).containsKey("$type")) {
                    throw new SpecSyntaxException("Not implemented yet", this.context);
                }
                throw new SpecSyntaxException(String.format("unexpected specification for property : %s", object), this.context);
            }
            typeSpec.cardinality(cardinality);
            PropertySpec.Builder builder = PropertySpec.property().name(propertyName).type(typeSpec);
            return builder;
        }
        finally {
            this.context.pop();
        }
    }

    private PropertyTypeSpec.Builder enumTypeSpec(Object value) throws SpecSyntaxException {
        if (((Map)value).get("$enum") != null && ((Map)value).get("$enum") instanceof String) {
            String valueString = (String)((Map)value).get("$enum");
            LinkedList<String> values = new LinkedList<String>();
            for (String val : valueString.split(",")) {
                values.add(val.trim());
            }
            return PropertyTypeSpec.type().typeKind(TypeKind.ENUM).typeRef(String.join((CharSequence)"", this.context.stream().map(type -> this.firstLetterUpperCase((String)type)).collect(Collectors.toList()))).enumValues(values.toArray(new String[values.size()]));
        }
        if (((Map)value).get("$enum") != null && ((Map)value).get("$enum") instanceof Map && ((Map)((Map)value).get("$enum")).containsKey("$type") && ((Map)((Map)value).get("$enum")).get("$type") instanceof String) {
            return PropertyTypeSpec.type().typeKind(TypeKind.ENUM).typeRef((String)((Map)((Map)value).get("$enum")).get("$type"));
        }
        throw new SpecSyntaxException(String.format("malformed enum specification for property {context}: %s", value), this.context);
    }

    private String firstLetterUpperCase(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
    }

    private PropertyTypeSpec.Builder typeForString(String type) throws SpecSyntaxException {
        if (type.startsWith("$")) {
            if (this.root.keySet().contains(type.substring(1))) {
                return PropertyTypeSpec.type().typeRef(type.substring(1)).typeKind(TypeKind.IN_SPEC_VALUE_OBJECT);
            }
            throw new SpecSyntaxException("undeclared referenced type for {context} : a referenced type should be declared in the same spec", this.context);
        }
        if (FULLY_QUALIFIED_CLASS_NAME_PATTERN.matcher(type).matches()) {
            return PropertyTypeSpec.type().typeRef(type).typeKind(TypeKind.JAVA_TYPE);
        }
        return PropertyTypeSpec.type().typeRef(this.parseType(type).getTypeName()).typeKind(TypeKind.JAVA_TYPE);
    }

    private TypeTokenPhp parseType(String typeSpec) throws SpecSyntaxException {
        TypeTokenPhp type;
        try {
            type = TypeTokenPhp.parse(typeSpec);
        }
        catch (IllegalArgumentException e) {
            throw new SpecSyntaxException(String.format("invalid type for property {context} : %s, should be one of %s, a reference to an in spec declared type ($type notation) or a fully qualified class name (default package classes cannot be used).", typeSpec, TypeToken.validTypesSpec()), this.context);
        }
        return type;
    }

    private AnonymousValueSpec parseAnonymousValueSpec(Map value) throws SpecSyntaxException {
        AnonymousValueSpec.Builder result = AnonymousValueSpec.anonymousValueSpec();
        for (Object name : value.keySet()) {
            result.addProperty(this.createPropertySpec((String)name, value.get(name)));
        }
        return result.build();
    }
}

