/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.php.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.codingmatters.value.objects.php.phpmodel.PhpEnum;
import org.codingmatters.value.objects.php.phpmodel.PhpMethod;
import org.codingmatters.value.objects.php.phpmodel.PhpPackagedValueSpec;
import org.codingmatters.value.objects.php.phpmodel.PhpPropertySpec;
import org.codingmatters.value.objects.spec.PropertyCardinality;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.TypeKind;

public class PhpTypeClassWriter {
    public final String packageName;
    private final File targetDirectory;
    private final String fileName;
    public final BufferedWriter writer;
    public final String objectName;
    private final Set<String> imports;
    private final String indent = "    ";

    public PhpTypeClassWriter(File targetDirectory, String packageName, String name) throws IOException {
        if (!targetDirectory.exists() && !targetDirectory.mkdirs() || !targetDirectory.isDirectory()) {
            throw new IOException("Target directory not exist or is not a directory");
        }
        this.packageName = packageName;
        this.targetDirectory = targetDirectory;
        this.objectName = this.firstLetterUpperCase(name);
        this.fileName = this.objectName + ".php";
        String targetFile = String.join((CharSequence)"/", this.targetDirectory.getPath(), this.fileName);
        this.writer = new BufferedWriter(new FileWriter(targetFile));
        this.imports = new HashSet<String>();
    }

    public void writeEnum(PhpEnum enumValue) throws IOException {
        this.startPhpFile();
        this.writer.write("use \\Exception;");
        this.twoLine(0);
        this.writer.write("use \\JsonSerializable;");
        this.twoLine(0);
        this.writer.write("class " + enumValue.name() + " implements JsonSerializable {");
        this.twoLine(1);
        this.writer.write("protected $value;");
        this.twoLine(1);
        this.writer.write("private function __construct( $value ){");
        this.newLine(2);
        this.writer.write("$this->value = $value;");
        this.newLine(1);
        this.writer.write("}");
        this.twoLine(1);
        this.writer.write("public function value(){");
        this.newLine(2);
        this.writer.write("return $this->value;");
        this.newLine(1);
        this.writer.write("}");
        this.newLine(1);
        for (String value : enumValue.enumValues()) {
            this.newLine(1);
            this.writer.write("public static function " + value + "(): " + enumValue.name() + " { ");
            this.writer.newLine();
            this.indent(2);
            this.writer.write("return new " + enumValue.name() + "( '" + value + "' );");
            this.writer.newLine();
            this.indent(1);
            this.writer.write("}");
            this.newLine(0);
        }
        this.newLine(1);
        this.writer.write("public static function valueOf( string $value ): " + enumValue.name() + " {");
        this.newLine(2);
        this.writer.write("if( in_array($value, " + enumValue.name() + "::values())){");
        this.newLine(3);
        this.writer.write("return new " + enumValue.name() + "( $value );");
        this.newLine(2);
        this.writer.write("} else {");
        this.newLine(3);
        this.writer.write("throw new Exception( 'No enum constant '.$value );");
        this.newLine(2);
        this.writer.write("}");
        this.newLine(1);
        this.writer.write("}");
        this.twoLine(1);
        this.writer.write("public static function values(){");
        this.newLine(2);
        this.writer.write("return array('" + String.join((CharSequence)"', '", enumValue.enumValues()) + "');");
        this.newLine(1);
        this.writer.write("}");
        this.newLine(1);
        this.writer.write("public function jsonSerialize() {");
        this.newLine(2);
        this.writer.write("return $this->value;");
        this.newLine(1);
        this.writer.write("}");
        this.newLine(0);
        this.writer.write("}");
        this.writer.flush();
        this.writer.close();
    }

    private void startPhpFile() throws IOException {
        this.writer.write("<?php");
        this.twoLine(0);
        this.writer.write("namespace " + String.join((CharSequence)"\\", this.packageName.split("\\.")) + ";");
        this.twoLine(0);
    }

    public void writeValueObject(PhpPackagedValueSpec spec, boolean serializable, boolean useReturnType) throws IOException {
        this.startPhpFile();
        for (String importation : spec.imports()) {
            this.writer.write("use " + importation.replace(".", "\\") + ";");
            this.writer.newLine();
        }
        this.writer.newLine();
        this.writer.write("class " + this.objectName);
        if (spec.extender() != null) {
            this.writer.write(" extends " + spec.extender().typeRef());
        }
        if (serializable) {
            this.writer.write(" implements \\JsonSerializable");
        }
        this.writer.write(" {");
        this.twoLine(1);
        for (PhpPropertySpec fieldSpec : spec.propertySpecs()) {
            this.writer.write("private $" + this.getFieldName(fieldSpec) + ";");
            this.newLine(1);
        }
        this.newLine(0);
        for (PhpMethod phpMethod : spec.methods()) {
            this.indent(1);
            this.writer.write("public function ");
            this.writer.write(phpMethod.name());
            this.writer.write("(");
            this.writer.write(String.join((CharSequence)", ", phpMethod.parameters().stream().map(param -> param.type() + " $" + param.name()).collect(Collectors.toList())));
            this.writer.write(")");
            String returnType = phpMethod.type();
            if (returnType != null && useReturnType) {
                this.writer.write(": " + returnType);
            }
            this.writer.write(" {");
            this.writer.newLine();
            for (String instruction : phpMethod.instructions()) {
                this.indent(2);
                this.writer.write(instruction);
                this.writer.write(";");
                this.writer.newLine();
            }
            this.indent(1);
            this.writer.write("}");
            this.twoLine(0);
        }
        if (serializable) {
            this.indent(1);
            this.writer.write("public function jsonSerialize() {");
            this.newLine(2);
            this.writer.write("return new \\ArrayObject( get_object_vars($this));");
            this.newLine(1);
            this.writer.write("}");
            this.newLine(0);
        }
        this.writer.write("}");
        this.writer.flush();
        this.writer.close();
    }

    public void writeWriter(PhpPackagedValueSpec spec) throws IOException {
        this.startPhpFile();
        this.writer.write("use " + spec.packageName().replace(".", "\\") + "\\" + spec.name() + ";");
        this.twoLine(0);
        this.writer.write("class " + this.objectName + " {");
        this.twoLine(1);
        String objectToWrite = this.objectName.substring(0, this.objectName.length() - 6);
        this.twoLine(1);
        this.writer.write("public function write( " + objectToWrite + " $object ){ ");
        this.newLine(2);
        this.writer.write("return json_encode( $this->getArray( $object ));");
        this.newLine(1);
        this.writer.write("}");
        this.twoLine(1);
        this.writer.write("public function getArray( " + objectToWrite + " $object ) : \\ArrayObject {");
        this.newLine(2);
        this.writer.write("$array = new \\ArrayObject();");
        this.newLine(2);
        for (PhpPropertySpec property : spec.propertySpecs()) {
            if (property.typeSpec().cardinality() == PropertyCardinality.LIST || property.typeSpec().cardinality() == PropertyCardinality.SET) {
                this.writeFieldList(spec, property);
                continue;
            }
            this.writeSingleField(property);
        }
        this.newLine(2);
        this.writer.write("return $array;");
        this.newLine(1);
        this.writer.write("}");
        this.newLine(0);
        this.writer.write("}");
        this.writer.flush();
        this.writer.close();
    }

    private void writeSingleField(PhpPropertySpec property) throws IOException {
        if (property.typeSpec().typeKind() == TypeKind.ENUM) {
            this.writer.write("$var = $object->" + property.name() + "();");
            this.newLine(2);
            this.writer.write("if( isset( $var )){");
            this.newLine(3);
            this.writer.write("$array['" + property.realName() + "'] = $var->jsonSerialize();");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else if ("io.flexio.utils.FlexDate".equals(property.typeSpec().typeRef())) {
            this.writer.write("$var = $object->" + property.name() + "();");
            this.newLine(2);
            this.writer.write("if( isset( $var )){");
            this.newLine(3);
            this.writer.write("$array['" + property.realName() + "'] = $var->jsonSerialize();");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else if (property.typeSpec().typeKind() == TypeKind.IN_SPEC_VALUE_OBJECT || property.typeSpec().typeKind() == TypeKind.EXTERNAL_VALUE_OBJECT) {
            this.writer.write("$var = $object->" + property.name() + "();");
            this.newLine(2);
            this.writer.write("if( isset( $var )){");
            this.newLine(3);
            this.writer.write("$writer = new \\" + this.getWriterFromReference(property.typeSpec().typeRef()) + "();");
            this.newLine(3);
            this.writer.write("$array['" + property.realName() + "'] = $writer->getArray( $var );");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else if (property.typeSpec().typeRef().equals("\\ArrayObject")) {
            this.writer.write("$var = $object->" + property.name() + "();");
            this.newLine(2);
            this.writer.write("if( isset( $var )){");
            this.newLine(3);
            this.writer.write("$array['" + property.realName() + "'] = $var;");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else {
            this.writer.write("$var = $object->" + property.name() + "();");
            this.newLine(2);
            this.writer.write("if( isset( $var )){");
            this.newLine(3);
            this.writer.write("$array['" + property.realName() + "'] = $var;");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        }
    }

    private void writeFieldList(PhpPackagedValueSpec spec, PhpPropertySpec property) throws IOException {
        this.writer.write("$var = $object->" + property.name() + "();");
        this.newLine(2);
        this.writer.write("if( isset( $var )){");
        this.newLine(3);
        this.writer.write("$list = array();");
        this.newLine(3);
        this.writer.write("foreach( $var as $item ){");
        if (property.typeSpec().typeKind() == TypeKind.ENUM) {
            this.newLine(4);
            this.writer.write("$list[] = $item->jsonSerialize();");
        } else if (property.typeSpec().typeKind() == TypeKind.EXTERNAL_VALUE_OBJECT && property.typeSpec().embeddedValueSpec() != null || property.typeSpec().typeKind() == TypeKind.IN_SPEC_VALUE_OBJECT) {
            if (((PropertySpec)property.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeKind() == TypeKind.JAVA_TYPE) {
                this.writer.write("$list[] = $item;");
            } else if ("io.flexio.utils.FlexDate".equals(((PropertySpec)property.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeRef())) {
                this.writer.write("$list[] = $item->jsonSerialize();");
            } else {
                this.writer.write("$writer = new \\" + this.getWriterFromReference(((PropertySpec)property.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeRef()) + "();");
                this.newLine(4);
                this.writer.write("$list[] = $writer->getArray( $item );");
            }
        } else {
            this.newLine(3);
            this.writer.write("$list[] = $item;");
        }
        this.newLine(3);
        this.writer.write("}");
        this.newLine(2);
        this.writer.write("$array['" + property.realName() + "'] = $list;");
        this.newLine(2);
        this.writer.write("}");
    }

    public void writeReader(PhpPackagedValueSpec spec) throws IOException {
        this.startPhpFile();
        this.writer.write("use " + spec.packageName().replace(".", "\\") + "\\" + spec.name() + ";");
        this.writer.newLine();
        for (String importation : spec.imports()) {
            this.writer.write("use " + importation.replace(".", "\\") + ";");
            this.writer.newLine();
        }
        this.twoLine(0);
        this.writer.write("class " + this.objectName + " {");
        this.twoLine(1);
        String objectToRead = this.objectName.substring(0, this.objectName.length() - 6);
        this.writer.write("public function read( string $json ) : " + objectToRead + " {");
        this.newLine(2);
        this.writer.write("$decode = json_decode( $json, true );");
        this.newLine(2);
        this.writer.write("return $this->readArray( $decode );");
        this.newLine(1);
        this.writer.write("}");
        this.twoLine(1);
        this.writer.write("public function readArray( array $decode ) : " + objectToRead + " {");
        this.newLine(2);
        String resultVar = "$" + this.firstLetterLowerCase(objectToRead);
        this.writer.write(resultVar + " = new " + objectToRead + "();");
        this.newLine(2);
        for (PhpPropertySpec property : spec.propertySpecs()) {
            if (property.typeSpec().cardinality() == PropertyCardinality.LIST || property.typeSpec().cardinality() == PropertyCardinality.SET) {
                this.readFieldList(spec, resultVar, property);
                continue;
            }
            this.readSingleField(resultVar, property);
        }
        this.writer.write("return " + resultVar + ";");
        this.newLine(1);
        this.writer.write("}");
        this.twoLine(0);
        this.writer.write("}");
        this.writer.flush();
        this.writer.close();
    }

    private void readFieldList(PhpPackagedValueSpec spec, String resultVar, PhpPropertySpec property) throws IOException {
        this.writer.write("if( isset( $decode['" + property.realName() + "'] )){");
        this.newLine(3);
        String listType = "\\" + property.typeSpec().typeRef().replace(".", "\\");
        this.writer.write("$list = new " + listType + "();");
        this.newLine(3);
        this.writer.write("foreach( $decode['" + property.realName() + "'] as $item ){");
        this.newLine(4);
        if (property.typeSpec().typeKind() == TypeKind.ENUM) {
            this.writer.write("$list[] = \\" + property.typeSpec().typeRef().substring(0, property.typeSpec().typeRef().length() - 4).replace(".", "\\") + "::valueOf( $item );");
        } else if (property.typeSpec().typeKind() == TypeKind.EXTERNAL_VALUE_OBJECT && property.typeSpec().embeddedValueSpec() != null || property.typeSpec().typeKind() == TypeKind.IN_SPEC_VALUE_OBJECT) {
            if (((PropertySpec)property.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeKind() == TypeKind.JAVA_TYPE) {
                this.writer.write("$list[] = $item;");
            } else if ("io.flexio.utils.FlexDate".equals(((PropertySpec)property.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeRef())) {
                this.writer.write("$list[] = \\io\\flexio\\utils\\FlexDate::parse( $item );");
            } else {
                this.writer.write("$reader = new \\" + this.getReaderFromReference(((PropertySpec)property.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeRef()) + "();");
                this.newLine(4);
                this.writer.write("$list[] = $reader->readArray( $item );");
            }
        } else {
            this.writer.write("$list[] = $item;");
        }
        this.newLine(3);
        this.writer.write("}");
        this.newLine(3);
        this.writer.write(resultVar + "->with" + this.firstLetterUpperCase(property.name()) + "( $list );");
        this.newLine(2);
        this.writer.write("}");
        this.newLine(2);
    }

    private void readSingleField(String resultVar, PhpPropertySpec property) throws IOException {
        if (property.typeSpec().typeKind() == TypeKind.ENUM) {
            this.writer.write("if( isset( $decode['" + property.realName() + "'] )){");
            this.newLine(3);
            this.writer.write(resultVar + "->with" + this.firstLetterUpperCase(property.name()) + "( \\" + property.typeSpec().typeRef().replace(".", "\\") + "::valueOf( $decode['" + property.realName() + "'] ));");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else if ("io.flexio.utils.FlexDate".equals(property.typeSpec().typeRef())) {
            this.writer.write("if( isset( $decode['" + property.realName() + "'] )){");
            this.newLine(3);
            this.writer.write(resultVar + "->with" + this.firstLetterUpperCase(property.name()) + "( \\io\\flexio\\utils\\FlexDate::parse( $decode['" + property.realName() + "'] ));");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else if (property.typeSpec().typeKind() == TypeKind.IN_SPEC_VALUE_OBJECT || property.typeSpec().typeKind() == TypeKind.EXTERNAL_VALUE_OBJECT) {
            this.writer.write("if( isset( $decode['" + property.realName() + "'] )){");
            this.newLine(3);
            this.writer.write("$reader = new \\" + this.getReaderFromReference(property.typeSpec().typeRef()) + "();");
            this.newLine(3);
            this.writer.write(resultVar + "->with" + this.firstLetterUpperCase(property.name()) + "( $reader->readArray( $decode['" + property.realName() + "'] ));");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else if (property.typeSpec().typeRef().equals("\\ArrayObject")) {
            this.writer.write("if( isset( $decode['" + property.realName() + "'] )){");
            this.newLine(3);
            this.writer.write(resultVar + "->with" + this.firstLetterUpperCase(property.name()) + "( new \\ArrayObject( $decode['" + property.realName() + "'] ));");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        } else {
            this.writer.write("if( isset( $decode['" + property.realName() + "'] )){");
            this.newLine(3);
            this.writer.write(resultVar + "->with" + this.firstLetterUpperCase(property.name()) + "( $decode['" + property.realName() + "'] );");
            this.newLine(2);
            this.writer.write("}");
            this.newLine(2);
        }
    }

    private String getReaderFromReference(String typeRef) {
        int index = typeRef.lastIndexOf(".");
        return (typeRef.substring(0, index) + ".json" + typeRef.substring(index) + "Reader").replace(".", "\\");
    }

    private String getWriterFromReference(String typeRef) {
        int index = typeRef.lastIndexOf(".");
        return (typeRef.substring(0, index) + ".json" + typeRef.substring(index) + "Writer").replace(".", "\\");
    }

    private String getDateClass(String dateClass) {
        return String.join((CharSequence)"", Arrays.stream(dateClass.split("-")).map(this::firstLetterUpperCase).collect(Collectors.toList()));
    }

    private boolean isDate(PhpPropertySpec property) {
        return property.typeSpec().typeRef().equals("date") || property.typeSpec().typeRef().equals("time") || property.typeSpec().typeRef().equals("date-time");
    }

    private void twoLine(int indentSize) throws IOException {
        this.newLine(0);
        this.newLine(indentSize);
    }

    private void newLine(int indentSize) throws IOException {
        this.writer.newLine();
        this.indent(indentSize);
    }

    private void indent(int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            this.writer.write(this.indent);
        }
    }

    private String getFieldName(PhpPropertySpec fieldSpec) {
        if (fieldSpec.name().equals("$list")) {
            return fieldSpec.typeSpec().typeRef() + "s";
        }
        return fieldSpec.name();
    }

    private String firstLetterUpperCase(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private String firstLetterLowerCase(String name) {
        return name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }
}

