/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.php.phpmodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codingmatters.value.objects.php.phpmodel.PhpMethod;
import org.codingmatters.value.objects.php.phpmodel.PhpPropertySpec;
import org.codingmatters.value.objects.spec.PropertyTypeSpec;

public class PhpPackagedValueSpec {
    private String name;
    private final String packageName;
    private List<PhpPropertySpec> properties;
    private List<PhpMethod> methods;
    private PropertyTypeSpec extender;
    private Set<String> imports;

    public PhpPackagedValueSpec(String packageName, String name) {
        this.name = name;
        this.packageName = packageName;
        this.properties = new ArrayList<PhpPropertySpec>();
        this.methods = new ArrayList<PhpMethod>();
        this.imports = new HashSet<String>();
        this.extender = null;
    }

    public String name() {
        return this.name;
    }

    public void addProperty(PhpPropertySpec property) {
        this.properties.add(property);
    }

    public List<PhpPropertySpec> propertySpecs() {
        return this.properties;
    }

    public List<PhpMethod> methods() {
        return this.methods;
    }

    public void addMethod(PhpMethod method) {
        this.methods.add(method);
    }

    public void extend(PropertyTypeSpec typeSpec) {
        this.extender = typeSpec;
    }

    public PropertyTypeSpec extender() {
        return this.extender;
    }

    public void addImport(String importation) {
        this.imports.add(importation);
    }

    public Set<String> imports() {
        return this.imports;
    }

    public String packageName() {
        return this.packageName;
    }
}

