/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.js.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.codingmatters.value.objects.js.error.SyntaxError;
import org.codingmatters.value.objects.js.parser.NamingUtils;
import org.codingmatters.value.objects.js.parser.model.ParsedValueObject;
import org.codingmatters.value.objects.js.parser.model.ParsedYAMLSpec;
import org.codingmatters.value.objects.js.parser.model.ValueObjectProperty;
import org.codingmatters.value.objects.js.parser.model.types.ObjectTypeExternalValue;
import org.codingmatters.value.objects.js.parser.model.types.ObjectTypeInSpecValueObject;
import org.codingmatters.value.objects.js.parser.model.types.ObjectTypeNested;
import org.codingmatters.value.objects.js.parser.model.types.ValueObjectType;
import org.codingmatters.value.objects.js.parser.model.types.ValueObjectTypeExternalType;
import org.codingmatters.value.objects.js.parser.model.types.ValueObjectTypeList;
import org.codingmatters.value.objects.js.parser.model.types.ValueObjectTypePrimitiveType;
import org.codingmatters.value.objects.js.parser.model.types.YamlEnumExternalEnum;
import org.codingmatters.value.objects.js.parser.model.types.YamlEnumInSpecEnum;

public class YamlSpecParser {
    public static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private Stack<String> context;
    private final String typesPackage;

    public YamlSpecParser(String typesPackage) {
        this.typesPackage = typesPackage;
    }

    public ParsedYAMLSpec parse(InputStream inputStream) throws SyntaxError {
        Map root = null;
        try {
            root = (Map)MAPPER.readValue(inputStream, Map.class);
            return this.extractValueObjects(root);
        }
        catch (IOException e) {
            throw new SyntaxError(e);
        }
    }

    private ParsedYAMLSpec extractValueObjects(Map<String, ?> valueSpecs) throws SyntaxError {
        ParsedYAMLSpec parsedYAMLSpec = new ParsedYAMLSpec();
        for (String valueObjectName : valueSpecs.keySet()) {
            this.context = new Stack();
            parsedYAMLSpec.valueObjects().add(this.parseValueObject(valueSpecs, valueObjectName));
        }
        return parsedYAMLSpec;
    }

    private ParsedValueObject parseValueObject(Map<String, ?> valueSpecs, String valueObjectName) throws SyntaxError {
        this.context.push(valueObjectName);
        ParsedValueObject valueObject = new ParsedValueObject(NamingUtils.nestedTypeName(this.context), this.typesPackage);
        Map properties = (Map)valueSpecs.get(valueObjectName);
        if (properties != null) {
            this.parseProperties(valueObject, properties);
        }
        this.context.pop();
        return valueObject;
    }

    private void parseProperties(ParsedValueObject valueObject, Map<String, ?> properties) throws SyntaxError {
        for (String propertyName : properties.keySet()) {
            valueObject.properties().add(new ValueObjectProperty(propertyName, this.parseType(propertyName, properties.get(propertyName))));
        }
    }

    private ValueObjectType parseType(String propertyName, Object object) throws SyntaxError {
        this.context.push(propertyName);
        try {
            if (object instanceof String) {
                if (this.isPrimitiveType((String)object)) {
                    ValueObjectTypePrimitiveType valueObjectTypePrimitiveType = new ValueObjectTypePrimitiveType((String)object);
                    return valueObjectTypePrimitiveType;
                }
                if (this.isInternalValueObject((String)object)) {
                    ObjectTypeInSpecValueObject objectTypeInSpecValueObject = new ObjectTypeInSpecValueObject(((String)object).substring(1), this.typesPackage);
                    return objectTypeInSpecValueObject;
                }
                throw new SyntaxError("Cannot parse this type");
            }
            if (object instanceof Map) {
                if (this.isList((Map)object)) {
                    ValueObjectType valueObjectType = this.parseList((Map)object);
                    return valueObjectType;
                }
                if (this.isEnum((Map)object)) {
                    ValueObjectType valueObjectType = this.parseEnum((Map)object);
                    return valueObjectType;
                }
                if (this.isExternalValueObject((Map)object)) {
                    ObjectTypeExternalValue objectTypeExternalValue = new ObjectTypeExternalValue((String)((Map)object).get("$value-object"));
                    return objectTypeExternalValue;
                }
                if (this.isExternalType((Map)object)) {
                    ValueObjectTypeExternalType valueObjectTypeExternalType = new ValueObjectTypeExternalType((String)((Map)object).get("$type"));
                    return valueObjectTypeExternalType;
                }
                ValueObjectType valueObjectType = this.parseNestedTypeProperty((Map)object);
                return valueObjectType;
            }
            throw new SyntaxError("Cannot parse this value object property: " + propertyName);
        }
        finally {
            this.context.pop();
        }
    }

    private boolean isInternalValueObject(String object) {
        return object.startsWith("$");
    }

    private boolean isExternalValueObject(Map object) {
        return object.keySet().size() == 1 && object.get("$value-object") != null;
    }

    private boolean isExternalType(Map object) {
        return object.keySet().size() == 1 && object.get("$type") != null;
    }

    private boolean isPrimitiveType(String type) {
        return ValueObjectTypePrimitiveType.YAML_PRIMITIVE_TYPES.from(type) != null;
    }

    private boolean isEnum(Map object) {
        return object.keySet().size() == 1 && object.get("$enum") != null;
    }

    private boolean isList(Map object) {
        return object.keySet().size() == 1 && (object.get("$list") != null || object.get("$set") != null);
    }

    private ValueObjectType parseList(Map object) throws SyntaxError {
        Object listType = object.getOrDefault("$list", object.get("$set"));
        if (listType == null) {
            throw new SyntaxError("The list cannot be parsed");
        }
        String pop = this.context.pop();
        ValueObjectType type = this.parseType(pop, listType);
        this.context.push(pop);
        String name = NamingUtils.camelCase((String)this.context.get(this.context.size() - 2)) + NamingUtils.camelCase((String)this.context.get(this.context.size() - 1)) + "List";
        String namespace = NamingUtils.namespace(this.context);
        return new ValueObjectTypeList(name, type, this.typesPackage + "." + namespace);
    }

    private ValueObjectType parseEnum(Map object) throws SyntaxError {
        if (object.get("$enum") instanceof String) {
            String enumValue = (String)object.get("$enum");
            if (enumValue.contains(",")) {
                String name = NamingUtils.camelCase((String)this.context.get(this.context.size() - 2)) + NamingUtils.camelCase((String)this.context.get(this.context.size() - 1));
                return new YamlEnumInSpecEnum(name, NamingUtils.namespace(this.context), Arrays.stream(enumValue.split(",")).map(field -> field.trim().toUpperCase()).collect(Collectors.toList()));
            }
        } else if (object.get("$enum") instanceof Map) {
            String enumReference = (String)((Map)object.get("$enum")).get("$type");
            return new YamlEnumExternalEnum(enumReference);
        }
        throw new SyntaxError("Cannot parse this enum");
    }

    private ValueObjectType parseNestedTypeProperty(Map<String, ?> properties) throws SyntaxError {
        ParsedValueObject nestValueObject = new ParsedValueObject(NamingUtils.camelCase(this.context.peek()), this.typesPackage);
        this.parseProperties(nestValueObject, properties);
        return new ObjectTypeNested(nestValueObject, String.join((CharSequence)".", this.context.subList(this.context.size() - 2, this.context.size() - 1)));
    }
}

