/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.blend;

import org.cogchar.api.animoid.protocol.JPRRFrame;
import org.cogchar.api.animoid.protocol.JointPositionRROM;

public class SlopeBlendFuncs {
    public static JointPositionRROM computeActualDeltaJP(JointPositionRROM naiveDeltaJP, JointPositionRROM goalDeltaJP, double goalAllowanceCoeff, double fixedAllowance) {
        double naiveDelta = naiveDeltaJP.getPosRelROM();
        double goalDelta = goalDeltaJP.getPosRelROM();
        double maxMag = goalAllowanceCoeff * Math.abs(goalDelta) + fixedAllowance;
        double actualMag = Math.min(maxMag, Math.abs(naiveDelta));
        double actualDelta = Math.signum(naiveDelta) * actualMag;
        return new JointPositionRROM(naiveDeltaJP.getJoint(), actualDelta);
    }

    public static JPRRFrame computeActualDeltaFrame(JPRRFrame naiveDeltaFrame, JPRRFrame goalDeltaFrame, double goalAllowanceCoeff, double fixedAllowance) {
        JPRRFrame resultFrame = new JPRRFrame();
        for (JointPositionRROM naiveJPRR : naiveDeltaFrame.getAllPositions()) {
            JointPositionRROM goalJPRR = (JointPositionRROM)goalDeltaFrame.getJointPositionForJoint(naiveJPRR.getJoint());
            JointPositionRROM actualJPRR = SlopeBlendFuncs.computeActualDeltaJP(naiveJPRR, goalJPRR, goalAllowanceCoeff, fixedAllowance);
            resultFrame.addPosition(actualJPRR);
        }
        return resultFrame;
    }
}

