/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curve;

import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.curve.ConstAccelCurveStateVarSymbol;
import org.cogchar.animoid.calc.curve.PolynomialMotionCurve;
import org.jscience.mathematics.function.Polynomial;
import org.jscience.mathematics.function.Term;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Ring;

public class ConstAccelCurve<RN extends Number<RN>>
extends PolynomialMotionCurve<ConstAccelCurveStateVarSymbol, RN> {
    private NumberFactory<RN> myNumberFactory;
    private Polynomial<RN> myAccelCurve;

    public ConstAccelCurve(String symbolSuffix, Variable<RN> offsetTimeVar, NumberFactory<RN> numFact) {
        super(symbolSuffix);
        this.mySymbolSuffix = symbolSuffix;
        if (offsetTimeVar != null) {
            this.useExistingPolyVar(ConstAccelCurveStateVarSymbol.TIME_OFFSET, offsetTimeVar);
        }
        this.myNumberFactory = numFact;
        Polynomial<RN> curvePoly = this.makeCurvePoly();
        this.setCurvePoly(curvePoly);
    }

    public ConstAccelCurve(String symbolSuffix, NumberFactory<RN> numFact) {
        this(symbolSuffix, null, numFact);
    }

    private Polynomial<RN> makeCurvePoly() {
        Number one = this.myNumberFactory.getOne();
        Number oneHalf = this.myNumberFactory.getOneHalf();
        Variable timeVar = this.getPolyVar(ConstAccelCurveStateVarSymbol.TIME_OFFSET);
        Variable accVar = this.getPolyVar(ConstAccelCurveStateVarSymbol.CONST_ACCEL);
        Variable initPosVar = this.getPolyVar(ConstAccelCurveStateVarSymbol.INIT_POS);
        Variable initVelVar = this.getPolyVar(ConstAccelCurveStateVarSymbol.INIT_VEL);
        Term timeSquaredTerm = Term.valueOf(timeVar, (int)2);
        Term accelTerm = Term.valueOf(accVar, (int)1);
        Term accelTimeSqTerm = timeSquaredTerm.times(accelTerm);
        Polynomial parabPoly = Polynomial.valueOf((Ring)oneHalf, (Term)accelTimeSqTerm);
        Term timeTerm = Term.valueOf(timeVar, (int)1);
        Term velTerm = Term.valueOf(initVelVar, (int)1);
        Term velTimeTerm = timeTerm.times(velTerm);
        Polynomial linearPoly = Polynomial.valueOf((Ring)one, (Term)velTimeTerm);
        Polynomial constPoly = Polynomial.valueOf((Ring)one, initPosVar);
        Polynomial constPlusLinear = constPoly.plus(linearPoly);
        Polynomial fullPoly = constPlusLinear.plus(parabPoly);
        return fullPoly;
    }

    public Polynomial<RN> getVelocityCurve() {
        return this.getDerivPolyForStateVarSymbol(ConstAccelCurveStateVarSymbol.TIME_OFFSET);
    }

    public Polynomial<RN> getAccelCurve() {
        if (this.myAccelCurve == null) {
            Polynomial<RN> velCurve = this.getVelocityCurve();
            Variable timeVar = this.getPolyVar(ConstAccelCurveStateVarSymbol.TIME_OFFSET);
            this.myAccelCurve = velCurve.differentiate(timeVar);
        }
        return this.myAccelCurve;
    }

    public RN getVelocityAtCurrentState() {
        return this.evalDerivPolyAtCurrentState(ConstAccelCurveStateVarSymbol.TIME_OFFSET);
    }

    public RN getPositionAtCurrentState() {
        return this.evalCurvePolyAtCurrentState();
    }

    public RN getAccelAtCurrentState() {
        return this.getStateVarVal(ConstAccelCurveStateVarSymbol.CONST_ACCEL);
    }

    public RN getTimeOffsetAtCurrentState() {
        return this.getStateVarVal(ConstAccelCurveStateVarSymbol.TIME_OFFSET);
    }

    public void setInitPosition(RN initPos) {
        this.setStateVarVal(ConstAccelCurveStateVarSymbol.INIT_POS, initPos);
    }

    public void setInitVelocity(RN initVel) {
        this.setStateVarVal(ConstAccelCurveStateVarSymbol.INIT_VEL, initVel);
    }

    public void setConstAccel(RN constAccel) {
        this.setStateVarVal(ConstAccelCurveStateVarSymbol.CONST_ACCEL, constAccel);
    }

    public void setTimeOffset(RN timeOffset) {
        this.setStateVarVal(ConstAccelCurveStateVarSymbol.TIME_OFFSET, timeOffset);
    }

    public RN makeNumber(double dval) {
        return (RN)this.myNumberFactory.makeNumberFromDouble(dval);
    }

    public void configureWithDoubles(double timeOffset, double constAccel, double initPos, double initVel) {
        this.setTimeOffset(this.makeNumber(timeOffset));
        this.setConstAccel(this.makeNumber(constAccel));
        this.setInitPosition(this.makeNumber(initPos));
        this.setInitVelocity(this.makeNumber(initVel));
    }
}

