/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curvematrix;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cogchar.animoid.calc.curve.CAC_FunctionDerivatives;
import org.cogchar.animoid.calc.curve.ConstAccelCurve;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveMatrix;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveSequence;
import org.jscience.mathematics.function.Polynomial;
import org.jscience.mathematics.number.Real;
import org.jscience.mathematics.vector.Float64Vector;

public class CACM_Polynomial {
    ConstAccelCurveMatrix myCurveMatrix;
    Polynomial<Real> myPolynomial;
    Map<ConstAccelCurve, CAC_FunctionDerivatives> myDerivativesMap;

    public CACM_Polynomial(ConstAccelCurveMatrix curveMatrix, Polynomial func) {
        this.myCurveMatrix = curveMatrix;
        this.myPolynomial = func;
        this.buildDerivativesMap();
    }

    private void buildDerivativesMap() {
        this.myDerivativesMap = new HashMap<ConstAccelCurve, CAC_FunctionDerivatives>();
        List seqs = this.myCurveMatrix.getSequences();
        for (ConstAccelCurveSequence constAccelCurveSequence : seqs) {
            int stepCount = constAccelCurveSequence.getStepCount();
            for (int i = 0; i < stepCount; ++i) {
                ConstAccelCurve curve = constAccelCurveSequence.getStepCurve(i);
                CAC_FunctionDerivatives derivs = new CAC_FunctionDerivatives(curve, this.myPolynomial);
                this.myDerivativesMap.put(curve, derivs);
            }
        }
    }

    private Float64Vector getDerivativeValuesAtCurrentPos() {
        return null;
    }
}

