/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curvematrix;

import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.curve.ConstAccelCurve;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveSequence;
import org.cogchar.animoid.calc.curvematrix.RampingFramedCACM;
import org.cogchar.animoid.calc.optimize.ParameterVector;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.number.Number;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RampingFramedCurveSeq<RN extends Number<RN>>
extends ConstAccelCurveSequence<RN> {
    private static Logger theLogger = LoggerFactory.getLogger((String)RampingFramedCurveSeq.class.getName());
    public double minWorldPosDeg;
    public double maxWorldPosDeg;
    public double maxVelMagDPS;
    public double maxAccelMagPerFrame;
    public double maxDecelMagPerFrame;
    public double initWorldVelDPS;
    public double initWorldPosDeg;
    public double postIBWorldVelDPS;
    public double goalDirectionSign;
    public double frameLenSec;

    public RampingFramedCurveSeq(String name, NumberFactory<RN> numberFactory) {
        super(name, numberFactory);
        this.setupCurves();
    }

    private void setupCurves() {
        String seqName = this.getName();
        for (Phase p : Phase.values()) {
            String nameSuffix = p.name();
            String curveSymbolSuffix = seqName + "_" + nameSuffix;
            Variable.Local timeOffsetVar = new Variable.Local("_t_" + nameSuffix);
            ConstAccelCurve curve = new ConstAccelCurve(curveSymbolSuffix, timeOffsetVar, this.getNumberFactory());
            this.addStepCurve(curve);
        }
    }

    public double getSignedInitProgressRateDPS() {
        return this.initWorldVelDPS * this.goalDirectionSign;
    }

    private RN getEndPositionForCurrentParams() {
        this.propagateEndpointConditions();
        Object totalDuration = this.getTotalDuration();
        Object endPos = this.getPosAtTime(totalDuration);
        return endPos;
    }

    private double getYieldForPosition(double endPosVal) {
        double deltaPos = endPosVal - this.initWorldPosDeg;
        double yield = this.goalDirectionSign * deltaPos;
        return yield;
    }

    private double getYieldForCurrentParamsIgnoringPosConstraints() {
        RN endPos = this.getEndPositionForCurrentParams();
        return this.getYieldForPosition(endPos.doubleValue());
    }

    public RN getYieldForCurrentParamsWithPosConstraints(String dbgHeader, double truncationWarningThresh, double negativeYieldWarningThresh) {
        double yield;
        RN endPos = this.getEndPositionForCurrentParams();
        double endPosVal = endPos.doubleValue();
        if (endPosVal > this.maxWorldPosDeg) {
            if (endPosVal - this.maxWorldPosDeg > truncationWarningThresh) {
                theLogger.trace(dbgHeader + "[seqName=" + this.getName() + "] truncating endPosVal from " + endPosVal + " to max=" + this.maxWorldPosDeg);
            }
            endPosVal = this.maxWorldPosDeg;
        }
        if (endPosVal < this.minWorldPosDeg) {
            if (this.minWorldPosDeg - endPosVal > truncationWarningThresh) {
                theLogger.trace(dbgHeader + "[seqName=" + this.getName() + "] truncating endPosVal from " + endPosVal + " to min=" + this.minWorldPosDeg);
            }
            endPosVal = this.minWorldPosDeg;
        }
        if ((yield = this.getYieldForPosition(endPosVal)) < negativeYieldWarningThresh) {
            theLogger.warn(dbgHeader + "[seqName=" + this.getName() + "] got negative yield: " + yield + " on curveSeq=" + this.toString() + ",  endPos=" + endPosVal + ", totalDur=" + this.getTotalDuration() + ", initProgessRateDPS=" + this.getSignedInitProgressRateDPS() + ", minFramesToStopFromInit=" + this.minFramesToStopFromInitVel());
        }
        return (RN)this.getNumberFactory().makeNumberFromDouble(yield);
    }

    public void syncInitialConditions() {
        Number initPosRN = this.getNumberFactory().makeNumberFromDouble(this.initWorldPosDeg);
        Number initVelRN = this.getNumberFactory().makeNumberFromDouble(this.initWorldVelDPS);
        this.setInitialConditions(initPosRN, initVelRN);
    }

    public int minFramesToStopFromInitVel() {
        double initVelMag = Math.abs(this.initWorldVelDPS);
        return RampingFramedCACM.minFramesToChangeSpeed(initVelMag, this.maxDecelMagPerFrame);
    }

    private double initBrakingTargetProgressRate() {
        double initProgressRateDPS;
        double initialTargetRate = initProgressRateDPS = this.getSignedInitProgressRateDPS();
        if (initProgressRateDPS < 0.0) {
            initialTargetRate = 0.0;
        } else if (initProgressRateDPS > this.maxVelMagDPS) {
            initialTargetRate = this.maxVelMagDPS;
        }
        return initialTargetRate;
    }

    public void establishParamsForMaxYieldIgnoringPosConstraints(int frameCount) {
        double actualPeakVel;
        double softDecelFrameVal;
        int brakeFramesBareMin = this.minFramesToStopFromInitVel();
        if (frameCount < brakeFramesBareMin) {
            throw new RuntimeException("Can't even stop from initVel in allowed frames");
        }
        double initProgressRateDPS = this.getSignedInitProgressRateDPS();
        double progRatePostIB = this.initBrakingTargetProgressRate();
        this.postIBWorldVelDPS = this.goalDirectionSign * progRatePostIB;
        double ibSignedDeltaVel = this.postIBWorldVelDPS - this.initWorldVelDPS;
        double ibdvMag = Math.abs(ibSignedDeltaVel);
        int ibFrameCount = 0;
        if (ibdvMag > 0.001) {
            ibFrameCount = RampingFramedCACM.minFramesToChangeSpeed(ibdvMag, this.maxDecelMagPerFrame);
        }
        if (ibFrameCount > frameCount) {
            throw new RuntimeException("We don't even have time for initial braking manuever!");
        }
        if (ibFrameCount >= frameCount - 1) {
            progRatePostIB = 0.0;
            this.postIBWorldVelDPS = 0.0;
            ibSignedDeltaVel = -1.0 * this.initWorldVelDPS;
            ibdvMag = Math.abs(ibSignedDeltaVel);
            ibFrameCount = frameCount;
        }
        double ibAccelDPSPS = ibFrameCount > 0 ? ibSignedDeltaVel / ((double)ibFrameCount * this.frameLenSec) : 0.0;
        int postIBframeCount = frameCount - ibFrameCount;
        int framesHardUp = this.maxPossibleHardUpFrames(postIBframeCount);
        int framesPostHU = postIBframeCount - framesHardUp;
        double progRatePostHardUp = progRatePostIB + (double)framesHardUp * this.maxAccelMagPerFrame;
        double absPRPHU = Math.abs(progRatePostHardUp);
        int minBrakeFrames = 0;
        if (absPRPHU > 0.001) {
            minBrakeFrames = RampingFramedCACM.minFramesToChangeSpeed(absPRPHU, this.maxDecelMagPerFrame);
        }
        double peakLegitVelMag = progRatePostHardUp;
        int framesSoftUp = 0;
        int framesCoast = 0;
        int framesSoftDn = 1;
        int framesHardDn = 0;
        framesHardDn = minBrakeFrames - framesSoftDn;
        if (minBrakeFrames > framesPostHU) {
            throw new RuntimeException("CalcError[" + this.getName() + "]: Can't stop after hardUp phase " + ", totalFrameCount=" + frameCount + ", progRatePostHU=" + progRatePostHardUp + ", minBrakeFrames=" + minBrakeFrames + ", framesPostHU=" + framesPostHU + ", ibFrameCount=" + ibFrameCount + ", framesHardUp=" + framesHardUp);
        }
        if (minBrakeFrames < framesPostHU) {
            framesSoftUp = 1;
        }
        framesCoast = framesPostHU - framesSoftUp - framesSoftDn - framesHardDn;
        ParameterVector durPV = new ParameterVector(this.getNumberFactory());
        durPV.setLength(Phase.values().length);
        durPV.setValue(Phase.BRAKE_INIT.ordinal(), (double)ibFrameCount * this.frameLenSec);
        durPV.setValue(Phase.ACCEL_HARD.ordinal(), (double)framesHardUp * this.frameLenSec);
        durPV.setValue(Phase.ACCEL_SOFT.ordinal(), (double)framesSoftUp * this.frameLenSec);
        durPV.setValue(Phase.COAST.ordinal(), (double)framesCoast * this.frameLenSec);
        durPV.setValue(Phase.BRAKE_SOFT.ordinal(), (double)framesSoftDn * this.frameLenSec);
        durPV.setValue(Phase.BRAKE_HARD.ordinal(), (double)framesHardDn * this.frameLenSec);
        this.setDurationParams(durPV);
        ParameterVector accPV = new ParameterVector(this.getNumberFactory());
        accPV.setLength(Phase.values().length);
        accPV.setValue(Phase.BRAKE_INIT.ordinal(), ibAccelDPSPS);
        accPV.setValue(Phase.ACCEL_HARD.ordinal(), this.goalDirectionSign * this.maxAccelMagPerFrame / this.frameLenSec);
        accPV.setValue(Phase.COAST.ordinal(), 0.0);
        accPV.setValue(Phase.BRAKE_HARD.ordinal(), -1.0 * this.goalDirectionSign * this.maxDecelMagPerFrame / this.frameLenSec);
        double softAccelFrameMag = 0.0;
        if (framesSoftUp == 1) {
            double maxTotalDecel = this.maxDecelMagPerFrame * (double)(framesHardDn + framesSoftDn);
            double excessDecel = maxTotalDecel - peakLegitVelMag;
            if (excessDecel < 0.0) {
                throw new RuntimeException("CalcError[" + this.getName() + "]:  can't stop from peakVel even before softAccel added");
            }
            double peakVelHeadroom = this.maxVelMagDPS - peakLegitVelMag;
            if (peakVelHeadroom < 0.0) {
                peakVelHeadroom = 0.0;
            }
            softAccelFrameMag = Math.min(excessDecel, peakVelHeadroom);
        }
        if ((softDecelFrameVal = (actualPeakVel = peakLegitVelMag + softAccelFrameMag) - (double)framesHardDn * this.maxDecelMagPerFrame) > this.maxDecelMagPerFrame + 0.1) {
            throw new RuntimeException("CalcError[" + this.getName() + "]:  softDecelFrameVal " + softDecelFrameVal + " exceeds max!");
        }
        accPV.setValue(Phase.ACCEL_SOFT.ordinal(), this.goalDirectionSign * softAccelFrameMag / this.frameLenSec);
        accPV.setValue(Phase.BRAKE_SOFT.ordinal(), -1.0 * this.goalDirectionSign * softDecelFrameVal / this.frameLenSec);
        this.setAccelParams(accPV);
    }

    public int maxPossibleHardUpFrames(int frameCount) {
        if (frameCount == 0) {
            return 0;
        }
        double initProgressRateDPS = this.postIBWorldVelDPS * this.goalDirectionSign;
        int validHardUpFrames = 0;
        while (true) {
            int framesToStopAfterCHA;
            int candHardUpFrames;
            double candTotalHardAccel;
            double candPeakVelMag;
            int postHardUpFrames = frameCount - validHardUpFrames;
            double validTotalHardAccelMag = (double)validHardUpFrames * this.maxAccelMagPerFrame;
            double validVelMagAfterHA = Math.abs(initProgressRateDPS + validTotalHardAccelMag);
            int framesToStopAfterHA = RampingFramedCACM.minFramesToChangeSpeed(validVelMagAfterHA, this.maxDecelMagPerFrame);
            if (framesToStopAfterHA > postHardUpFrames) {
                theLogger.error("Troubled seq dump: " + this.toString());
                throw new RuntimeException("CalcError[" + this.getName() + "]- can't stop in time:  frameCount=" + frameCount + ", postHardUpFrames=" + postHardUpFrames + ", framesToStopAfterHA=" + framesToStopAfterHA + ", ");
            }
            if (framesToStopAfterHA == postHardUpFrames || (candPeakVelMag = initProgressRateDPS + (candTotalHardAccel = (double)(candHardUpFrames = validHardUpFrames + 1) * this.maxAccelMagPerFrame)) > this.maxVelMagDPS || (framesToStopAfterCHA = RampingFramedCACM.minFramesToChangeSpeed(Math.abs(candPeakVelMag), this.maxDecelMagPerFrame)) > frameCount - candHardUpFrames) break;
            validHardUpFrames = candHardUpFrames;
        }
        if (initProgressRateDPS > this.maxVelMagDPS && validHardUpFrames != 0) {
            throw new RuntimeException("initProgressRateDPS=" + initProgressRateDPS + ", maxVelMagDPS=" + this.maxVelMagDPS + ", validHardUpFrames=" + validHardUpFrames);
        }
        return validHardUpFrames;
    }

    public void lowerYieldToTargetValueByReducingAccel(double targetYield) {
        double currentUnconstrainedYield = this.getYieldForCurrentParamsIgnoringPosConstraints();
        if (targetYield > currentUnconstrainedYield) {
            throw new RuntimeException("CalcError[" + this.getName() + "]: requested targetYield: " + targetYield + " is higher than current unconstrained yield " + currentUnconstrainedYield);
        }
        double yieldRatio = targetYield / currentUnconstrainedYield;
    }

    @Override
    public String toString() {
        return "CurveSeq[name=" + this.getName() + ", minPos=" + this.minWorldPosDeg + ", maxPos=" + this.maxWorldPosDeg + ", maxVelMag=" + this.maxVelMagDPS + ", maxAccelMagPerFrame=" + this.maxAccelMagPerFrame + ", maxDecelMagPerFrame=" + this.maxDecelMagPerFrame + ", initVel=" + this.initWorldVelDPS + ", initPos=" + this.initWorldPosDeg + ", postIBWorldVelDPS=" + this.postIBWorldVelDPS + ", goalDirectionSign=" + this.goalDirectionSign + ", frameLenSec=" + this.frameLenSec + ", super=" + super.toString() + "]";
    }

    public static enum Phase {
        BRAKE_INIT,
        ACCEL_HARD,
        ACCEL_SOFT,
        COAST,
        BRAKE_SOFT,
        BRAKE_HARD;

    }
}

