/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.optimize;

import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.jscience.mathematics.function.Function;
import org.jscience.mathematics.number.Number;

public class ParameterVector<RN extends Number<RN>> {
    private int myLength;
    private double[] myValues;
    public double[] myPenalties;
    public double myBulkPenalty;
    private RN[] myNumbers;
    private NumberFactory<RN> myNumberFactory;

    public ParameterVector(NumberFactory<RN> numberFactory) {
        this.myNumberFactory = numberFactory;
    }

    public void setLength(int l) {
        this.myLength = l;
        this.myValues = new double[this.myLength];
        this.myPenalties = new double[this.myLength];
        this.myNumbers = this.myNumberFactory.makeArray(this.myLength);
    }

    public int getLength() {
        return this.myLength;
    }

    public void setValue(int i, double v) {
        if (v != this.myValues[i]) {
            this.myValues[i] = v;
            this.myNumbers[i] = null;
        }
    }

    public double getValue(int i) {
        return this.myValues[i];
    }

    public RN getNumber(int i) {
        if (this.myNumbers[i] == null) {
            this.myNumbers[i] = this.myNumberFactory.makeNumberFromDouble(this.getValue(i));
        }
        return this.myNumbers[i];
    }

    public void setAllValues(double v) {
        for (int i = 0; i < this.myLength; ++i) {
            this.setValue(i, v);
        }
    }

    public void setPenalty(int i, double v, boolean incremental) {
        if (incremental) {
            int n = i;
            this.myPenalties[n] = this.myPenalties[n] + v;
        } else {
            this.myPenalties[i] = v;
        }
    }

    public void setAllPenalties(double pv, boolean incremental) {
        for (int i = 0; i < this.myLength; ++i) {
            this.setPenalty(i, pv, incremental);
        }
    }

    public void readValuesFromArray(double[] array, int arrayIndexStart, int internalIndexStart, int numVals) {
        for (int idx = 0; idx < numVals; ++idx) {
            this.setValue(internalIndexStart + idx, array[arrayIndexStart + idx]);
        }
    }

    public void writeValuesToArray(double[] array, int arrayIndexStart, int internalIndexStart, int numVals) {
        for (int idx = 0; idx < numVals; ++idx) {
            array[arrayIndexStart + idx] = this.getValue(internalIndexStart + idx);
        }
    }

    public String toString() {
        return "ParameterVector[values=" + ParameterVector.doubleArrayToString(this.myValues) + ",\npenalties=" + ParameterVector.doubleArrayToString(this.myPenalties) + "]";
    }

    public double getPenalty(int i) {
        return this.myPenalties[i];
    }

    public void applyPenaltyFunction(Function pfunc) {
        throw new RuntimeException("Not Implemented");
    }

    public double sumLeadingValues(int numVals) {
        double sum = 0.0;
        for (int i = 0; i < numVals; ++i) {
            sum += this.getValue(i);
        }
        return sum;
    }

    public Integer findIndexWithinImpliedSum(double val) {
        double sum = 0.0;
        for (int idx = 0; idx < this.myLength; ++idx) {
            if (!((sum += this.getValue(idx)) >= val)) continue;
            return idx;
        }
        return null;
    }

    public double sumValues() {
        return this.sumLeadingValues(this.myLength);
    }

    public double sumIndividualPenalties() {
        double sum = 0.0;
        for (int i = 0; i < this.myLength; ++i) {
            sum += this.getPenalty(i);
        }
        return sum;
    }

    public double totalPenalties() {
        return this.sumIndividualPenalties() + this.myBulkPenalty;
    }

    public void reduceAllAndPenalizeProportionally(double reductAmt, double penaltyMult) {
        throw new RuntimeException("Not Implemented");
    }

    public static String doubleArrayToString(double[] array) {
        StringBuffer buffer = new StringBuffer("[(length=" + array.length + ")");
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static double sumSquaredDoubleArray(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i] * arr[i];
        }
        return sum;
    }
}

