/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.trajectory;

import org.appdapter.bind.math.jscience.function.BumpUF;
import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.trajectory.BoundaryStyle;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointVelocityAROMPS;
import org.cogchar.api.animoid.world.WorldJoint;
import org.jscience.mathematics.number.Number;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JointAngleTrajectory<TimeType extends Number<TimeType>, AngleType extends Number<AngleType>> {
    private static Logger theLogger = LoggerFactory.getLogger((String)JointAngleTrajectory.class.getName());
    protected WorldJoint myWorldJoint;
    protected double myTimeUnitsPerSecond;
    private NumberFactory<TimeType> myTimeFactory;
    protected BoundaryStyle myBoundaryStyle;

    protected abstract BumpUF<TimeType, AngleType> getBumpFunction();

    public JointAngleTrajectory(WorldJoint wj, double timeUnitsPerSecond, NumberFactory<TimeType> timeFactory, BoundaryStyle boundaryStyle) {
        this.myWorldJoint = wj;
        this.myTimeUnitsPerSecond = timeUnitsPerSecond;
        this.myTimeFactory = timeFactory;
        this.myBoundaryStyle = boundaryStyle;
    }

    protected double getWorldAnglePosAtTime(double time) {
        BumpUF<TimeType, AngleType> bumpUF = this.getBumpFunction();
        Number timeVal = this.myTimeFactory.makeNumberFromDouble(time);
        Number angleVal = (Number)bumpUF.getOutputForInput((Object)timeVal);
        return angleVal.doubleValue();
    }

    protected double getWorldAngleSpeedAtTime(double time) {
        BumpUF<TimeType, AngleType> bumpUF = this.getBumpFunction();
        Number timeVal = this.myTimeFactory.makeNumberFromDouble(time);
        Number speedVal = (Number)bumpUF.getDerivativeAtInput((Object)timeVal, 1);
        return speedVal.doubleValue();
    }

    protected double getRomPosAtTime(double time) {
        double angleVal = this.getWorldAnglePosAtTime(time);
        double romPos = this.myWorldJoint.getROM_posForWorldAngleDeg(angleVal);
        return romPos;
    }

    protected double getRomVelAtTime(double time) {
        double speedVal = this.getWorldAngleSpeedAtTime(time);
        double romSpeed = this.myWorldJoint.getROM_velForWorldAngleSpeed(speedVal);
        return romSpeed;
    }

    public JointPosition getJointPosAtTime(double time) {
        double romPos = this.getRomPosAtTime(time);
        return this.myWorldJoint.getJoint().makeJointPosForROM_value(romPos);
    }

    public JointVelocityAROMPS getJointVelAtTime(double time) {
        double velRomPS = this.getRomVelAtTime(time);
        return this.myWorldJoint.getJoint().makeJointVelForROM_speedValue(velRomPS);
    }
}

