/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.cogchar.animoid.job.MotionJob;
import org.cogchar.api.animoid.config.bonus.AnimoidConfig;
import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.JVFrame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointPositionAROM;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.zzz.platform.stub.JobStub;

public class VisemeJob
extends MotionJob {
    private int myCurrentVisemeNumber;
    private int myNextVisemeNumber;
    private Frame<JointPositionAROM> myCurrentFrame;
    private Frame<JointPositionAROM> myNextFrame;
    private double myNominalSecPerFrame;
    private boolean isSilent;
    public static boolean extendDuration = false;

    public VisemeJob(AnimoidConfig aconf, double secsPerFrame) {
        super(aconf);
        this.myNominalSecPerFrame = secsPerFrame;
        this.isSilent = true;
    }

    public void setCurrentVisemeNumber(int cvn) {
        this.myCurrentVisemeNumber = cvn;
    }

    public void setNextVisemeNumber(int nvn) {
        this.myNextVisemeNumber = nvn;
    }

    public void setDurationMillisec(long duration) {
        this.scheduleForIntervalStartingNow(duration);
    }

    public Long getDurationMillisec() {
        Long dur = this.getSchedDuration();
        if (dur == null) {
            dur = 0L;
        }
        return dur;
    }

    public String getTypeString() {
        return "VisemeJob";
    }

    public String getContentSummaryString() {
        return "curVisNum=" + this.myCurrentVisemeNumber + ", nextVisNum" + this.myNextVisemeNumber + ", durationMillisec=" + this.getDurationMillisec();
    }

    public Frame<JointPositionAROM> getCurrentTargetPosFrame() {
        return this.myCurrentFrame;
    }

    public void setCurrentTargetPosFrame(Frame<JointPositionAROM> currentFrame) {
        this.myCurrentFrame = currentFrame;
    }

    public Frame<JointPositionAROM> getNextTargetPosFrame() {
        return this.myNextFrame;
    }

    public void setNextTargetPosFrame(Frame<JointPositionAROM> nextFrame) {
        this.myNextFrame = nextFrame;
    }

    @Override
    public Collection<Joint> getCautionJoints() {
        return new ArrayList<Joint>();
    }

    @Override
    public JVFrame contributeVelFrame(Frame prevPosAbsRomFrame, JVFrame prevVelRomFrame, Set<Joint> cautionJoints) {
        if (this.getStatus() == JobStub.Status.RUNNING) {
            if (this.myCurrentFrame == null) {
                return null;
            }
            Double frameRateMsec = this.myNominalSecPerFrame * 1000.0;
            if (this.myCurrentVisemeNumber == 0 && this.myNextVisemeNumber == 0) {
                if (this.isSilent) {
                    return null;
                }
                this.isSilent = true;
                this.setDurationMillisec(frameRateMsec.longValue());
            } else {
                this.isSilent = false;
            }
            long durationMsec = this.getDurationMillisec();
            Double frameCount = (double)durationMsec / frameRateMsec;
            Double currWeight = 0.0;
            Double nextWeight = 1.0;
            if ((double)durationMsec < frameRateMsec) {
                currWeight = (double)durationMsec / frameRateMsec;
                currWeight = Math.min(Math.max(currWeight, 0.0), 1.0);
                nextWeight = 1.0 - currWeight;
            }
            Frame startFrame = new Frame();
            Frame<JointPosition> endFrame = new Frame<JointPosition>();
            for (JointPositionAROM jp : this.myCurrentFrame.getAllPositions()) {
                Joint j = jp.getJoint();
                startFrame.addPosition(prevPosAbsRomFrame.getJointPositionForJoint(j));
                JointPositionAROM nextVisemeJP = this.myNextFrame.getJointPositionForJoint(j);
                JointPosition endJP = JointPosition.weightedSumJointPositions(jp, currWeight, nextVisemeJP, nextWeight);
                endFrame.addPosition(endJP);
            }
            Frame velFrame = Frame.computeDerivativeFrame(JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC, startFrame, endFrame, this.myNominalSecPerFrame);
            if (extendDuration) {
                velFrame.multiplyByScalar(1.0 / frameCount);
            }
            return JVFrame.makeFrom(velFrame);
        }
        return null;
    }

    public void setNominalSecPerFrame(double nominalSecPerFrame) {
        this.myNominalSecPerFrame = nominalSecPerFrame;
    }
}

