/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.oldconfig;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMatrixFuncs {
    private static Logger theLogger = LoggerFactory.getLogger(StringMatrixFuncs.class);

    public static String[][] readDataIntoMatrix(LineNumberReader lnr) throws Throwable {
        String line;
        String[][] result = null;
        ArrayList<String[]> rowList = new ArrayList<String[]>();
        do {
            int lineNumber = lnr.getLineNumber();
            line = lnr.readLine();
            theLogger.debug("Got line # " + lineNumber + " : " + line);
            if (line == null) continue;
            if (!line.startsWith("#")) {
                String[] tokens = line.split("\\s*,\\s*");
                theLogger.debug("Got " + tokens.length + " tokens");
                rowList.add(tokens);
                continue;
            }
            theLogger.debug("Skipping comment line");
        } while (line != null);
        result = new String[rowList.size()][];
        rowList.toArray((T[])result);
        return result;
    }

    public static boolean verifyMatrixWidth(String[][] matrix, int expectedColumnCount) {
        for (int i = 0; i < matrix.length; ++i) {
            if (matrix[i].length == expectedColumnCount) continue;
            theLogger.error("Expected " + expectedColumnCount + " columns, but found " + matrix[i].length + " columns in row " + i);
            return false;
        }
        return true;
    }

    public static String[][] readAndVerifyMatrixFile(String filename) throws Throwable {
        boolean widthOK;
        FileReader fr = new FileReader(filename);
        LineNumberReader lnr = new LineNumberReader(fr);
        String[][] matrix = StringMatrixFuncs.readDataIntoMatrix(lnr);
        lnr.close();
        fr.close();
        int numColumns = matrix[0].length;
        if (numColumns > 0 && !(widthOK = StringMatrixFuncs.verifyMatrixWidth(matrix, numColumns))) {
            throw new Exception("File " + filename + " contains rows not matching expected width: " + numColumns);
        }
        theLogger.trace("Read String[][] matrix of " + matrix.length + " rows, and verified column width");
        return matrix;
    }
}

