/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.config.bonus;

import java.io.Serializable;
import org.cogchar.animoid.oldconfig.IntMatrixFuncs;
import org.cogchar.api.animoid.config.bonus.MuscleJoint;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.platform.util.BoundsAssertions;

public class ServoChannelConfig
implements Serializable {
    public int physicalChannel;
    public int roboardChannel;
    public int logicalChannel;
    public boolean inverted;
    public int defaultPos;
    public int minPos;
    public int maxPos;

    public MuscleJoint getMuscleJoint() {
        return MuscleJoint.findJointForID(this.logicalChannel);
    }

    public static ServoChannelConfig[] readServoConfigFile(String filename, int maxChannels) throws Throwable {
        int[][] servoConfigRows = IntMatrixFuncs.readAndVerifyMatrixFile(filename, 7);
        ServoChannelConfig[] servoConfArray = ServoChannelConfig.buildValidServoConfigArray(servoConfigRows, maxChannels);
        return servoConfArray;
    }

    public static ServoChannelConfig[] buildValidServoConfigArray(int[][] rawServoConf, int numChannels) throws Throwable {
        ServoChannelConfig[] confArray = new ServoChannelConfig[numChannels];
        for (int i = 0; i < rawServoConf.length; ++i) {
            int rbChan;
            int[] rawServoRow = rawServoConf[i];
            for (int j = 0; j < rawServoRow.length; ++j) {
                System.out.print("" + rawServoRow[j] + ", ");
            }
            System.out.println();
            int physChan = rawServoRow[0];
            BoundsAssertions.checkInclusiveBounds((int)physChan, (int)0, (int)(numChannels - 1), (String)"Physical channel number");
            if (confArray[physChan] != null) {
                throw new Exception("Got duplicate configuration entries for physical servo channel " + physChan);
            }
            ServoChannelConfig scc = new ServoChannelConfig();
            scc.physicalChannel = physChan;
            scc.roboardChannel = rbChan = rawServoRow[6];
            System.out.println(scc.roboardChannel);
            scc.logicalChannel = rawServoRow[1];
            int inversionValue = rawServoRow[2];
            BoundsAssertions.checkInclusiveBounds((int)inversionValue, (int)0, (int)1, (String)("InversionFlag on channel " + physChan));
            scc.inverted = inversionValue == 1;
            scc.minPos = rawServoRow[4];
            BoundsAssertions.checkInclusiveBounds((int)scc.minPos, (int)0, (int)250, (String)("Servo minimum position on channel " + physChan));
            scc.maxPos = rawServoRow[5];
            BoundsAssertions.checkInclusiveBounds((int)scc.maxPos, (int)scc.minPos, (int)250, (String)("Servo maximum position on channel " + physChan));
            scc.defaultPos = rawServoRow[3];
            BoundsAssertions.checkInclusiveBounds((int)scc.defaultPos, (int)scc.minPos, (int)scc.maxPos, (String)("Servo default position on channel " + physChan));
            confArray[physChan] = scc;
        }
        return confArray;
    }

    public static ServoChannelConfig findConfigForLogicalChannel(ServoChannelConfig[] configArray, int logicalChannel) {
        ServoChannelConfig result = null;
        for (int i = 0; i < configArray.length; ++i) {
            ServoChannelConfig scc = configArray[i];
            if (scc == null || configArray[i].logicalChannel != logicalChannel) continue;
            result = configArray[i];
            break;
        }
        return result;
    }

    public double convertAbsServoIntToLopsidedFloat(int servoPos) {
        int defP = this.defaultPos;
        int minP = this.minPos;
        int maxP = this.maxPos;
        double lowSideRange = (double)defP - (double)minP;
        double highSideRange = (double)maxP - (double)defP;
        double mjValue = servoPos == defP ? 0.0 : (servoPos < defP ? (double)(servoPos - defP) / lowSideRange : (double)(servoPos - defP) / highSideRange);
        if (this.inverted) {
            mjValue *= -1.0;
        }
        return mjValue;
    }

    public double convertLopsidedFloatToROM(double lopsidedPos) throws Throwable {
        return Joint.convertLopsidedFloatToROM(lopsidedPos, this.minPos, this.maxPos, this.defaultPos, this.inverted);
    }
}

