/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointPositionAROM;
import org.cogchar.api.animoid.protocol.JointPositionRROM;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;

public class Animation
implements Serializable {
    private String myName;
    private Double myFramePeriodSeconds;
    private transient List<Frame> myFrameList = new ArrayList<Frame>();

    public Animation(String name, Double framePeriodSeconds) {
        this.myName = name;
        this.myFramePeriodSeconds = framePeriodSeconds;
    }

    public String getName() {
        return this.myName;
    }

    public Double getFramePeriodSeconds() {
        return this.myFramePeriodSeconds;
    }

    public int getFrameCount() {
        return this.myFrameList.size();
    }

    public Frame getFrameAt(int idx) {
        return this.myFrameList.get(idx);
    }

    public void appendFrame(Frame f) {
        this.myFrameList.add(f);
    }

    public void appendEmptyFrames(int quantity) {
        for (int i = 0; i < quantity; ++i) {
            Frame f = new Frame();
            this.appendFrame(f);
        }
    }

    public Set<Joint> getUsedJointSet() {
        HashSet<Joint> usedJoints = new HashSet<Joint>();
        for (Frame f : this.myFrameList) {
            usedJoints.addAll(f.getUsedJointSet());
        }
        return usedJoints;
    }

    public Frame getPartialFrameInCoordinateSystem(int idx, Set<Joint> jointSet, JointStateCoordinateType queryCT) {
        Frame srcFrame = this.getFrameAt(idx);
        Frame prevSrcFrame = null;
        if (idx > 0) {
            prevSrcFrame = this.getFrameAt(idx - 1);
            prevSrcFrame.verifyCoordinateTypeCompatibility(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        }
        srcFrame.verifyCoordinateTypeCompatibility(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        Frame resultF = new Frame();
        for (Joint j : jointSet) {
            Object srcJP = srcFrame.getJointPositionForJoint(j);
            if (srcJP == null) {
                throw new RuntimeException("Null src JP for " + j + ", currIdx=" + idx);
            }
            if (queryCT.equals((Object)JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION)) {
                resultF.addPosition(srcJP);
                continue;
            }
            if (!queryCT.equals((Object)JointStateCoordinateType.FLOAT_REL_RANGE_OF_MOTION)) continue;
            JointPositionAROM srcJPAR = new JointPositionAROM((JointPosition)srcJP);
            if (prevSrcFrame == null) continue;
            Object prevSrcJP = prevSrcFrame.getJointPositionForJoint(j);
            if (prevSrcJP == null) {
                throw new RuntimeException("Null previous JP for " + j + ", currIdx=" + idx);
            }
            JointPositionAROM prevSrcJPAR = new JointPositionAROM((JointPosition)prevSrcJP);
            JointPositionRROM relJP = prevSrcJPAR.computeDeltaRelPos(srcJPAR);
            resultF.addPosition(relJP);
        }
        return resultF;
    }
}

