/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;
import org.cogchar.api.animoid.protocol.SmallAngle;

public class EgocentricDirection
implements Serializable {
    private SmallAngle myAzimuth;
    private SmallAngle myElevation;
    private static EgocentricDirection theForwardDirection = null;

    public EgocentricDirection(SmallAngle az, SmallAngle el) {
        this.myAzimuth = az;
        this.myElevation = el;
    }

    public static EgocentricDirection makeFromRad(double azRad, double elRad) {
        SmallAngle az = SmallAngle.makeFromRad(azRad);
        SmallAngle el = SmallAngle.makeFromRad(elRad);
        return new EgocentricDirection(az, el);
    }

    public static EgocentricDirection makeFromDeg(double azDeg, double elDeg) {
        SmallAngle az = SmallAngle.makeFromDeg(azDeg);
        SmallAngle el = SmallAngle.makeFromDeg(elDeg);
        return new EgocentricDirection(az, el);
    }

    public static EgocentricDirection getForwardDirection() {
        if (theForwardDirection == null) {
            theForwardDirection = EgocentricDirection.makeFromRad(0.0, 0.0);
        }
        return theForwardDirection;
    }

    public SmallAngle getAzimuth() {
        return this.myAzimuth;
    }

    public SmallAngle getElevation() {
        return this.myElevation;
    }

    public EgocentricDirection add(EgocentricDirection other) {
        SmallAngle azSum = this.getAzimuth().add(other.getAzimuth());
        SmallAngle elSum = this.getElevation().add(other.getElevation());
        return new EgocentricDirection(azSum, elSum);
    }

    public EgocentricDirection subtract(EgocentricDirection other) {
        SmallAngle azDiff = this.getAzimuth().subtract(other.getAzimuth());
        SmallAngle elDiff = this.getElevation().subtract(other.getElevation());
        return new EgocentricDirection(azDiff, elDiff);
    }

    public SmallAngle computeDistanceAngle(EgocentricDirection other) {
        double azRadDelta = other.getAzimuth().getRadians() - this.getAzimuth().getRadians();
        double elRadDelta = other.getElevation().getRadians() - this.getElevation().getRadians();
        double distanceRad = Math.sqrt(azRadDelta * azRadDelta + elRadDelta * elRadDelta);
        return SmallAngle.makeFromRad(distanceRad);
    }

    public String toString() {
        return "[EgoDir azDeg=" + this.myAzimuth.getDegreesText() + ", elDeg=" + this.myElevation.getDegreesText() + "]";
    }
}

