/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;
import org.cogchar.api.animoid.protocol.Device;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.JointVelocityAROMPS;
import org.cogchar.api.animoid.protocol.Robot;

public class Joint
implements Serializable {
    private Device myDevice;
    private Robot myRobot;
    private String myDeviceChannelID;
    private String myJointName;
    public Integer oldLogicalJointNumber;
    public Integer oldMinServoPos;
    public Integer oldMaxServoPos;
    public Integer oldDefServoPos;
    public Boolean oldInvertedFlag;
    private JointPosition myCenterPosition;

    public Joint(Device d, Robot r, String deviceChannelID, String jointName) {
        this.myDevice = d;
        this.myRobot = r;
        this.myDeviceChannelID = deviceChannelID;
        this.myJointName = jointName;
    }

    public Device getDevice() {
        return this.myDevice;
    }

    public Robot getRobot() {
        return this.myRobot;
    }

    public String getDeviceChannelID() {
        return this.myDeviceChannelID;
    }

    public String getJointName() {
        return this.myJointName;
    }

    public String getDeviceAndRobotDesc() {
        Device dev = this.getDevice();
        Robot rob = this.getRobot();
        String devDesc = "device=" + (dev != null ? dev.getName() : "NULL");
        String robDesc = "robot=" + (rob != null ? rob.getName() : "NULL");
        return devDesc + ", " + robDesc;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other == this) {
            result = true;
        }
        return result;
    }

    public JointPosition getCenterPosition() {
        if (this.myCenterPosition == null) {
            JointPosition jpAbsROM;
            JointPosition jpLopsided = new JointPosition(this);
            jpLopsided.setCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_LOPSIDED_PIECEWISE_LINEAR, 0.0);
            this.myCenterPosition = jpAbsROM = jpLopsided.convertToCooordinateType(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        }
        return this.myCenterPosition;
    }

    public double convertLopsidedFloatToROM(double lopsidedPos) throws Throwable {
        return Joint.convertLopsidedFloatToROM(lopsidedPos, this.oldMinServoPos, this.oldMaxServoPos, this.oldDefServoPos, this.oldInvertedFlag);
    }

    public double convertROMtoLopsidedFloat(double romPos) throws Throwable {
        return this.convertROMtoLopsidedFloat(romPos, this.oldMinServoPos, this.oldMaxServoPos, this.oldDefServoPos, this.oldInvertedFlag);
    }

    public static double convertLopsidedFloatToROM(double lopsidedPos, int minP, int maxP, int defP, boolean inverted) throws Throwable {
        if (lopsidedPos < -1.0 || lopsidedPos > 1.0) {
            throw new Exception("Cannot convert invalid lopsidedPos: " + lopsidedPos);
        }
        double lowSideRange = (double)defP - (double)minP;
        double highSideRange = (double)maxP - (double)defP;
        double totalRange = (double)maxP - (double)minP;
        double lowRate = lowSideRange / totalRange;
        double highRate = highSideRange / totalRange;
        double nominalLP = lopsidedPos;
        if (inverted) {
            nominalLP = -1.0 * lopsidedPos;
        }
        double nominalRP = nominalLP < 0.0 ? lowRate * (nominalLP + 1.0) : lowRate + highRate * nominalLP;
        double romPos = nominalRP;
        if (inverted) {
            romPos = 1.0 - nominalRP;
        }
        if (romPos < -1.0E-5 || romPos > 1.00001) {
            throw new Exception("Calculation went awry, romPos computed to be: " + romPos);
        }
        if (romPos < 0.0) {
            romPos = 0.0;
        }
        if (romPos > 1.0) {
            romPos = 1.0;
        }
        return romPos;
    }

    public double convertROMtoLopsidedFloat(double romPos, int minP, int maxP, int defP, boolean inverted) throws Throwable {
        double lopsidedPos;
        if (romPos < 0.0 || romPos > 1.0) {
            throw new Exception("Cannot convert invalid romPos: " + romPos);
        }
        double lowSideRange = (double)defP - (double)minP;
        double highSideRange = (double)maxP - (double)defP;
        double totalRange = (double)maxP - (double)minP;
        double lowRate = lowSideRange / totalRange;
        double highRate = highSideRange / totalRange;
        double nominalRP = romPos;
        if (inverted) {
            nominalRP = 1.0 - romPos;
        }
        double nominalLP = nominalRP < lowRate ? -1.0 + nominalRP / lowRate : (nominalRP - lowRate) / highRate;
        double d = lopsidedPos = inverted ? -1.0 * nominalLP : nominalLP;
        if (lopsidedPos < -1.00001 || lopsidedPos > 1.00001) {
            throw new Exception("Calculation went awry, lopsidedPos computed to be illegal value: " + lopsidedPos);
        }
        if (lopsidedPos < -1.0) {
            lopsidedPos = -1.0;
        }
        if (lopsidedPos > 1.0) {
            lopsidedPos = 1.0;
        }
        return lopsidedPos;
    }

    public JointPosition makeJointPosForROM_value(double romValue) {
        JointPosition posJP = new JointPosition(this);
        posJP.setCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION, romValue);
        return posJP;
    }

    public JointVelocityAROMPS makeJointVelForROM_speedValue(double velRomPS) {
        return new JointVelocityAROMPS(this, velRomPS);
    }

    public String toString() {
        return "Joint[name=" + this.getJointName() + ", channelID=" + this.getDeviceChannelID() + ", centerPos=" + this.getCenterPosition().getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION) + ", " + this.getDeviceAndRobotDesc() + "]";
    }
}

