/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointPositionRROM;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;

public class JointPositionAROM
extends JointPosition {
    private static double EQUALITY_TOLERANCE = 1.0E-4;

    public JointPositionAROM(Joint j) {
        super(j);
    }

    public JointPositionAROM(Joint j, double absRomPos) {
        this(j);
        this.setCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION, absRomPos);
    }

    public JointPositionAROM(JointPosition jp) {
        this(jp.getJoint(), jp.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION));
    }

    public double getPosAbsROM() {
        return this.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
    }

    public JointPositionRROM computeDeltaRelPos(JointPositionAROM targetJP) {
        double absPos = this.getPosAbsROM();
        double targetAbsPos = targetJP.getPosAbsROM();
        double moveDelta = targetAbsPos - absPos;
        return new JointPositionRROM(this.getJoint(), moveDelta);
    }

    public boolean equals(Object other) {
        double meCoord;
        JointPositionAROM otherJPAR;
        double otherCoord;
        double diff;
        double absDiff;
        return other != null && other instanceof JointPositionAROM && (absDiff = Math.abs(diff = (otherCoord = (otherJPAR = (JointPositionAROM)other).getPosAbsROM()) - (meCoord = this.getPosAbsROM()))) < EQUALITY_TOLERANCE;
    }
}

